<?php 
require_once '../../../../lib/configuration.inc';
require_once '../../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(9, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_date_debut, competition_date_fin, competition_golfs, competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4 FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
$nb_competitions = mysqli_num_rows($requete_competition);
if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_date_debut = $resultat_competition[0];
	$competition_date_fin = $resultat_competition[1];
	$competition_golfs = explode(',', $resultat_competition[2]);
}


// Sélection des dates enregistrées
$requete_dates = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_depart_date) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id ORDER BY planning_depart_date');
$nb_dates = mysqli_num_rows($requete_dates);
if($nb_dates!=0){
	$tab_dates = array();
	for($date_boucle=0; $date_boucle<$nb_dates; $date_boucle++){
		$resultat_date = mysqli_fetch_array($requete_dates);
		$date_competition = $resultat_date[0];

		$tab_date_competition = explode('-', $date_competition);
		$date_competition_libelle_1 = $tab_date_competition[2].' / '.$tab_date_competition[1].' / '.$tab_date_competition[0];
		$date_competition_libelle_2 = $tab_date_competition[2].' / '.$tab_date_competition[1];

		array_push($tab_dates, array($date_competition, $date_competition_libelle_1, $date_competition_libelle_2));
	}
}


// Critères de la recherche
$where = '';
if(!isset($critere_groupes)){ $critere_groupes = array(); }
if(!isset($critere_golfs)){ $critere_golfs = array(); }

if(isset($critere_dates) AND in_array('cumul', $critere_dates)==false){
	$where .= ' AND planning_depart_date IN ("'.implode('","', $critere_dates).'")';
}else{
	$critere_dates = array('cumul');
}

if(isset($critere_groupes) AND count($critere_groupes)!=0){
	$where .= ' AND planning_groupe IN ("'.implode('","', $critere_groupes).'")';
}

if(isset($critere_golfs) AND count($critere_golfs)!=0){

	$where .= ' AND (';
	foreach($critere_golfs as $golf_cle=>$golf_selection){
		$where .= 'golf_id='.$golf_selection.' OR ';
	}
	$where = substr($where, 0, -4).')';

}


$tab_joueurs_pros_abandonnes = array();
$liste_joueurs_pros_abondonnes = '';

// Sélection des joueurs professionnels qui ont abandonnés
$requete_joueurs_pros_abandonnes = mysqli_query($connexion_mysql, 'SELECT equipe_id FROM scores WHERE score_joueur_pro_abandon=1');
$nb_joueurs_pros_abandonnes = mysqli_num_rows($requete_joueurs_pros_abandonnes);
if($nb_joueurs_pros_abandonnes!=0){
	for($joueur_pro_abandonne_boucle=0; $joueur_pro_abandonne_boucle<$nb_joueurs_pros_abandonnes; $joueur_pro_abandonne_boucle++){
		$resultat_joueur_pro_abandonne = mysqli_fetch_array($requete_joueurs_pros_abandonnes);
		$joueur_pro_abondonne_id = $resultat_joueur_pro_abandonne[0];

		array_push($tab_joueurs_pros_abandonnes, $joueur_pro_abondonne_id);		// Tableau stockant le numéro du classement des joueurs pros

	}
	$tab_joueurs_pros_abandonnes = array_unique($tab_joueurs_pros_abandonnes);
	$liste_joueurs_pros_abondonnes = implode('","', $tab_joueurs_pros_abandonnes);
}

// echo '//'.$liste_joueurs_pros_abondonnes.'//<br><br>';

// echo 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.competition_id="'.$competition_id.'" AND A.equipe_id NOT IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.'  GROUP BY A.equipe_id ORDER BY (SELECT SUM(score_joueur_pro_reference) FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE A.equipe_id=equipe_selection AND planning_depart_date<="'.$competition_date_fin.'"), SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")';

// Sélection des joueurs enregistrés uniquement ceux n'ayant pas abandonnées
$requete_scores = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id NOT IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.'  GROUP BY A.equipe_id ORDER BY (SELECT SUM(score_joueur_pro_reference) FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE A.equipe_id=equipe_selection AND planning_depart_date<="'.$competition_date_fin.'"), SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');
$nb_scores = mysqli_num_rows($requete_scores);

// Sélection des joueurs enregistrés uniquement ceux ayant abandonnées
$requete_scores_abandons = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.'  GROUP BY A.equipe_id ORDER BY (SELECT SUM(score_joueur_pro_reference) FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE A.equipe_id=equipe_selection AND planning_depart_date<="'.$competition_date_fin.'"), SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');
$nb_scores_abandons = mysqli_num_rows($requete_scores_abandons);

$export_parametres = '?critere_dates='.implode(',', $critere_dates).'&critere_groupes='.implode(',', $critere_groupes).'&critere_golfs='.implode(',', $critere_golfs);

// Traitement spécifique pour le classement des joueurs pros en cas de scores identiques
//$requete_scores_nums = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE '.$where.'  GROUP BY A.equipe_id ORDER BY (SELECT SUM(score_joueur_pro_reference) FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE A.equipe_id=equipe_selection AND planning_depart_date<="'.$competition_date_fin.'" ), SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');

$requete_scores_nums = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id');

$nb_scores_nums = mysqli_num_rows($requete_scores_nums);
if($nb_scores_nums!=0){
	$tab_scores = array();

	for($score_num_boucle=0; $score_num_boucle<$nb_scores_nums; $score_num_boucle++){
		$resultat_score_num = mysqli_fetch_array($requete_scores_nums);
		$score_num_joueur_total = $resultat_score_num[1];

		array_push($tab_scores, $score_num_joueur_total);		// Tableau stockant le score total des joueurs pros

	}
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1058px;">

	<div id="contenu_3" align="left" style="width: 758px;">

		<div id="titres">
			<span class="titre_1" style="width: 606px;">Classement cumulé Pro</span>
			<?php if($nb_scores!=0){ ?><span class="ajouter" style="width: 140px;"><a href="./exporter.php<?=$export_parametres?>" target="_blank">Exporter (PDF)</a></span><?php } ?>
		</div>
		<br clear="all">

		<div id="bloc">

			<?php if($nb_scores!=0){ ?>

				<div id="ligne_entete">
					<div style="float: left; width: 50px;" title="Numéro">N°</div>
					<div style="float: left; width: 200px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Équipe">PROFESSIONNEL</div>
					<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Groupe">GROUPE</div>
					<?php 
					// Affichage des dates enregistrées
					if(count($tab_dates)!=0){
						foreach($tab_dates as $date_selection){
							$date_competition = $date_selection[2];

							echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="'.$date_competition.'">'.$date_competition.'</div>'."\n";

						}
					}
					?>
					<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Groupe">CUMUL</div>
				</div>

			<?php 

				/**************************************************************/
				/****  AFFICHAGE DES JOUEURS PROS N'AYANT PAS ABONNDONNÉS  ****/
				/**************************************************************/

				for($score_boucle=0; $score_boucle<$nb_scores; $score_boucle++){
					$resultat_score = mysqli_fetch_array($requete_scores);
					$equipe_id = $resultat_score[0];
					$score_joueur_total = $resultat_score[1];
					$planning_groupe = $resultat_score[2];

					if(!isset($score_classement_affichage) OR (isset($score_classement_affichage) AND $score_joueur_total!=$tab_scores[$score_boucle-1])){
						$score_classement_affichage = $score_boucle + 1;
					}

					// Sélection des joueurs de l'équipe
					$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
					$resultat_joueur = mysqli_fetch_array($requete_joueurs);
					$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
					$joueur_prenom = ucwords(strtolower(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])))));

					// Permet de mettre la 1ere lettre en majuscule si le prénom est composé (avec -)
					if(preg_match('/-/', $joueur_prenom)==true){
						$joueur_prenom_tab = explode('-', $joueur_prenom);
						$joueur_prenom = '';
						foreach($joueur_prenom_tab as $joueur_prenom_morceau){
							$joueur_prenom .= ucwords(strtolower($joueur_prenom_morceau)).'-';
						}
						$joueur_prenom = substr($joueur_prenom, 0, -1);
					}

					$joueur_nom_prenom = $joueur_nom.' '.$joueur_prenom;
					if(strlen($joueur_nom_prenom)>27){  $joueur_nom_prenom = substr($joueur_nom_prenom, 0, 27).'.'; }
			?>

					<div id="ligne">
						<div style="float: left; width: 50px;" title="N°"><b><?=$score_classement_affichage?></b></div>
						<div style="float: left; width: 200px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Joueur professionnel"><?=$joueur_nom_prenom?></div>
						<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Groupe"><?=$planning_groupe?></div>
						<?php 
						// Affichage des dates enregistrées
						if(count($tab_dates)!=0){
							foreach($tab_dates as $date_selection){
								$date_competition = $date_selection[0];

								if(in_array($date_competition, $critere_dates)==true OR in_array('cumul', $critere_dates)==true){

									// Sélection du score du jour
									$requete_score_jour = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_resultats_total, score_joueur_pro_reference FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE planning_depart_date="'.$date_competition.'" AND A.equipe_id="'.$equipe_id.'"');
									$resultat_score_jour = mysqli_fetch_array($requete_score_jour);
									$score_joueur_jour = $resultat_score_jour[0];
									$score_joueur_pro_reference = $resultat_score_jour[1];

									if(strlen(trim($score_joueur_jour))!=0){
										echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Score du jour"><b>'.$score_joueur_jour.'</b>&nbsp; <span title="Score de référence" style="color: #999999;">('.$score_joueur_pro_reference.')</span></div>'."\n";
									}else{
										echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="">&nbsp;</div>'."\n";
									}

								}else{

									echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="">&nbsp;</div>'."\n";

								}

							}

							// Sélection du score cumulé chaque jour
							$requete_score_cumule_jour = mysqli_query($connexion_mysql, 'SELECT SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'"');
							$resultat_score_cumule_jour = mysqli_fetch_array($requete_score_cumule_jour);
							$score_joueur_cumule_jours = $resultat_score_cumule_jour[0];

							echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Cumul"><b>'.$score_joueur_cumule_jours.'</b></div>'."\n";

						}
						?>
					</div>

			<?php 
				}

				/********************************************************/
				/****  AFFICHAGE DES JOUEURS PROS AYANT ABONNDONNÉS  ****/
				/********************************************************/

				if($nb_scores_abandons!=0){

					for($score_abandon_boucle=0; $score_abandon_boucle<$nb_scores_abandons; $score_abandon_boucle++){
						$resultat_score_abandon = mysqli_fetch_array($requete_scores_abandons);
						$equipe_id = $resultat_score_abandon[0];
						$score_joueur_total = $resultat_score_abandon[1];
						$planning_groupe = $resultat_score_abandon[2];

						$score_classement_affichage = $score_boucle + 1;

						// Sélection des joueurs de l'équipe
						$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
						$resultat_joueur = mysqli_fetch_array($requete_joueurs);
						$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
						$joueur_prenom = ucwords(strtolower(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])))));

						// Permet de mettre la 1ere lettre en majuscule si le prénom est composé (avec -)
						if(preg_match('/-/', $joueur_prenom)==true){
							$joueur_prenom_tab = explode('-', $joueur_prenom);
							$joueur_prenom = '';
							foreach($joueur_prenom_tab as $joueur_prenom_morceau){
								$joueur_prenom .= ucwords(strtolower($joueur_prenom_morceau)).'-';
							}
							$joueur_prenom = substr($joueur_prenom, 0, -1);
						}

						$joueur_nom_prenom = $joueur_nom.' '.$joueur_prenom;
						if(strlen($joueur_nom_prenom)>27){  $joueur_nom_prenom = substr($joueur_nom_prenom, 0, 27).'.'; }
				?>

						<div id="ligne">
							<div style="float: left; width: 50px;" title="N°"><b><?=$score_classement_affichage?></b></div>
							<div style="float: left; width: 200px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Joueur professionnel"><?=$joueur_nom_prenom?></div>
							<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Groupe"><?=$planning_groupe?></div>
							<?php 
							// Affichage des dates enregistrées
							if(count($tab_dates)!=0){
								$indicateur_pro_abdandon = 0;
								foreach($tab_dates as $date_selection){
									$date_competition = $date_selection[0];

									if(in_array($date_competition, $critere_dates)==true OR in_array('cumul', $critere_dates)==true){

										// Sélection du score du jour
										$requete_score_jour = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_resultats_total, score_joueur_pro_reference, score_joueur_pro_abandon FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE planning_depart_date="'.$date_competition.'" AND A.equipe_id="'.$equipe_id.'"');
										$resultat_score_jour = mysqli_fetch_array($requete_score_jour);
										$score_joueur_jour = $resultat_score_jour[0];
										$score_joueur_pro_reference = $resultat_score_jour[1];
										$score_joueur_pro_abandon = $resultat_score_jour[2];

										if($score_joueur_pro_abandon==1){
											$indicateur_pro_abdandon = 1;
											echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Abandon"><b>ABD</b></div>'."\n";
										}elseif(strlen(trim($score_joueur_jour))!=0){
											echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Score du jour"><b>'.$score_joueur_jour.'</b>&nbsp; <span title="Score de référence" style="color: #999999;">('.$score_joueur_pro_reference.')</span></div>'."\n";
										}else{
											echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="">&nbsp;</div>'."\n";
										}

									}else{

										echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="">&nbsp;</div>'."\n";

									}

								}

								echo '<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Abandon"><b>ABD</b></div>'."\n";

							}
							?>
						</div>

			<?php 
					}
				}

			}else{
				if(isset($action) AND $action=='rechercher'){
					echo '<div id="ligne">aucun classement correspond à votre recherche</div>'."\n";
				}else{
					echo '<div id="ligne">aucun score enregistré</div>'."\n";
				}
			}
			?>

		</div>

	</div>

	<div id="contenu_secondaire">

		<form action="<?=$PHP_SELF?>" method="post">

			<input type="hidden" name="action" value="rechercher">

			<div class="titre">afficher une date</div>

			<?php 
			// Affichage des dates enregistrées
			if(count($tab_dates)!=0){

				if(isset($critere_dates) AND in_array('cumul', $critere_dates)==true){ $date_competition_checked = ' checked'; }else{ $date_competition_checked = ''; }

				echo '<input type="checkbox" id="affichage_date_cumul" name="critere_dates[]" value="cumul"'.$date_competition_checked.'>&nbsp; <label for="affichage_date_cumul">Toutes les dates</label><br>'."\n";
				echo '<img src="'.$admin_img.'p.gif" width="1" height="5"><br>'."\n\n";

				foreach($tab_dates as $date_selection_cle=>$date_selection){
					$date_competition = $date_selection[0];
					$date_competition_libelle = $date_selection[1];

					if(isset($critere_dates) AND in_array($date_competition, $critere_dates)==true){ $date_competition_checked = ' checked'; }else{ $date_competition_checked = ''; }

					echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n";
					echo '<input type="checkbox" id="affichage_date_'.$date_selection_cle.'" name="critere_dates[]" value="'.$date_competition.'"'.$date_competition_checked.'>&nbsp; <label for="affichage_date_'.$date_selection_cle.'">'.$date_competition_libelle.'</label><br>'."\n";

				}
			}else{
				echo 'aucune date<br>';
			}
			?>

			<img src="<?=$admin_img?>p.gif" width="1" height="5"><br>

			<div class="titre">afficher un groupe</div>

			<?php 
			$requete_groupes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_groupe) FROM planning ORDER BY planning_groupe');
			$nb_groupes = mysqli_num_rows($requete_groupes);
			if($nb_groupes!=0){
				for($groupe_boucle=0; $groupe_boucle<$nb_groupes; $groupe_boucle++){
					$resultat_groupe = mysqli_fetch_array($requete_groupes);
					$competition_groupe = $resultat_groupe[0];

					if(isset($critere_groupes) AND in_array($competition_groupe, $critere_groupes)==true){ $competition_groupe_checked = ' checked'; }else{ $competition_groupe_checked = ''; }

					echo '<input type="checkbox" id="affichage_groupe_'.$competition_groupe.'" name="critere_groupes[]" value="'.$competition_groupe.'"'.$competition_groupe_checked.'> <label for="affichage_groupe_'.$competition_groupe.'">Groupe '.$competition_groupe.'</label><br>'."\n";
					if($groupe_boucle!=($nb_groupes-1)){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}
			}else{
				echo 'aucun groupe<br>';
			}
			?>
			<img src="<?=$admin_img?>p.gif" width="1" height="5"><br>

			<div class="titre">afficher un golf</div>

			<?php 
			$requete_golfs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(golf_id) AS competition_golf_id, (SELECT golf_nom FROM golfs WHERE golf_id=competition_golf_id) AS golf_nom FROM planning ORDER BY golf_nom');
			$nb_golfs = mysqli_num_rows($requete_golfs);
			if($nb_golfs!=0){
				for($golf_boucle=0; $golf_boucle<$nb_golfs; $golf_boucle++){
					$resultat_golf = mysqli_fetch_array($requete_golfs);
					$competition_golf = $resultat_golf[0];
					$competition_golf_nom = $resultat_golf[1];

					if(isset($critere_golfs) AND in_array($competition_golf, $critere_golfs)==true){ $competition_golf_checked = ' checked'; }else{ $competition_golf_checked = ''; }

					echo '<input type="checkbox" id="affichage_golf_'.$competition_golf.'" name="critere_golfs[]" value="'.$competition_golf.'"'.$competition_golf_checked.'> <label for="affichage_golf_'.$competition_golf.'">'.$competition_golf_nom.'</label><br>'."\n";
					if($golf_boucle!=($nb_golfs-1)){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}
			}else{
				echo 'aucun golf<br>';
			}
			?>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 20px 0px 20px 0px;"><br>

			<center><input type="submit" value="valider" style="width: 100px;"></center>

		</form>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
