<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(1, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(2, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='ajouter'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if($ajouter_type=='rubrique'){
		if($rubrique_module==0){
			$erreur_message .= "- le module est manquant<br>";
		}
	}
	if(strlen(trim($ajouter_libelle))==0){
		$erreur_message .= "- le libellé est manquant<br>";
	}
	if(strlen(trim($ajouter_repertoire))==0){
		$erreur_message .= "- le répertoire est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$ajouter_libelle = htmlentities(ucfirst($ajouter_libelle), ENT_QUOTES);
	$ajouter_repertoire = htmlentities(strtolower($ajouter_repertoire), ENT_QUOTES);
	if(!isset($ajouter_activation)){ $ajouter_activation = 0; }

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		if($ajouter_type=='module'){

			// Requête d'insertion du module
			$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO admin_modules (module_niveau, module_libelle, module_repertoire, module_classement, module_activation) VALUES("'.$module_niveau.'", "'.$ajouter_libelle.'", "'.$ajouter_repertoire.'", "100", "'.$ajouter_activation.'")');

			// Mise à jour du classement après ajout
			mise_a_jour_classement($connexion_mysql, 'admin_modules', 'module_id', 'module_classement', '');

		}else{

			// Requête d'insertion de la rubrique
			$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO admin_rubriques (rubrique_module, rubrique_libelle, rubrique_repertoire, rubrique_classement, rubrique_activation) VALUES('.$rubrique_module.', "'.$ajouter_libelle.'", "'.$ajouter_repertoire.'", "100", "'.$ajouter_activation.'")');

			// Mise à jour du classement après ajout
			mise_a_jour_classement($connexion_mysql, 'admin_rubriques', 'rubrique_id', 'rubrique_classement', 'WHERE rubrique_module='.$rubrique_module);

		}

		echo '<meta http-equiv="refresh" content="0; url=./index.php">';
		exit;

	}else{
		$ajouter_libelle = stripslashes($ajouter_libelle);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Initialisation des champs
	$ajouter_type = 'module';
	$module_niveau = 'primaire';
	$rubrique_module = 0;
	$ajouter_libelle = '';
	$ajouter_repertoire = '';
	$ajouter_activation = 1;

}else{

	// Si le formulaire comporte des erreurs, alors traitement des données
	$ajouter_libelle = stripslashes($ajouter_libelle);
	$ajouter_repertoire = stripslashes($ajouter_repertoire);

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<script type="text/javascript">
		jQuery.noConflict();
		document.observe('dom:loaded', function() {
			new Tip('colonne_image', 'Formats acceptés : JPEG, GIF ou PNG<br>Poids maximum : 500 Ko<br>Marque > Hauteur max : 55 pixels<br>Modèle > Largeur max : 80 pixels', {
				className: 'infobulle_information', title: 'informations', effect: 'appear', hook: { target: 'bottomMiddle', tip: 'topLeft'}
			});
		});
	</script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<script language="Javascript">
	<!-- 
	function arborescence_type(type){
		if(type=='module'){
			document.getElementById('bloc_module').style.display = 'block';
			document.getElementById('bloc_rubrique').style.display = 'none';
		}else{
			document.getElementById('bloc_module').style.display = 'none';
			document.getElementById('bloc_rubrique').style.display = 'block';
		}
	}
	//-->
</script>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 450px;">

		<div id="titres">
			<span class="titre_1"><a href="index.php">Arborescence</a> <span class="separateur">/</span> <span class="titre_2">Ajouter</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="ajouter" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="ajouter">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Activation</div>
					<div id="formulaire_champ"><input type="checkbox" name="ajouter_activation" value="1" <?php if($ajouter_activation==1){ echo 'checked'; } ?>></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Type</div>
					<div id="formulaire_champ">
						<input type="radio" id="ajouter_type_module" name="ajouter_type" value="module" onclick="arborescence_type('module')" <?php if($ajouter_type=='module'){ echo 'checked'; } ?>> <label for="ajouter_type_module">Module</label>&nbsp;&nbsp;&nbsp;&nbsp; 
						<input type="radio" id="ajouter_type_rubrique" name="ajouter_type" value="rubrique" onclick="arborescence_type('rubrique')" <?php if($ajouter_type=='rubrique'){ echo 'checked'; } ?>> <label for="ajouter_type_rubrique">Rubrique</label>
					</div>
					<br clear="all">
				</div>
				<div id="bloc_module" <?php if($ajouter_type=='rubrique'){ echo 'style="display: none;"'; } ?>>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle">Niveau</div>
						<div id="formulaire_champ">
							<input type="radio" id="module_niveau_primaire" name="module_niveau" value="primaire" <?php if((isset($module_niveau) AND $module_niveau=='primaire') OR !isset($module_niveau)){ echo 'checked'; } ?>> <label for="module_niveau_primaire">Primaire</label>&nbsp;&nbsp;&nbsp;&nbsp; 
							<input type="radio" id="module_niveau_secondaire" name="module_niveau" value="secondaire" <?php if($module_niveau=='secondaire'){ echo 'checked'; } ?>> <label for="module_niveau_secondaire">Secondaire</label>
						</div>
						<br clear="all">
					</div>
				</div>
				<div id="bloc_rubrique" <?php if($ajouter_type=='module'){ echo 'style="display: none;"'; } ?>>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Module</div>
						<div id="formulaire_champ">
							<select name="rubrique_module" size="1" class="select">
								<option value="0">Sélectionnez
								<?php 
								// Sélection des modules enregistrés
								$requete_modules = mysqli_query($connexion_mysql, 'SELECT module_id, module_libelle FROM admin_modules ORDER BY module_classement');
								$nb_modules = mysqli_num_rows($requete_modules);
								if($nb_modules!=0){
									for($module_boucle=0; $module_boucle<$nb_modules; $module_boucle++){
										$resultat_module = mysqli_fetch_array($requete_modules);
										$module_id = $resultat_module[0];
										$module_libelle = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_module[1]))));
										if($module_id==$rubrique_module){ $module_selection = 'selected'; }else{ $module_selection = ''; }
	
										echo '<option value="'.$module_id.'"'.$module_selection.'>'.$module_libelle."\n";
									}
								}
								?>
							</select>
						</div>
						<br clear="all">
					</div>
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Libellé</div>
					<div id="formulaire_champ"><input type="text" name="ajouter_libelle" value="<?=$ajouter_libelle?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Répertoire</div>
					<div id="formulaire_champ"><input type="text" name="ajouter_repertoire" value="<?=$ajouter_repertoire?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="index.php" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>


<script language="Javascript">
	<!-- 
	arborescence_type('<?=$ajouter_type?>');

	document.ajouter.ajouter_libelle.focus();
	//-->
</script>

</body>
</html>
