<?php 

/*******************************************************************/
/**  FONCTION DE TRAITEMENT DES CARATÈRES ACCENTUÉS EN MAJUSCULE  **/
/*******************************************************************/
function strtoupper_max($chaine){
	$chaine = strtoupper($chaine);

	$chaine = preg_replace('/à/', 'À', $chaine);
	$chaine = preg_replace('/á/', 'Á', $chaine);
	$chaine = preg_replace('/â/', 'Â', $chaine);
	$chaine = preg_replace('/ä/', 'Ä', $chaine);
	$chaine = preg_replace('/ç/', 'Ç', $chaine);
	$chaine = preg_replace('/è/', 'È', $chaine);
	$chaine = preg_replace('/é/', 'É', $chaine);
	$chaine = preg_replace('/ê/', 'Ê', $chaine);
	$chaine = preg_replace('/ë/', 'Ë', $chaine);
	$chaine = preg_replace('/ï/', 'Ï', $chaine);
	$chaine = preg_replace('/î/', 'Î', $chaine);
	$chaine = preg_replace('/ô/', 'Ô', $chaine);
	$chaine = preg_replace('/ö/', 'Ö', $chaine);
	$chaine = preg_replace('/ü/', 'Ü', $chaine);
	$chaine = preg_replace('/û/', 'Û', $chaine);

	return $chaine;
}


/*******************************************************************/
/**  FONCTION DE TRAITEMENT DES CARATÈRES ACCENTUÉS EN MAJUSCULE  **/
/*******************************************************************/
function ucfirst_max($chaine){
	$lettre = strtoupper_max(substr($chaine, 0, 1));
	$chaine = $lettre.substr($chaine, 1);

	return $chaine;
}


/*******************************************************************/
/**  FONCTION DE TRAITEMENT DES CARATÈRES ACCENTUÉS EN MINUSCULE  **/
/*******************************************************************/
function strtolower_max($chaine){
	$chaine = strtolower($chaine);

	$chaine = preg_replace('/À/', 'à', $chaine);
	$chaine = preg_replace('/Á/', 'á', $chaine);
	$chaine = preg_replace('/Â/', 'â', $chaine);
	$chaine = preg_replace('/Ä/', 'ä', $chaine);
	$chaine = preg_replace('/Ç/', 'ç', $chaine);
	$chaine = preg_replace('/È/', 'è', $chaine);
	$chaine = preg_replace('/É/', 'é', $chaine);
	$chaine = preg_replace('/Ê/', 'ê', $chaine);
	$chaine = preg_replace('/Ë/', 'ë', $chaine);
	$chaine = preg_replace('/Ï/', 'ï', $chaine);
	$chaine = preg_replace('/Î/', 'î', $chaine);
	$chaine = preg_replace('/Ô/', 'ô', $chaine);
	$chaine = preg_replace('/Ö/', 'ö', $chaine);
	$chaine = preg_replace('/Ü/', 'ü', $chaine);
	$chaine = preg_replace('/Û/', 'û', $chaine);

	return $chaine;
}


/********************************************/
/**  FONCTION DE DECODAGE DES APOSTROPHES  **/
/********************************************/
function decodage_apostrophe($chaine){

	$chaine = preg_replace('/&#039;/', "'", $chaine);

	return $chaine;
}


/*******************************************************************************/
/**  FONCTION DE TRAITEMENT DES CARATÈRES ACCENTUÉS EN CARACTÈRE SANS ACCENT  **/
/*******************************************************************************/
function strtonoaccent($chaine){

	$chaine = preg_replace('/à/', 'a', $chaine);
	$chaine = preg_replace('/á/', 'a', $chaine);
	$chaine = preg_replace('/â/', 'a', $chaine);
	$chaine = preg_replace('/ä/', 'a', $chaine);
	$chaine = preg_replace('/ç/', 'c', $chaine);
	$chaine = preg_replace('/è/', 'e', $chaine);
	$chaine = preg_replace('/é/', 'e', $chaine);
	$chaine = preg_replace('/ê/', 'e', $chaine);
	$chaine = preg_replace('/ë/', 'e', $chaine);
	$chaine = preg_replace('/ï/', 'i', $chaine);
	$chaine = preg_replace('/î/', 'i', $chaine);
	$chaine = preg_replace('/ô/', 'o', $chaine);
	$chaine = preg_replace('/ö/', 'o', $chaine);
	$chaine = preg_replace('/ü/', 'u', $chaine);
	$chaine = preg_replace('/û/', 'u', $chaine);

	$chaine = preg_replace('/À/', 'A', $chaine);
	$chaine = preg_replace('/Á/', 'A', $chaine);
	$chaine = preg_replace('/Â/', 'A', $chaine);
	$chaine = preg_replace('/Ä/', 'A', $chaine);
	$chaine = preg_replace('/Ç/', 'C', $chaine);
	$chaine = preg_replace('/È/', 'E', $chaine);
	$chaine = preg_replace('/É/', 'E', $chaine);
	$chaine = preg_replace('/Ê/', 'E', $chaine);
	$chaine = preg_replace('/Ë/', 'E', $chaine);
	$chaine = preg_replace('/Ï/', 'i', $chaine);
	$chaine = preg_replace('/Î/', 'i', $chaine);
	$chaine = preg_replace('/Ô/', 'O', $chaine);
	$chaine = preg_replace('/Ö/', 'O', $chaine);
	$chaine = preg_replace('/Ü/', 'U', $chaine);
	$chaine = preg_replace('/Û/', 'U', $chaine);

	return $chaine;
}


/**********************************************/
/**  FONCTION D'ENREGISTREMENT DES CHIFFRES  **/
/**********************************************/
function enregistrement_chiffres($chiffres){

	$chiffres = trim($chiffres);
	$chiffres = preg_replace('/ /', '', $chiffres);
	$chiffres = preg_replace('/\./', '', $chiffres);
	$chiffres = preg_replace('/-/', '', $chiffres);
	$chiffres = preg_replace('/\//', '', $chiffres);
	$chiffres = trim($chiffres);

	return $chiffres;
}


/***************************************/
/**  FONCTION VERIFICATION DES DATES  **/
/***************************************/
function verification_date($date, $langue='fr', $separateur='/'){

	if($langue=='fr'){

		$jour = substr($date, 0, 2);
		$separateur_1 = substr($date, 2, 1);
		$mois = substr($date, 3, 2);
		$separateur_2 = substr($date, 5, 1);
		$annee = substr($date, 6, 4);

	}else{

		$separateur = '-';

		$annee = substr($date, 0, 4);
		$separateur_1 = substr($date, 4, 1);
		$mois = substr($date, 5, 2);
		$separateur_2 = substr($date, 7, 1);
		$jour = substr($date, 8, 2);

	}

	if(strlen(trim($date))==10 AND is_numeric($jour)==true AND $separateur_1==$separateur AND is_numeric($mois)==true AND $separateur_2==$separateur AND is_numeric($annee)==true AND checkdate($mois, $jour, $annee)==true){
		$resultat = true;
	}else{
		$resultat = false;
	}

	return $resultat;
}


/***************************************************************/
/*  FONCTION DE NETTOYAGE DES CARATERES POUR REECRITURE D'URL  */
/***************************************************************/
function nettoyage_chaine_url($chaine){
	$chaine = strtolower(html_entity_decode($chaine));

	$chaine = preg_replace('/&#039;/', "'", $chaine);

	$chaine = preg_replace('/#/', '', $chaine);
	$chaine = preg_replace('/%/', '', $chaine);
	$chaine = preg_replace('/&/', '', $chaine);
	$chaine = preg_replace('/£/', '', $chaine);
	$chaine = preg_replace('/²/', '', $chaine);
	$chaine = preg_replace('/³/', '', $chaine);
	$chaine = preg_replace('/°/', '', $chaine);
	$chaine = preg_replace('/«/', '', $chaine);
	$chaine = preg_replace('/»/', '', $chaine);
	$chaine = preg_replace('/\|/', '', $chaine);
	$chaine = preg_replace('/!/', '', $chaine);
	$chaine = preg_replace('/:/', '', $chaine);
	$chaine = preg_replace('/\./', '', $chaine);
	$chaine = preg_replace('/-/', '', $chaine);
	$chaine = preg_replace('/,/', '', $chaine);
	$chaine = preg_replace('/\//', '-', $chaine);

	$chaine = preg_replace('/à/', 'a', $chaine);
	$chaine = preg_replace('/á/', 'a', $chaine);
	$chaine = preg_replace('/â/', 'a', $chaine);
	$chaine = preg_replace('/ä/', 'a', $chaine);
	$chaine = preg_replace('/ç/', 'c', $chaine);
	$chaine = preg_replace('/è/', 'e', $chaine);
	$chaine = preg_replace('/é/', 'e', $chaine);
	$chaine = preg_replace('/ê/', 'e', $chaine);
	$chaine = preg_replace('/ë/', 'e', $chaine);
	$chaine = preg_replace('/ï/', 'i', $chaine);
	$chaine = preg_replace('/î/', 'i', $chaine);
	$chaine = preg_replace('/ô/', 'o', $chaine);
	$chaine = preg_replace('/ö/', 'o', $chaine);
	$chaine = preg_replace('/ü/', 'u', $chaine);
	$chaine = preg_replace('/û/', 'u', $chaine);
	$chaine = preg_replace('/æ/', 'ae', $chaine);

	$chaine = preg_replace('/  /', ' ', trim($chaine));

	$chaine = preg_replace('/\'/', '_', $chaine);
	$chaine = preg_replace('/"/', '_', $chaine);
	$chaine = preg_replace('/ /', '_', $chaine);
	$chaine = preg_replace('/__/', '_', $chaine);
	$chaine = preg_replace('/__/', '_', $chaine);

	return $chaine;
}


/**********************************************************/
/**  FONCTION D'ENCODAGE EN RFC 2047 DES SUJETS DE MAIL  **/
/**********************************************************/
function in_multiarray($element, $tableau){

	$top = sizeof($tableau) - 1;
	$bottom = 0;

	while($bottom <= $top){

		if($tableau[$bottom] == $element){
			return true;
		}else{
			if(is_array($tableau[$bottom])){
				if(in_multiarray($element, ($tableau[$bottom]))){
					return true;
				}
			}
		}

		$bottom++;
	}

	return false;
}


/***************************************/
/**  FONCTION D'ENVOI D'UN E-MAILING  **/
/***************************************/
function emailing_envoi($emailing_destinataires_from_email, $emailing_destinataires_to_email, $emailing_destinataires_cc_email, $emailing_destinataires_cci_email, $emailing_sujet, $emailing_titre, $emailing_message, $emailing_masque, $emailing_domaine, $emailing_langue='fr'){

	// Récupération du masque de l'e-mailing
	$emailing_contenu_vierge = @join('', @file($emailing_masque));

	// Paramètres pour l'envoi
	$emailing_expediteur_nom = mb_encode_mimeheader('Pro Am de Côte d\'Opale');
	$emailing_expediteur_email = $emailing_destinataires_from_email;
	$emailing_expediteur_domaine_tab = explode('@', $emailing_expediteur_email);
	$emailing_expediteur_domaine = $emailing_expediteur_domaine_tab[1];
	$emailing_sujet = mb_encode_mimeheader($emailing_sujet);

	// Traitement pour insertion du contenu
	$emailing_contenu = preg_replace("/{URL}/", $emailing_domaine, $emailing_contenu_vierge);
	$emailing_contenu = preg_replace("/{TITRE}/", $emailing_titre, $emailing_contenu);
	$emailing_contenu = preg_replace("/{TEXTE}/", $emailing_message, $emailing_contenu);
	$emailing_contenu = preg_replace("/{IMG}/", $emailing_domaine.'/commun/', $emailing_contenu);
	$emailing_contenu = preg_replace("/{LANGUE}/", strtoupper($emailing_langue), $emailing_contenu);

	// Construction de l'entête de l'e-mailing
	$emailing_entete  = "MIME-Version: 1.0\r\n";
	$emailing_entete .= "Content-type: text/html; charset=UTF-8\r\n";
	$emailing_entete .= "From: ".$emailing_expediteur_nom." <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "Reply-To: <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "Return-Path: <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "Cc: ".$emailing_destinataires_cc_email."\r\n";
	$emailing_entete .= "Cci: ".$emailing_destinataires_cci_email."\r\n";
	$emailing_entete .= "Message-ID: <".time().rand(1,1000)."@".$emailing_expediteur_domaine.">\r\n";
	$emailing_entete .= "Sender: <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "X-Mailer: PHP v".phpversion()."\r\n";
	$emailing_entete .= "X-Sender: ".$emailing_expediteur_email."\r\n";
	$emailing_entete .= "X-auth-smtp-user: ".$emailing_expediteur_email."\r\n";
	$emailing_entete .= "X-abuse-contact: abuse@".$emailing_expediteur_domaine;
	$emailing_entete_plus = "-f ".$emailing_expediteur_email;

	// Envoi de l'alerte par e-mail
	if(is_array($emailing_destinataires_to_email)==true){
		foreach($emailing_destinataires_to_email as $emailing_destinataire_to_email){
			mail($emailing_destinataire_to_email, $emailing_sujet, $emailing_contenu, $emailing_entete, $emailing_entete_plus);
		}
	}else{
		mail($emailing_destinataires_to_email, $emailing_sujet, $emailing_contenu, $emailing_entete, $emailing_entete_plus);
	}

}


/**********************************************/
/**  FONCTION DE GENERATION DE MOT DE PASSE  **/
/**********************************************/
function generateur_mot_passe($nb_caracteres){

	// Tableaux des données
	$lettres_minuscules = array('a','b','c','d','e','f','g','h','j','k','m','n','p','q','r','s','t','u','v','w','x','y','z','2','3','4','5','6','7','8','9');

	// Initialisation des variables
	$tableau_lettres = array();
	$pazword = '';

	// Création du tableau des lettres
	if($nb_caracteres!=0){

		$lettres = $lettres_minuscules;

		$tableau_lettres_cle = array_rand($lettres, $nb_caracteres);

		if(count($tableau_lettres_cle)!=1){
			foreach($tableau_lettres_cle as $tableau_lettres_valeur){
				array_push($tableau_lettres, $lettres[$tableau_lettres_valeur]); 
			}
		}else{
			$tableau_lettres = array($lettres[$tableau_lettres_cle]);
		}

	}

	// Création du mot de passe à afficher
	if(count($tableau_lettres)!=1){
		shuffle($tableau_lettres);  // Mélange aléatoire du tableau

		foreach($tableau_lettres as $tableau_lettres_valeur){
			$pazword .= $tableau_lettres_valeur;
		}

	}else{
		$pazword = $tableau_lettres[0];
	}

	return $pazword;

}


/************************************************************/
/*  FONCTION DE REDIMMENSIONNEMENT AUTOMATIQUE D'UNE IMAGE  */
/************************************************************/
function redimensionnement_image($dimensions_originales, $dimension_finale_largeur_max, $dimension_finale_hauteur_max){

	$dimension_originale_largeur = $dimensions_originales[0];
	$dimension_originale_hauteur = $dimensions_originales[1];

	if($dimension_originale_largeur == $dimension_originale_hauteur){			// Photo carrée

		$dimensions_finales[0] = ' width="'.$dimension_finale_largeur_max.'"';
		$dimensions_finales[1] = ' height="'.$dimension_finale_hauteur_max.'"';
		$dimensions_finales[2] = '';

		if($dimension_finale_hauteur_max < $dimension_finale_largeur_max){

			$dimensions_finales[0] = ' width="'.$dimension_finale_hauteur_max.'"';
			$dimensions_finales[1] = ' height="'.$dimension_finale_hauteur_max.'"';

		}

		if($dimension_finale_hauteur_max > $dimension_finale_largeur_max){

			$dimensions_finales[0] = ' width="'.$dimension_finale_largeur_max.'"';
			$dimensions_finales[1] = ' height="'.$dimension_finale_largeur_max.'"';

		}

	}elseif($dimension_originale_largeur > $dimension_originale_hauteur){		// Photo paysage

		$proportion = $dimension_originale_largeur / $dimension_finale_largeur_max;
		$hauteur = ceil($dimension_originale_hauteur / $proportion);

		$dimensions_finales[0] = ' width="'.$dimension_finale_largeur_max.'"';
		$dimensions_finales[1] = ' height="'.$hauteur.'"';
		$dimensions_finales[2] = ceil(($dimension_finale_hauteur_max - $hauteur) / 2);

		if($hauteur > $dimension_finale_hauteur_max){

			$proportion = $hauteur / $dimension_finale_hauteur_max;
			$largeur = ceil($dimension_finale_largeur_max / $proportion);

			$dimensions_finales[0] = ' width="'.$largeur.'"';
			$dimensions_finales[1] = ' height="'.$dimension_finale_hauteur_max.'"';
			$dimensions_finales[2] = '';

		}

	}elseif($dimension_originale_largeur < $dimension_originale_hauteur){		// Photo portrait

		$proportion = $dimension_originale_hauteur / $dimension_finale_hauteur_max;
		$largeur = ceil($dimension_originale_largeur / $proportion);

		$dimensions_finales[0] = ' width="'.$largeur.'"';
		$dimensions_finales[1] = ' height="'.$dimension_finale_hauteur_max.'"';
		$dimensions_finales[2] = '';

		if($largeur > $dimension_finale_largeur_max){

			$proportion = $largeur / $dimension_finale_largeur_max;
			$hauteur = ceil($dimension_finale_hauteur_max / $proportion);

			$dimensions_finales[0] = ' width="'.$dimension_finale_largeur_max.'"';
			$dimensions_finales[1] = ' height="'.$hauteur.'"';

		}

	}

	return $dimensions_finales;

}
?>