<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(3, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	if(isset($joueur_hdcp_tab) AND count($joueur_hdcp_tab)!=0){
		foreach($joueur_hdcp_tab as $joueur_hdcp_id=>$joueur_hdcp_valeur){

			if(preg_match('/,/', $joueur_hdcp_valeur)==true){ $joueur_hdcp_valeur = preg_replace('/,/', '.', $joueur_hdcp_valeur); }
			$joueur_hdcp_valeur = floatval($joueur_hdcp_valeur); 	 // Transforme la valeur en nombre flottant

			if(in_array($joueur_hdcp_id, $joueur_handicap_validations)==true AND strlen(trim($joueur_hdcp_valeur))!=0){

				// Requête de mise à jour des handicaps + statut de validation
				$requete_maj_1 = mysqli_query($connexion_mysql, 'UPDATE joueurs SET joueur_handicap="'.$joueur_hdcp_valeur.'", joueur_handicap_validation="1" WHERE joueur_id="'.$joueur_hdcp_id.'"');

			}else{

				if($joueur_hdcp_valeur!=0){

					// Requête de mise à jour des handicaps
					$requete_maj_2 = mysqli_query($connexion_mysql, 'UPDATE joueurs SET joueur_handicap="'.$joueur_hdcp_valeur.'" WHERE joueur_id="'.$joueur_hdcp_id.'"');

				}

			}

		}
	}

	header('Location: ./valider_hdcp.php');
	exit;

}elseif(isset($action) AND $action=='annuler'){


	// Requête de mise à jour pour annuler le statut validé du handicap
	$requete_maj_3 = mysqli_query($connexion_mysql, 'UPDATE joueurs SET joueur_handicap_validation="0" WHERE joueur_id="'.$joueur_id.'"');

	header('Location: ./valider_hdcp.php');
	exit;

}


// Sélection des joueurs enregistrés
$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_profil, joueur_handicap, joueur_handicap_validation, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_actif=1 AND joueur_profil="am" ORDER BY joueur_nom, joueur_prenom');
$nb_joueurs = mysqli_num_rows($requete_joueurs);

// Sélection des joueurs validés enregistrés
$requete_joueurs_valides = mysqli_query($connexion_mysql, 'SELECT joueur_id FROM joueurs WHERE joueur_actif=1 AND joueur_profil="am" AND joueur_handicap_validation="1" ORDER BY joueur_nom, joueur_prenom');
$nb_joueurs_valides = mysqli_num_rows($requete_joueurs_valides);

// Sélection des joueurs non validés enregistrés
$requete_joueurs_non_valides = mysqli_query($connexion_mysql, 'SELECT joueur_id FROM joueurs WHERE joueur_actif=1 AND joueur_profil="am" AND joueur_handicap_validation="0" ORDER BY joueur_nom, joueur_prenom');
$nb_joueurs_non_valides = mysqli_num_rows($requete_joueurs_non_valides);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1120px;">

	<div id="contenu_3" align="left" style="width: 820px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Joueurs</a> <span class="separateur">/</span> <span class="titre_2">Valider les handicaps</span></span>
		</div>
		<br clear="all">

		<?php 
		if($nb_joueurs==1){
			echo '<div id="ligne_compteur"><b>1</b> joueur</div>';
		}elseif($nb_joueurs>1){
			echo '<div id="ligne_compteur"><b>'.$nb_joueurs.'</b> joueurs amateurs :&nbsp;&nbsp; <b>'.$nb_joueurs_valides.'</b> HDCP validés &nbsp;/&nbsp; <b>'.$nb_joueurs_non_valides.'</b> HDCP non validés</div>';
		}
		?>

		<div id="bloc" style="width: 640px;">

			<?php if($nb_joueurs!=0){ ?>

				<div id="ligne_entete" style="width: 629px;">
					<div style="float: left; width: 200px;" title="Nom">NOM</div>
					<div style="float: left; width: 150px; padding-left: 15px; border-left: 1px solid #CCCCCC;" title="Prénom">PRÉNOM</div>
					<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Handicap joueur">HDCP</div>
					<div align="center" style="float: left; width: 90px; border-left: 1px solid #CCCCCC;" title="Statut de la validation">STATUT</div>
					<div align="center" style="float: left; width: 90px; border-left: 1px solid #CCCCCC;" title="Valdation du handicap">VALIDATION</div>
				</div>

				<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

					<input type="hidden" name="action" value="modifier">

					<?php 
					for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
						$resultat_joueur = mysqli_fetch_array($requete_joueurs);
						$joueur_id = $resultat_joueur[0];
						$joueur_profil_brut = $resultat_joueur[1];
						$joueur_handicap = $resultat_joueur[2];
						$joueur_handicap_validation = $resultat_joueur[3];
						$joueur_nom = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[4]))));
						$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[5])));

						if(strlen(trim($joueur_prenom))==0){ $joueur_prenom = '&nbsp;'; }

						if($joueur_handicap==NULL){
							$joueur_handicap = 0;
						}elseif(substr($joueur_handicap, -2)!='.0'){
							$joueur_handicap = number_format($joueur_handicap, 1, ',', '');
						}elseif(substr($joueur_handicap, -2)=='.0'){
							$joueur_handicap = number_format($joueur_handicap, 0);
						}

						if($joueur_handicap_validation==0){
							$joueur_handicap_css = ' font-size: 11px; background-color: orange; color: #FFFFFF;';
							$joueur_handicap_libelle = 'NON VALID&Eacute;';
						}else{
							$joueur_handicap_css = ' font-size: 11px; background-color: #1EAC18; color: #FFFFFF;';
							$joueur_handicap_libelle = 'VALID&Eacute;';
						}
					?>

						<div id="ligne" style="width: 629px;">
							<div style="float: left; width: 200px;" title="Nom"><?=$joueur_nom?></div>
							<div style="float: left; width: 150px; padding-left: 15px; border-left: 1px solid #CCCCCC;" title="Prénom"><?=$joueur_prenom?></div>
							<?php if($joueur_handicap_validation==0){ ?>
								<div align="center" style="float: left; width: 80px; height: 25px; border-left: 1px solid #CCCCCC; background-color: #EFEFEF;" title="Handicap joueur"><input type="text" name="joueur_hdcp_tab[<?=$joueur_id?>]" value="<?=$joueur_handicap?>" class="input_petit" style="width: 50px;"></div>
							<?php }else{ ?>
								<div align="center" style="float: left; width: 80px; height: 25px; border-left: 1px solid #CCCCCC;" title="Handicap joueur"><?=$joueur_handicap?></div>
							<?php } ?>
							<div align="center" style="float: left; width: 90px; border-left: 1px solid #CCCCCC;<?=$joueur_handicap_css?>" title="Handicap joueur"><?=$joueur_handicap_libelle?></div>
							<?php if($joueur_handicap_validation==0){ ?>
								<div align="center" style="float: left; width: 90px; height: 25px; border-left: 1px solid #CCCCCC;" title="Handicap joueur"><input type="checkbox" name="joueur_handicap_validations[]" value="<?=$joueur_id?>" class="checkbox" style="margin-top: 4px;"></div>
							<?php }else{ ?>
								<div align="center" style="float: left; width: 90px; height: 25px; border-left: 1px solid #CCCCCC;"><a href="./valider_hdcp.php?action=annuler&joueur_id=<?=$joueur_id?>" style="color: #CCCCCC;">annuler</a></div>
							<?php } ?>
						</div>

					<?php } ?>

					<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 30px 0px 30px 0px;"></div>

				</form>

			<?php 
			}else{
				echo '<div id="ligne">aucun joueur enregistré</div>'."\n";
			}
			?>

		</div>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
