<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(5, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND ($action=='confirmer' OR $action=='envoyer')){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if($action=='confirmer'){
		if(strlen(trim($joueur_email))==0){
			$erreur_message .= "- l'e-mail du destinataire est manquant<br>";
		}
		if(strlen(trim($inscription_message_objet))==0){
			$erreur_message .= "- l'objet du message est manquant<br>";
		}
		if(strlen(trim($inscription_message_titre))==0){
			$erreur_message .= "- le titre du message est manquant<br>";
		}
		if(strlen(trim($inscription_message_texte))==0){
			$erreur_message .= "- le texte du message est manquant<br>";
		}
	}

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message=='' AND $action=='envoyer'){

		$emailing_titre = $inscription_message_titre;

		$inscription_message_texte = html_entity_decode(stripslashes($inscription_message_texte));

		// Envoi de l'e-mail de confirmation d'inscription au joueur pro
		emailing_envoi($web_email_alerte, $joueur_email, $web_email_alerte, 'oguenon@gmail.com', $inscription_message_objet, $inscription_message_titre, $inscription_message_texte, $web_url.'/emailing.htm', $web_url, $joueur_langue);

		// Requête de mise à jour des textes
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE joueurs SET joueur_confirmation_envoyee="'.date('Y-m-d H:i:s').'" WHERE joueur_id="'.$joueur_id.'"');

		$envoi_inscription = 1;

	}elseif($erreur_message=='' AND $action=='confirmer'){
		$inscription_message_texte = preg_replace("/\n/", "<br>\n", stripslashes($inscription_message_texte));
	}

}


if(isset($action) AND isset($erreur_message) AND $erreur_message==''){

}elseif(isset($erreur_message) AND $erreur_message==''){

	// Sélection du joueur
	$requete_joueur = mysqli_query($connexion_mysql, 'SELECT joueur_sexe, joueur_prenom, joueur_nom, joueur_email, joueur_langue, DATE_FORMAT(joueur_confirmation_envoyee, "%d/%m/%Y à %Hh%i") FROM joueurs WHERE joueur_id="'.$joueur_id.'"');
	$resultat_joueur = mysqli_fetch_array($requete_joueur);
	$joueur_sexe = $resultat_joueur[0];
	$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
	$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2])));
	$joueur_email = $resultat_joueur[3];
	$joueur_langue = $resultat_joueur[4];
	$joueur_confirmation_envoyee = $resultat_joueur[5];

	// Sélection de la facture
	$requete_inscription_textes = mysqli_query($connexion_mysql, 'SELECT texte_inscription_objet_'.$joueur_langue.', texte_inscription_titre_'.$joueur_langue.', texte_inscription_message_'.$joueur_langue.' FROM parametres WHERE parametre_id=1');
	$resultat_inscription_texte = mysqli_fetch_array($requete_inscription_textes);
	$inscription_message_objet = decodage_apostrophe(html_entity_decode(stripslashes($resultat_inscription_texte[0])));
	$inscription_message_titre = decodage_apostrophe(html_entity_decode(stripslashes($resultat_inscription_texte[1])));
	$inscription_message_texte = decodage_apostrophe(html_entity_decode(stripslashes($resultat_inscription_texte[2])));

	$inscription_message_titre = preg_replace('/\[PRENOM\]/', $joueur_prenom, $inscription_message_titre);
	$inscription_message_titre = preg_replace('/\[NOM\]/', $joueur_nom, $inscription_message_titre);
	$inscription_message_texte = preg_replace('/\[PRENOM\]/', $joueur_prenom, $inscription_message_texte);
	$inscription_message_texte = preg_replace('/\[NOM\]/', $joueur_nom, $inscription_message_texte);

	if($joueur_langue=='FR'){

		if($joueur_sexe=='H'){
			$inscription_message_texte = preg_replace('/\[CIVILITE\]/', 'M.', $inscription_message_texte);
		}else{
			$inscription_message_texte = preg_replace('/Cher/', 'Chère', $inscription_message_texte);
			$inscription_message_texte = preg_replace('/\[CIVILITE\]/', 'Mme', $inscription_message_texte);
		}

	}else{

		if($joueur_sexe=='H'){
			$inscription_message_texte = preg_replace('/\[CIVILITE\]/', 'Mr.', $inscription_message_texte);
		}else{
			$inscription_message_texte = preg_replace('/\[CIVILITE\]/', 'Mrs.', $inscription_message_texte);
		}

	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery-ui-personalized-1.6rc6.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1" style="width: 558px;"><a href="./">Joueurs</a> <span class="separateur">/</span> <span class="titre_2">Envoyer un e-mail de confirmation d'inscription</span></span>
			<span class="ajouter" style="width: 80px;"><a href="./modifier_email_confirmation.php?joueur_id=<?=$joueur_id?>">Textes</a></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<?php if(isset($envoi_inscription) AND $envoi_inscription==1){ ?>
				<div align="center"><div id="message_confirmation" style="color: green;"><br><b>L'e-mail de confirmation d'inscription a bien été envoyé</b><br>à l'adresse ci-dessous :&nbsp; <?=$joueur_email?><br><br></div></div>
				<div id="formulaire_boutons" style="text-align: center;"><a href="./" class="lien_annuler">retour à la liste</a></div>
			<?php }elseif($joueur_confirmation_envoyee!="00/00/0000 à 00h00"){ ?>
				<div align="center" style="font-size: 13px; color: green; font-weight: normal; margin: 10px 0px 10px 0px;">L'e-mail de confirmation d'inscription a déjà été envoyé le <?=$joueur_confirmation_envoyee?>.</div>
			<?php } ?>

			<form name="envoyer" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<?php if(isset($action) AND $action=='confirmer' AND isset($erreur_message) AND $erreur_message==''){ ?>
					<input type="hidden" name="action" value="envoyer">
				<?php }else{ ?>
					<input type="hidden" name="action" value="confirmer">
				<?php } ?>
				<input type="hidden" name="joueur_id" value="<?=$joueur_id?>">
				<input type="hidden" name="joueur_langue" value="<?=$joueur_langue?>">

				<div id="formulaire_ligne_intertitre">DESTINATAIRE</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">E-mail</div>
					<div id="formulaire_champ" style="width: 500px;">
						<?php 
						if(isset($action) AND isset($erreur_message) AND $erreur_message==''){
							echo $joueur_email;
							echo '<input type="hidden" name="joueur_email" value="'.$joueur_email.'">';
						}else{
						?>
							<input type="text" name="joueur_email" value="<?=$joueur_email?>" class="input" style="width: 470px;">
						<?php 
						}
						?>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">CONTENU DE L'E-MAIL &Agrave; ENVOYER</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Objet</div>
					<div id="formulaire_champ" style="width: 500px;">
						<?php 
						if(isset($action) AND isset($erreur_message) AND $erreur_message==''){
							echo $inscription_message_objet;
							echo '<input type="hidden" name="inscription_message_objet" value="'.$inscription_message_objet.'">';
						}else{
						?>
							<input type="text" name="inscription_message_objet" value="<?=$inscription_message_objet?>" class="input" style="width: 470px;">
						<?php 
						}
						?>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Titre</div>
					<div id="formulaire_champ" style="width: 500px;">
						<?php 
						if(isset($action) AND isset($erreur_message) AND $erreur_message==''){
							echo $inscription_message_titre;
							echo '<input type="hidden" name="inscription_message_titre" value="'.$inscription_message_titre.'">';
						}else{
						?>
							<input type="text" name="inscription_message_titre" value="<?=$inscription_message_titre?>" class="input" style="width: 470px;">
						<?php 
						}
						?>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte</div>
					<div id="formulaire_champ" style="width: 500px;">
						<?php 
						if(isset($action) AND isset($erreur_message) AND $erreur_message==''){
							echo '<span style="line-height: 16px;">'.$inscription_message_texte.'</span>';
							echo '<input type="hidden" name="inscription_message_texte" value="'.htmlentities($inscription_message_texte, ENT_QUOTES).'">';
						}else{
						?>
							<textarea name="inscription_message_texte" class="textarea" style="width: 470px; height: 550px; overflow: auto;"><?=$inscription_message_texte?></textarea>
						<?php 
						}
						?>
					</div>
					<br clear="all">
				</div>

				<?php if(!isset($action) OR (isset($action) AND $action=='confirmer')){ ?>
					<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_valider.png" width="123" height="40" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">retour</a></div>
				<?php }else{ ?>
					<br>
				<?php } ?>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.envoyer.inscription_message_objet.focus();
	//-->
</script>

</body>
</html>
