<?php 
/*
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

include '../lib/configuration.inc';


// Si le nom du joueur pro n'est pas connu, alors retour à l'inscription
if(!isset($_SESSION['SessionWeb_joueurs_am'][0]['nom'])){
	header('Location: ./inscription_1.php');
	exit;
}	





/************************************************************/
/**  RECUPERATION DES DONNEES (uniquement appels BDDs ici) **/
/************************************************************/

////////////////////////
// Données de SESSION //
////////////////////////


$hebornot = $_GET['hebornot'] == 'yes' ? 1 : 0;
$vue_piscine = $_GET['vue_piscine'];
$chambre_double = $_GET['chambre_double'];
$tripstart = $_GET['trip-start'];
$tripdepart = $_GET['trip-departure'];
$date1 = strftime("%d/%m/%Y", strtotime($tripstart));
$date2 = strftime("%d/%m/%Y", strtotime($tripdepart));



/////////////////
// Données BDD //
/////////////////

// données hébergements
$requete_heb = mysqli_query($connexion_mysql, 'SELECT hotel, prix FROM hebergements WHERE id_hotel="'.$_GET['hotel_id'].'" AND chambre_double = "'.$chambre_double.'" AND vue_piscine = "'.$vue_piscine.'"');
$resultat_heb = mysqli_fetch_array($requete_heb);
$nom_hotel = $resultat_heb[0];
$prix_chambre_nuit = $resultat_heb[1];



// Données compétition
$requete_compet = mysqli_query($connexion_mysql, 'SELECT prix_forfait, single_no_pisc, single_pisc, double_no_pisc, double_pisc, no_heb_pro_no_hotel, no_heb_pro_hotel, competition_annee, DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), DATE_FORMAT(competition_date_fin, "%d/%m/%Y"), date_debut_hotel, date_fin_hotel, DATE_FORMAT(date_debut_hotel_gratuit, "%d/%m/%Y"), DATE_FORMAT(date_fin_hotel_gratuit, "%d/%m/%Y") FROM competitions WHERE competition_id = "'.$_SESSION['SessionWeb_competition_id'].'"');
$resultat_compet = mysqli_fetch_array($requete_compet);

// prix forfait
$prix_forfait = $resultat_compet[0];
$no_heb_pro_no_hotel = $resultat_compet[5];
$no_heb_pro_hotel = $resultat_compet[6];

// prix option supp : 
$prix_options = array(
	'single_no_pisc' => $resultat_compet[1],
	'single_pisc' => $resultat_compet[2],
	'double_no_pisc' => $resultat_compet[3],
	'double_pisc' => $resultat_compet[4]
);

// annee compet, date debut et fin
$competition_annee = $resultat_compet[7];
$competition_date_debut = $resultat_compet[8];
$competition_date_fin = $resultat_compet[9];

// dates liées à l'hébergement
$date_debut_hotel_gratuit = $resultat_compet[12];
$date_fin_hotel_gratuit = $resultat_compet[13];




/*******************************/
/**  TRAITEMENT DES DONNÉES **/
/*******************************/

// array FORFAIT
$forfait_arr = array(
	'desc' => 'forfait Amateur',
	'prix' => $_GET['hotel_id'] == 'empty' ? $no_heb_pro_hotel : $prix_forfait,
	'type_libelle' => 'forfait'
);



// array OPTION SUPP
$option_supp = array(
	'desc' => '',
	'prix' => 0,
	'type_libelle' => 'option'
);

$condition_no_option = false; /// MAIS PEUT CHANGER EN FONCTION DU SITE


// Si il y a une option
if(!$condition_no_option and $hebornot == 1) {
	if(!$chambre_double and !$vue_piscine) { // dans l'admin "Option single no piscine"
		$option_supp['desc'] = 'Options: chambre simple';
		$option_supp['prix'] = $prix_options['single_no_pisc'];
	}
	if(!$chambre_double and $vue_piscine) { // si option = chambre simpl e + vue piscine
		$option_supp['desc'] = 'Options: chambre simple + vue piscine';
		$option_supp['prix'] = $prix_options['single_pisc'];
	}
	if($chambre_double and !$vue_piscine) { // si option = chambre simple + vue piscine
		$option_supp['desc'] = 'Options: aucune';
		$option_supp['prix'] = $prix_options['double_no_pisc'];
	}
	if($chambre_double and $vue_piscine) { // si option = chambre simple + vue piscine
		$option_supp['desc'] = 'Options: vue piscine';
		$option_supp['prix'] = $prix_options['double_pisc'];
	}
}




// array HEBERGEMENT GRATIS
$hebergement_gratis = array(
	'desc' => $heb_gratis_1.$nom_hotel.$heb_gratis_2.$date_debut_hotel_gratuit.$heb_gratis_3.$date_fin_hotel_gratuit.$heb_gratis_4,
	'prix' => 0
);

// array JOURS SUPP
$hebergement_jours_supp = array(
	'desc' => '',
	'prix' => 0,
	'type_libelle' => 'heb'
);

// nbre de jours total d'hebergements  souhaité (nber_nights)
$earlier = new DateTime($tripdepart);
$later = new DateTime($tripstart);
$nber_nights = $later->diff($earlier)->format("%a");
$nber_nights = intval($nber_nights);

// nbre jours gratuits
$date_debut_hotel_gratuit_format = DateTime::createFromFormat('d/m/Y', $date_debut_hotel_gratuit);
$date_fin_hotel_gratuit_format = DateTime::createFromFormat('d/m/Y', $date_fin_hotel_gratuit);
$nber_nights_gratis = $date_debut_hotel_gratuit_format->diff($date_fin_hotel_gratuit_format)->format("%a");
$nber_nights_gratis = intval($nber_nights_gratis);

// différence #jours_gratis / #total_de_jours
$diff_nb_nights = $nber_nights - $nber_nights_gratis;

// si nbre jours gratis < nbre jours ALORS on ajoute la différence !!
if($nber_nights_gratis < $nber_nights) {
	$hebergement_jours_supp['desc'] = strval($diff_nb_nights).' nuit(s) en plus (total: du '.$date1.' au '.$date2.')';
	$hebergement_jours_supp['prix'] = $diff_nb_nights * $prix_chambre_nuit;
}

// données pour l'enregistrement de la facture
$prix_forfait = $forfait_arr['prix'];
$prix_option = $option_supp['prix'];
$prix_heb = $prix_option + $hebergement_jours_supp['prix']; // dans le cas du pro: option_supp + hebergement_jours_supp

// type d'hébergement
$type_heb = 0;
if( (isset($_GET['hotel_id']) && $_GET['hotel_id'] == 'empty') ) {
	$type_heb = 0; // PAS d'hébergement
} else if ( isset($_SESSION['chambre_double']) && $chambre_double == 1 && (int)$diff_nb_nights == 0 ) {
	$type_heb = 1; // Hébergement standard, dates standard
} else {
	$type_heb = 2;	// autre
}

// prix total pour la facture
$facture_prix_total_ht = $prix_heb + $prix_forfait;
$facture_prix_total_tva = 0;
$facture_prix_total_ttc = $prix_heb + $prix_forfait + $facture_prix_total_tva;

// tableau contenant toutes les lignes du tableau de la facture (hors 'prix total')
$lignes_table = array(
	$forfait_arr,
	$hebergement_gratis,
	$option_supp,
	$hebergement_jours_supp
);
$lignes_facture = $lignes_table; // on a besoin d'un array pour les lignes du tableau et un pour les lignes de la facture



// MAJ de la description du forfait, si pas d'hébergement, l'amateur a deux choix (pro logé ou non)
$lignes_table[0]['desc'] = $type_heb == 0 ? $desc_forfait_amateur_prologe : $desc_forfait_amateur;




// Lors du clique sur Valider
if(isset($autorisation) AND $autorisation=='facturation'){

	// on MAJ la section "forfait" de la facture (en fonction du checkbox choisi par l'utilisateur quant au pro heberge ou non) DESC
	$lignes_facture[0]['desc'] = $type_heb == 0 ? ( $_POST['facture_golfeur_prix_total_ht'] == $no_heb_pro_hotel ? $desc_forfait_amateur_prologe : $desc_forfait_amateur_prononloge) : $desc_forfait_amateur;

	// on MAJ la section "forfait" de la facture (en fonction du checkbox choisi par l'utilisateur quant au pro heberge ou non)	PRIX
	$lignes_facture[0]['prix'] = $_POST['facture_prix_forfait'];

	//$lignes_facture[0]['prix'] = $_GET['']

	// ANCIEN_DEV
	if(!isset($joueur_package)) {
		$formulaire_erreur[] = 'joueur_package';
	} elseif($joueur_package=='entreprise') {
		if($joueur_entreprise_representant=='0'){
			$formulaire_erreur[] = 'joueur_entreprise_representant';
		}
		if(strlen(trim($joueur_entreprise_nom))==0){
			$formulaire_erreur[] = 'joueur_entreprise_nom';
		}
		if(strlen(trim($joueur_entreprise_adresse_1))==0){
			$formulaire_erreur[] = 'joueur_entreprise_adresse_1';
		}
		if(strlen(trim($joueur_entreprise_code_postal))==0){
			$formulaire_erreur[] = 'joueur_entreprise_code_postal';
		}
		if(strlen(trim($joueur_entreprise_ville))==0){
			$formulaire_erreur[] = 'joueur_entreprise_ville';
		}
		if($joueur_entreprise_pays=='0'){
			$formulaire_erreur[] = 'joueur_entreprise_pays';
		}
	}

	// on check si un joueur pro a été associé au joueur amateur
	$all_joueurs_noms_res = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_email FROM joueurs');
	$bool = false; // vrai si joueur pro a été retrouvé dans la bdd
	while($row = $all_joueurs_noms_res->fetch_assoc()) {
		$val1 = strval($row['joueur_prenom'])." ".strval($row['joueur_nom']);
		$val2 = strval($joueur_pro_prenom)." ".strval($joueur_pro_nom);
		similar_text(strtolower($val1), strtolower($val2), $percent);
		if($percent > 90) {
			$bool = true;
			$prenom = $row['joueur_prenom'];
			$nom = $row['joueur_nom'];
			$joueur_mail = $row['joueur_email'];
			$joueur_id = $row['joueur_id'];
			$_SESSION['SessionWeb_joueur_pro']['email'] = $joueur_mail;
			break;
		}
	}
	if($joueur_pro_prenom == '' AND $joueur_pro_nom == '')
		$bool = true;
	if($bool==false) {
		$formulaire_erreur[] = 'joueur_pro_inconnu';
	} else { // si joueur pro a été retrouvé, on sélectionne ses données en BDD et on MAJ les données de session qui lui sont associées
		$requete_verification_2_joueur_pro = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_sexe, joueur_nom, joueur_prenom, ej_equipe FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE joueur_id="'.$joueur_id.'"');
		$resultat_verification_2_joueur_pro = mysqli_fetch_array($requete_verification_2_joueur_pro);
		$joueur_pro_id = $resultat_verification_2_joueur_pro[0];
		$joueur_pro_sexe = $resultat_verification_2_joueur_pro[1];
		$joueur_pro_nom = $resultat_verification_2_joueur_pro[2];
		$joueur_pro_prenom = $resultat_verification_2_joueur_pro[3];
		$joueur_equipe_id = $resultat_verification_2_joueur_pro[4];
		//
		$_SESSION['SessionWeb_joueur_pro']['id'] = $joueur_pro_id;
		$_SESSION['SessionWeb_joueur_pro']['sexe'] = $joueur_pro_sexe;
		$_SESSION['SessionWeb_joueur_pro']['nom'] = $joueur_pro_nom;
		$_SESSION['SessionWeb_joueur_pro']['prenom'] = $joueur_pro_prenom;
		$_SESSION['SessionWeb_joueur_pro']['email'] = $joueur_mail;
	}





	// si pas d'erreur dans le formulaire (ici un seul input, le joueur pro...)
	if(count($formulaire_erreur)==0) {

		/**********************************/
		/**  INSCRIPTION DU JOUEUR PRO   **/
		/**********************************/

		// Si le joueur professionnel a déjà été déclaré à l'équipe, on récupère son ID
		if(isset($_SESSION['SessionWeb_joueur_pro']['id'])){
			$joueur_pro_id = $_SESSION['SessionWeb_joueur_pro']['id'];
			// Récupération de l'ID de l'équipe
			$requete_equipe_id = mysqli_query($connexion_mysql, 'SELECT ej_equipe FROM equipes_joueurs WHERE ej_joueur="'.$_SESSION['SessionWeb_joueur_pro']['id'].'"');
			$resultat_equipe_id = mysqli_fetch_array($requete_equipe_id);
			$equipe_id = $resultat_equipe_id[0];
		} else { // Sinon, on inscrit le joueur pro
			$equipe_id = uniqid();
			$equipe_motdepasse = md5('proamcoteopale');

			// Si le joueur professionnel a été enregistré par le joueur amateur en cours d'inscription
			if(isset($_SESSION['SessionWeb_joueur_pro']['email']) AND $_SESSION['SessionWeb_joueur_pro']['prenom'] != '' AND $_SESSION['SessionWeb_joueur_pro']['nom']  != '') {
				$joueur_pro_id = uniqid();
				$ej_id = uniqid();
				$equipe_nom = $_SESSION['SessionWeb_joueur_pro']['nom'];
				if($_SESSION['SessionWeb_joueur_pro']['handicap']==NULL){ $requete_pro_handicap = 'NULL'; }else{ $requete_pro_handicap = '"'.$_SESSION['SessionWeb_joueur_pro_handicap'].'"'; }

				// Création du joueur pro en base de données
				$requete_creation_joueur_pro = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_club, joueur_licence, joueur_handicap, joueur_membre_club_competition, joueur_sexe, joueur_nom, joueur_prenom, joueur_date_naissance, joueur_taille_polo, joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_langue, joueur_datetime_creation) VALUES("'.$joueur_pro_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "pro", "'.$_SESSION['SessionWeb_joueur_pro']['club'].'", "'.$_SESSION['SessionWeb_joueur_pro']['licence'].'", '.$requete_pro_handicap.', "'.$_SESSION['SessionWeb_joueur_pro']['membre_club_competition'].'", "'.$_SESSION['SessionWeb_joueur_pro']['sexe'].'", "'.$_SESSION['SessionWeb_joueur_pro']['nom'].'", "'.$_SESSION['SessionWeb_joueur_pro']['prenom'].'", STR_TO_DATE("'.$_SESSION['SessionWeb_joueur_pro']['date_naissance'].'", "%d/%m/%Y"), "'.$_SESSION['SessionWeb_joueur_pro']['taille_polo'].'", "'.$_SESSION['SessionWeb_joueur_pro']['adresse_1'].'", "'.$_SESSION['SessionWeb_joueur_pro']['adresse_2'].'", "'.$_SESSION['SessionWeb_joueur_pro']['code_postal'].'", "'.$_SESSION['SessionWeb_joueur_pro']['ville'].'", "'.$_SESSION['SessionWeb_joueur_pro']['pays'].'", "'.$_SESSION['SessionWeb_joueur_pro']['email'].'", "'.$_SESSION['SessionWeb_joueur_pro']['mobile'].'", "'.$_SESSION['SessionWeb_joueur_pro']['telephone'].'", "'.$_SESSION['SessionWeb_langue'].'", "'.date('Y-m-d H:i:s').'")');

				// Ajout du joueur professionnel dans l'équipe en base de données
				$requete_equipe_joueur_pro = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_pro_id.'")');
			} else {
				$equipe_nom = 'EQUIPE_TEMP_'.date('m').date('d').date('s');
			}
			// Création de l'équipe en base de données
			$requete_creation_equipe = mysqli_query($connexion_mysql, 'INSERT INTO equipes (equipe_id, competition_id, equipe_nom, equipe_motdepasse) VALUES("'.$equipe_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "'.$equipe_nom.'", "'.$equipe_motdepasse.'")');
		}

		// Ajout des amateurs
		if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0) {
			foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle=>$joueur_am){

				$joueur_id = $_SESSION['SessionWeb_joueurs_am'][$joueur_am_cle]['id'] = uniqid();
				$ej_id = uniqid();
				if($joueur_am['handicap']==NULL){ $requete_am_handicap = 'NULL'; }else{ $requete_am_handicap = '"'.$joueur_am['handicap'].'"'; }

				// Création du joueur amateur en base de données
				$requete_creation_joueur_am = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_club, joueur_licence, joueur_handicap, joueur_membre_club_competition, joueur_sexe, joueur_nom, joueur_prenom, joueur_date_naissance, joueur_taille_polo, joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_langue, joueur_datetime_creation) VALUES("'.$joueur_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "am", "'.$joueur_am['club'].'", "'.$joueur_am['licence'].'", '.$requete_am_handicap.', "'.$joueur_am['membre_club_competition'].'", "'.$joueur_am['sexe'].'", "'.$joueur_am['nom'].'", "'.$joueur_am['prenom'].'", STR_TO_DATE("'.$joueur_am['date_naissance'].'", "%d/%m/%Y"), "'.$joueur_am['taille_polo'].'", "'.$joueur_am['adresse_1'].'", "'.$joueur_am['adresse_2'].'", "'.$joueur_am['code_postal'].'", "'.$joueur_am['ville'].'", "'.$joueur_am['pays'].'", "'.$joueur_am['email'].'", "'.$joueur_am['mobile'].'", "'.$joueur_am['telephone'].'", "'.$_SESSION['SessionWeb_langue'].'", "'.date('Y-m-d H:i:s').'")');

				// Ajout des joueurs amateurs dans l'équipe en base de données
				$requete_equipe_joueur_am = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_id.'")');
			}
		}

		// Ajout des amateurs déjà inscrits ( ANCIEN_DEV )
		if(isset($_SESSION['SessionWeb_joueurs_am_temp']) AND count($_SESSION['SessionWeb_joueurs_am_temp'])!=0) {
			foreach($_SESSION['SessionWeb_joueurs_am_temp'] as $joueur_am_inscrit_cle=>$joueur_am_inscrit){
				// Suppression du rattachement du joueur amateur à son ancienne équipe (qui devient souvent vide) pour rejoindre la nouvelle équipe créée
				$requete_equipe_joueur_am = mysqli_query($connexion_mysql, 'DELETE FROM equipes_joueurs WHERE ej_joueur="'.$joueur_am_inscrit['id'].'"');
				$ej_id = $_SESSION['SessionWeb_joueurs_am_temp'][$joueur_am_inscrit_cle]['id'] = uniqid();
				// Ajout des joueurs amateurs dans l'équipe en base de données
				$requete_equipe_joueur_am = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_am_inscrit['id'].'")');
			}
			// Sélection des équipes temporaires
			$requete_equipes_temp = mysqli_query($connexion_mysql, 'SELECT equipe_id FROM equipes WHERE equipe_nom LIKE "EQUIPE_TEMP%"');
			$nb_equipes_temp = mysqli_num_rows($requete_equipes_temp);
			if($nb_equipes_temp!=0){
				for($equipe_temp_boucle=0; $equipe_temp_boucle<$nb_equipes_temp; $equipe_temp_boucle++){
					$resultat_equipe_temp = mysqli_fetch_array($requete_equipes_temp);
					$equipe_id = $resultat_equipe_temp[0];
					// Sélection du nombre de joueurs dans l'équipe temporaire
					$requete_equipes_temp_joueurs = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs WHERE ej_equipe="'.$equipe_id.'"');
					$nb_equipes_temp_joueurs = mysqli_num_rows($requete_equipes_temp_joueurs);
					if($nb_equipes_temp_joueurs==0){
						// Suppression de l'équipe vide
						$requete_suppression_equipe = mysqli_query($connexion_mysql, 'DELETE FROM equipes WHERE equipe_id="'.$equipe_id.'"');
					}
				}
			}
		}

		// Ajout des accompagnateurs ( ANCIEN_DEV )
		if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0) {
			foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc){
				$joueur_id = uniqid();
				$ej_id = uniqid();
				// Création de l'accompagnateur en base de données
				$requete_creation_joueur_acc = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_sexe, joueur_nom, joueur_prenom, joueur_langue, joueur_datetime_creation) VALUES("'.$joueur_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "acc", "'.$joueur_acc['sexe'].'", "'.$joueur_acc['nom'].'", "'.$joueur_acc['prenom'].'", "'.$_SESSION['SessionWeb_langue'].'", "'.date('Y-m-d H:i:s').'")');
				// Ajout des joueurs amateurs dans l'équipe en base de données
				$requete_equipe_joueur_acc = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur, ej_joueur_accompagnant) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_id.'", "'.$_SESSION['SessionWeb_joueurs_am'][0]['id'].'")');
			}
		}



		/*****************************************/
		/** MAJ DU NOMBRE DE CHAMBRES DISPO **/
		/*****************************************/

		// select current nber of rooms
		$requete_qtte = mysqli_query($connexion_mysql, 'SELECT qtte FROM hebergements WHERE hotel = "'.$nom_hotel.'" AND vue_piscine = "'.$vue_piscine.'" AND chambre_double = "'.$chambre_double.'"');
		$res_qtte = mysqli_fetch_array($requete_qtte);
		$res_qtte = $res_qtte[0];
		$new_qtte = $res_qtte-1;

		// update new number
		$requete_up_qtte = mysqli_query($connexion_mysql, 'UPDATE hebergements SET qtte = "'.$new_qtte.'" WHERE hotel = "'.$nom_hotel.'" AND vue_piscine = "'.$vue_piscine.'" AND chambre_double = "'.$chambre_double.'"');


		/*****************************************/
		/**  ENVOI DE L'E-MAIL DE CONFIRMATION  **/
		/*****************************************/

		// Récupération des infos sur la compétition
		$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_annee, DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), DATE_FORMAT(competition_date_fin, "%d/%m/%Y") FROM competitions WHERE competition_id="'.$_SESSION['SessionWeb_competition_id'].'"');
		$resultat_competition = mysqli_fetch_array($requete_competition);
		$competition_annee = $resultat_competition[0];
		$competition_date_debut = $resultat_competition[1];
		$competition_date_fin = $resultat_competition[2];

		// Paramètres du message à envoyer
		$emailing_sujet_confirmation = $txt_am_etape6_email_confirmation_sujet.' '.$competition_annee;
		$emailing_titre_confirmation = $txt_am_etape6_email_confirmation_titre;
		$emailing_sujet_rattachement_1 = $txt_am_etape6_email_rattachement_1_sujet.' '.$competition_annee;
		$emailing_titre_rattachement_1 = $txt_am_etape6_email_rattachement_1_titre;
		$emailing_sujet_rattachement_2 = $txt_am_etape6_email_rattachement_2_sujet.' '.$competition_annee;
		$emailing_titre_rattachement_2 = $txt_am_etape6_email_rattachement_2_titre;


		// S'il y a un joueur professionnel qui a été rattaché, alors on leur envoie un e-mail pour l'informer du rattachement
		if(isset($_SESSION['SessionWeb_joueur_pro']['id'])) {

			if($joueur_acc['sexe']=='H'){ $txt_am_etape6_email_1_message_civilite = $txt_monsieur; }else{ $txt_am_etape6_email_1_message_civilite = $txt_madame; }

			$emailing_pro_message  = $txt_am_etape6_email_1_message_1." ".$txt_am_etape6_email_1_message_civilite." ".$_SESSION['SessionWeb_joueur_pro']['nom'].",<br><br>\n";
			$emailing_pro_message .= $txt_am_etape6_email_1_message_2." ".$_SESSION['SessionWeb_joueurs_am'][0]['nom']." ".$_SESSION['SessionWeb_joueurs_am'][0]['prenom']." ".$txt_am_etape6_email_1_message_3." ".$competition_date_debut." ".$txt_am_etape6_email_1_message_4." ".$competition_date_fin.".<br><br>\n";
			$emailing_pro_message .= $txt_am_etape6_email_1_message_5;

			// Envoi de l'e-mail de confirmation d'inscription au joueur pro
			emailing_envoi($web_email_alerte, $_SESSION['SessionWeb_joueur_pro']['email'], '', '', $emailing_sujet_rattachement_1, $emailing_titre_rattachement_1, $emailing_pro_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);

		// S'il y a un joueur professionnel qui a été inscrit, alors on lui envoie un e-mail de confirmation
		} elseif (!isset($_SESSION['SessionWeb_joueur_pro']['id']) AND isset($_SESSION['SessionWeb_joueur_pro']['email'])) {

			if($_SESSION['SessionWeb_joueur_pro']['sexe']=='H'){ $txt_am_etape6_email_2_message_civilite = $txt_monsieur; }else{ $txt_am_etape6_email_2_message_civilite = $txt_madame; }

			$emailing_pro_message  = $txt_am_etape6_email_2_message_1." ".$txt_am_etape6_email_2_message_civilite." ".$_SESSION['SessionWeb_joueur_pro']['nom'].",<br><br>\n";
			$emailing_pro_message .= $txt_am_etape6_email_2_message_2." ".$_SESSION['SessionWeb_joueurs_am'][0]['nom']." ".$_SESSION['SessionWeb_joueurs_am'][0]['prenom'].", ".$txt_am_etape6_email_2_message_3." ".$competition_date_debut." ".$txt_am_etape6_email_2_message_4." ".$competition_date_fin.".<br><br>\n";
			$emailing_pro_message .= $txt_am_etape6_email_2_message_5;

			// Envoi de l'e-mail de confirmation d'inscription
			emailing_envoi($web_email_alerte, $_SESSION['SessionWeb_joueur_pro']['email'], '', '', $emailing_sujet_rattachement_1, $emailing_titre_rattachement_1, $emailing_pro_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);

		}

		// S'il y a des joueurs amateurs, alors on leur envoie un e-mail de confirmation
		if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am']!=0)) {

			foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle=>$joueur_am) {

				// Joueur amateur qui fait l'inscription en cours
				if($joueur_am_cle==0){

					if($joueur_am['sexe']=='H'){ $txt_am_etape6_email_3_message_civilite = $txt_monsieur; }else{ $txt_am_etape6_email_3_message_civilite = $txt_madame; }

					$emailing_am_message  = $txt_am_etape6_email_3_message_1." ".$txt_am_etape6_email_3_message_civilite." ".$joueur_am['nom'].",<br><br>\n";
					$emailing_am_message .= $txt_am_etape6_email_3_message_2." ".$competition_date_debut." ".$txt_am_etape6_email_3_message_3." ".$competition_date_fin.".<br><br>\n";
					$emailing_am_message .= $txt_am_etape6_email_3_message_4;

					// Envoi de l'e-mail de confirmation d'inscription
					emailing_envoi($web_email_alerte, $joueur_am['email'], '', '', $emailing_sujet_confirmation, $emailing_titre_confirmation, $emailing_am_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);

				// Joueur(s) amateur(s) inscrit(s) par le joueur amateur ci-dessus
				} else {

					if($joueur_am['sexe']=='H'){ $txt_am_etape6_email_4_message_civilite = $txt_monsieur; }else{ $txt_am_etape6_email_4_message_civilite = $txt_madame; }

					$emailing_am_message  = $txt_am_etape6_email_4_message_1." ".$txt_am_etape6_email_4_message_civilite." ".$joueur_am['nom'].",<br><br>\n";
					$emailing_am_message .= $txt_am_etape6_email_4_message_2." ".$_SESSION['SessionWeb_joueurs_am'][0]['nom']." ".$_SESSION['SessionWeb_joueurs_am'][0]['prenom'].", ".$txt_am_etape6_email_4_message_3." ".$competition_date_debut." ".$txt_am_etape6_email_4_message_4." ".$competition_date_fin.".<br><br>\n";
					$emailing_am_message .= $txt_am_etape6_email_4_message_5;

					// Envoi de l'e-mail de confirmation d'inscription
					emailing_envoi($web_email_alerte, $joueur_am['email'], '', '', $emailing_sujet_confirmation, $emailing_titre_confirmation, $emailing_am_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);

				}

			}
		}

		// S'il y a des joueurs amateurs déjà inscrits, alors on leur envoie un e-mail pour les informer du rattachement
		if(isset($_SESSION['SessionWeb_joueurs_am_temp']) AND count($_SESSION['SessionWeb_joueurs_am_temp']!=0)){
			foreach($_SESSION['SessionWeb_joueurs_am_temp'] as $joueur_am_temp){

				if($joueur_am_temp['sexe']=='H'){ $txt_am_etape6_email_5_message_civilite = $txt_monsieur; }else{ $txt_am_etape6_email_5_message_civilite = $txt_madame; }

				$emailing_am_temp_message  = $txt_am_etape6_email_5_message_1." ".$txt_am_etape6_email_5_message_civilite." ".$joueur_am_temp['nom'].",<br><br>\n";
				$emailing_am_temp_message .= $txt_am_etape6_email_5_message_2." ".$_SESSION['SessionWeb_joueurs_am'][0]['nom']." ".$_SESSION['SessionWeb_joueurs_am'][0]['prenom']." ".$txt_am_etape6_email_5_message_3." ".$competition_date_debut." ".$txt_am_etape6_email_5_message_4." ".$competition_date_fin.".<br><br>\n";
				$emailing_am_temp_message .= $txt_am_etape6_email_5_message_5;

				// Envoi de l'e-mail de confirmation de rattachement au joueur amateur inscrit
				emailing_envoi($web_email_alerte, $joueur_am_temp['email'], '', '', $emailing_sujet_rattachement_1, $emailing_titre, $emailing_am_temp_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);
			}
		}


		/********************/
		/**  EMAIL ALERTE  **/
		/********************/

		$alerte_titre  = 'NOUVEAUX INSCRITS AU PRO-AM MARRAKECH '.$competition_annee.'<br><br>';
		if(isset($joueur_package) AND strlen(trim($joueur_package))!=0){
			$alerte_titre .= 'PACKAGE '.strtoupper($joueur_package);
		}

		$alerte_message = '';

		if(!isset($_SESSION['SessionWeb_joueur_pro']['id']) AND isset($_SESSION['SessionWeb_joueur_pro']['email'])){
			$alerte_message .= '<br><b><u>PROFESSIONNEL</u> :</b><br><br>';
			if($_SESSION['SessionWeb_joueur_pro']['sexe']=='H'){ $professionnel_civilite = 'M.'; }else{ $professionnel_civilite = 'Mme'; }
			$alerte_message .= $professionnel_civilite.' '.$_SESSION['SessionWeb_joueur_pro']['nom'].' '.$_SESSION['SessionWeb_joueur_pro']['prenom'].'<br><br>';
		}

		if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am']!=0)){
			$alerte_message .= '<br><b><u>AMATEUR(S)</u> :</b><br><br>';
			foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle=>$joueur_am){
				if($joueur_am['sexe']=='H'){ $amateur_civilite = 'M.'; }else{ $amateur_civilite = 'Mme'; }
				$alerte_message .= $amateur_civilite.' '.$joueur_am['nom'].' '.$joueur_am['prenom'].'<br><br>';
			}
		}

		if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc']!=0)){
			$alerte_message .= '<br><b><u>ACCOMPAGNATEUR(S)</u> :</b><br><br>';
			foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc_cle=>$joueur_acc){
				if($joueur_acc['sexe']=='H'){ $accompagnateur_civilite = 'M.'; }else{ $accompagnateur_civilite = 'Mme'; }
				$alerte_message .= $accompagnateur_civilite.' '.$joueur_acc['nom'].' '.$joueur_acc['prenom'].'<br><br>';
			}
		}

		if(strlen(trim($facture_message_joueur))!=0){
			$facture_message_joueur_bis = preg_replace('/\n/', '<br>', $facture_message_joueur);
			$alerte_message .= '<br><hr><br><br>';
			$alerte_message .= '<b><u>MESSAGE POUR L\'INSCRIPTION / FACTURATION</u> :</b><br><br>';
			$alerte_message .= stripslashes($facture_message_joueur_bis).'<br><br>';
		}


		$from_email = "proam@golf-first.fr";

		$web_email_alerte = array("proam@golf-first.fr");
		$emailing_destinataires_cc_email = '';
		$emailing_destinataires_cc_email = "laetitia@makilas-golftour.com;makilasgolf@gmail.com";


		// Envoi de l'e-mail d'alerte   !!!!!!!!!!!!!!!!!!!!!!!!!    DECOMMENTER !!!
		emailing_envoi($from_email, $web_email_alerte, $emailing_destinataires_cc_email, '', '[ alerte ] Nouveaux inscrits au Pro-Am Marrakech '.$competition_annee, $alerte_titre, $alerte_message, $web_url.'/emailing_alerte.htm', $web_url, $_SESSION['SessionWeb_langue']);

		/****************************************/
		/**  ENREGISTREMENT DE LA FACTURATION  **/
		/****************************************/



		if($joueur_package=='entreprise'){
			if($joueur_entreprise_representant=='pro'){
				$joueur_entreprise_representant_id = $_SESSION['SessionWeb_joueur_pro']['id'];
			}else{
				$joueur_entreprise_representant_tab = explode('_', $joueur_entreprise_representant);
				$joueur_entreprise_representant_cle = $joueur_entreprise_representant_tab[1];
				if($joueur_entreprise_representant_tab[0]=='am'){
					$joueur_entreprise_representant_id = $_SESSION['SessionWeb_joueurs_am'][$joueur_entreprise_representant_cle]['id'];
				}else{
					$joueur_entreprise_representant_id = $_SESSION['SessionWeb_joueurs_am_temp'][$joueur_entreprise_representant_cle]['id'];
				}
			}
			$joueur_entreprise_nom = htmlentities(strtoupper_max(stripslashes($joueur_entreprise_nom)), ENT_QUOTES);
			$joueur_entreprise_adresse_1 = htmlentities(ucfirst(stripslashes($joueur_entreprise_adresse_1)), ENT_QUOTES);
			$joueur_entreprise_adresse_2 = htmlentities(ucfirst(stripslashes($joueur_entreprise_adresse_2)), ENT_QUOTES);
			$joueur_entreprise_code_postal = htmlentities(ucfirst(stripslashes($joueur_entreprise_code_postal)), ENT_QUOTES);
			$joueur_entreprise_ville = htmlentities(strtoupper_max(stripslashes($joueur_entreprise_ville)), ENT_QUOTES);
			$joueur_entreprise_pays = $joueur_entreprise_pays;
		}
		$facture_message_joueur = htmlentities(ucfirst(stripslashes($facture_message_joueur)), ENT_QUOTES);


		if ( isset($_POST['joueur_package']) ) {
			$joueur_package =  $_POST['joueur_package'];
		}


		if ( $joueur_package == 'golfeur' ) {

		

			/****  AMATEUR(S)  ****/

			foreach( $_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle => $joueur_am ) {


				$facture_id = uniqid();

				// Création du numéro de facture
				$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
				$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
				$facture_numero = $resultat_facture_numero_max[0] + 1;

				if ( $joueur_am['membre_club_competition']==1 ) {

					$facture_libelle_joueurs = $txt_am_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_am_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_am_etape6_libelle_facture_3."\n".$joueur_am['nom'].' '.$joueur_am['prenom']."\n";

					$facture_prix_golfeur_ht = $facture_prix_golfeur_membre_ht;
					$facture_prix_golfeur_tva = $facture_prix_golfeur_membre_tva;
					$facture_prix_golfeur_ttc = $facture_prix_golfeur_membre_ttc;
					
					
				} else {

					$facture_libelle_joueurs = $txt_am_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_am_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_am_etape6_libelle_facture_4."\n".$joueur_am['nom'].' '.$joueur_am['prenom']."\n";

					$facture_prix_golfeur_ht = $facture_prix_golfeur_pasmembre_ht;
					$facture_prix_golfeur_tva = $facture_prix_golfeur_pasmembre_tva;
					$facture_prix_golfeur_ttc = $facture_prix_golfeur_pasmembre_ttc;

				}

				$facture_prix_golfeur_ht = $_POST['facture_golfeur_prix_total_ht'];
				$facture_prix_golfeur_tva = $_POST['facture_golfeur_prix_total_tva'];
				$facture_prix_golfeur_ttc = $_POST['facture_golfeur_prix_total_ttc'];



				################################################################


				foreach ($lignes_facture as $key => $value) {

					if(!empty($value['desc'])) {

						// Création des libellés de la facture en base de données
						$requete_creation_libelle = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht, type_libelle) VALUES("'.$facture_id.'", "'.$value['desc'].'", "'.$value['prix'].'", "1", "'.$value['prix'].'", "'.$value['type_libelle'].'")') or die(mysqli_error($connexion_mysql)) or die(mysqli_error($connexion_mysql));
					}
				}



				$facture_prix_golfeur_ht = number_format($facture_prix_golfeur_ht, 2, ".", "");

				// Création de la facture en base de données
				$requete_creation_facture = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_date, prix_forfait, prix_option, prix_heb, date_arrivee, date_depart, facture_message_heures) VALUES("'.$facture_id.'", "'.$joueur_id.'", "'.$facture_numero.'", "'.$joueur_package.'", "'.$facture_prix_golfeur_ht.'", "'.$facture_prix_golfeur_tva.'", "'.$facture_prix_golfeur_ttc.'", "'.$facture_message_joueur.'", "'.date('Y-m-d').'", "'.$prix_forfait.'", "'.$prix_option.'", "'.$prix_heb.'", "'.$tripstart.'", "'.$tripdepart.'", "'.$facture_message_heures.'")') or die(mysqli_error($connexion_mysql));


			}

			/****  ACCOMPAGNATEUR(S)  ****/

			if( count($_SESSION['SessionWeb_joueurs_acc'])!=0 ) {

				$facture_id = uniqid();

				// Création du numéro de facture
				$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
				$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
				$facture_numero = $resultat_facture_numero_max[0] + 1;

				$facture_libelle_accompagnateurs = $txt_am_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_am_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_am_etape6_libelle_facture_5;

				foreach ($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc) {
					$facture_libelle_accompagnateurs .= "\n".$joueur_acc['nom']." ".$joueur_acc['prenom'];
				}

				// Calculs
				$facture_prix_accompagnateur_total_ht = $facture_prix_accompagnateur_ht * count($_SESSION['SessionWeb_joueurs_acc']);
				$facture_prix_accompagnateur_tva = $facture_prix_accompagnateur_tva * count($_SESSION['SessionWeb_joueurs_acc']);
				$facture_prix_accompagnateur_total_ttc = $facture_prix_accompagnateur_total_ht + $facture_prix_accompagnateur_tva;

				// Création du libellé de la facture en base de données
				$requete_creation_libelle = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht) VALUES("'.uniqid().'", "'.$facture_id.'", "'.$facture_libelle_accompagnateurs.'", "'.$facture_prix_accompagnateur_ht.'", "'.count($_SESSION['SessionWeb_joueurs_acc']).'", "'.$facture_prix_accompagnateur_total_ht.'")');

				// Création de la facture en base de données
				$requete_creation_facture = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_date, facture_message_heures) VALUES("'.$facture_id.'", "'.$_SESSION['SessionWeb_joueurs_am'][0]['id'].'", "'.$facture_numero.'", "'.$joueur_package.'", "'.$facture_prix_accompagnateur_total_ht.'", "'.$facture_prix_accompagnateur_tva.'", "'.$facture_prix_accompagnateur_total_ttc.'", "'.$facture_message_joueur.'", "'.date('Y-m-d').'", "'.$facture_message_heures.'")');

			}

		}  /* FIN if(count($formulaire_erreur)==0)  */

		/********************************************/
		/**  SUPPRESSION DES VARIABLES DE SESSION  **/
		/********************************************/
		// Suppression des variables de session de l'inscription
		unset($_SESSION['SessionWeb_joueur_profil'], $_SESSION['SessionWeb_joueur_pro'], $_SESSION['SessionWeb_joueurs_am'], $_SESSION['SessionWeb_joueurs_am_temp'], $_SESSION['SessionWeb_joueurs_am'], $_SESSION['SessionWeb_joueurs_acc']);
		header('Location: ./inscription_7.php');	// Redirection vers la page de confirmation
		exit;
	} else {
		// Traitement d'affichage en cas d'erreur dans le formulaire
		$joueur_entreprise_nom = stripslashes($joueur_entreprise_nom);
		$joueur_entreprise_adresse_1 = stripslashes($joueur_entreprise_adresse_1);
		$joueur_entreprise_adresse_2 = stripslashes($joueur_entreprise_adresse_2);
		$joueur_entreprise_code_postal = stripslashes($joueur_entreprise_code_postal);
		$joueur_entreprise_ville = stripslashes($joueur_entreprise_ville);
		$facture_message_joueur = stripslashes($facture_message_joueur);
	}
}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='facturation')) {
	// Valeurs par défaut lorsque le formulaire est vierge
	$joueur_entreprise_representant = '0';
	$joueur_entreprise_nom = '';
	$joueur_entreprise_adresse_1 = '';
	$joueur_entreprise_adresse_2 = '';
	$joueur_entreprise_code_postale = '';
	$joueur_entreprise_ville = '';
	$joueur_entreprise_pays = 'FR';	$facture_message_joueur = '';
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<head>
		<title><?=$txt_page_titre?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=8">
		<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
		<meta name="robots" content="index, follow">
		<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
		<link rel="shortcut icon" href="/favicon.png">
		<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
		<script language="Javascript">
			function change_package(package){
				alert("hallo");
				if(document.getElementById('joueur_package_golfeur').checked==true){
					document.getElementById('calque_package_golfeur').className = 'inscription_radio_checked';
					document.getElementById('calque_package_entreprise').className = 'inscription_radio';

					document.getElementById('calque_package_golfeur_2').style.display = 'block';
					document.getElementById('calque_package_golfeur_3').style.display = 'none';

					document.getElementById('calque_package_golfeur_infos').style.display = 'block';
					document.getElementById('calque_package_entreprise_infos').style.display = 'none';
				}else if(document.getElementById('joueur_package_entreprise').checked==true){
					document.getElementById('calque_package_golfeur').className = 'inscription_radio';
					document.getElementById('calque_package_entreprise').className = 'inscription_radio_checked';

					document.getElementById('calque_package_golfeur_2').style.display = 'none';
					document.getElementById('calque_package_golfeur_3').style.display = 'block';

					document.getElementById('calque_package_golfeur_infos').style.display = 'none';
					document.getElementById('calque_package_entreprise_infos').style.display = 'block';
				}else{
					document.getElementById('calque_package_golfeur').className = 'inscription_radio';
					document.getElementById('calque_package_entreprise').className = 'inscription_radio';

					document.getElementById('calque_package_golfeur_2').style.display = 'none';
					document.getElementById('calque_package_golfeur_3').style.display = 'none';

					document.getElementById('calque_package_golfeur_infos').style.display = 'none';
					document.getElementById('calque_package_entreprise_infos').style.display = 'none';
				}
			}
		</script>
	</head>

	<body scroll="auto">

		<div id="page" align="center">
			<div id="contenu">
				<?php include './commun/entete.inc'; ?>
				<div id="formulaire">
					<form action="<?=$REQUEST_URI?>" method="post">
						<input type="hidden" name="autorisation" value="facturation">
						<input type="text" name="facture_golfeur_prix_total_ttc" hidden value=<?php echo($facture_prix_total_ttc); ?>>
						<input type="text" name="facture_golfeur_prix_total_ht" hidden value=<?php echo($facture_prix_total_ht); ?>>
						<input type="text" name="facture_golfeur_prix_total_tva" hidden value=<?php echo($facture_prix_total_tva); ?>>
						<input type="text" name="desc_forfait_amateur_prologe" hidden value="<?php echo($desc_forfait_amateur_prologe); ?>">
						<input type="text" name="desc_forfait_amateur_prononloge" hidden value="<?php echo($desc_forfait_amateur_prononloge); ?>">

						<?php
							$prix_forfait_input = 0;
							if(isset($_POST['facture_prix_forfait']))
								$prix_forfait_input = $_POST['facture_prix_forfait'];
							else
								$prix_forfait_input = $prix_forfait;
						?>

						<input type="text" name="facture_prix_forfait" hidden value=<?=$prix_forfait_input?> >

						<h1><?=$txt_am_etape6_titre?></h1>
						<div class="separateur"></div>
						<?=$txt_am_etape6_selectionnez_pack?><?php if(count($formulaire_erreur)!=0 AND in_array('joueur_package', $formulaire_erreur)==true){ echo '<span class="erreur_bis" hidden>'.$txt_obligatoire.'</span>'; } ?><br>
						<label for="joueur_package_golfeur">
							<div id="calque_package_golfeur" align="center" class="inscription_radio">
								<b><?=$txt_am_etape6_package?><br><img src="<?=$web_commun?>p.gif" width="1" height="5"><br><?=$txt_am_etape6_golfeur?></b><br><br>
								<input id="joueur_package_golfeur" type="radio" name="joueur_package" value="golfeur" style="margin: 0px;" <?php if(isset($joueur_package) AND $joueur_package=='golfeur'){ echo ' checked'; } ?>>
							</div>
						</label>
						<label for="joueur_package_entreprise" hidden>
							<div id="calque_package_entreprise" align="center" class="inscription_radio">
								<b><?=$txt_am_etape6_package?><br><img src="<?=$web_commun?>p.gif" width="1" height="5"><br><?=$txt_am_etape6_entreprise?></b><br><br>
								<input id="joueur_package_entreprise" type="radio" name="joueur_package" value="entreprise" style="margin: 0px;" <?php if(isset($joueur_package) AND $joueur_package=='entreprise'){ echo ' checked'; } ?>>
							</div>
						</label>
						<br clear="all"><br><br>
						<input type="hidden" name="ex2" value="ex2">
						<?php 
						if($type_heb == 0) { ?>
						<div class="colonne_gauche_obligatoire" style="height: 85px; padding-top: 0px;">Professionel logé à l'hôtel ?</div>
						<div class="colonne_droite" style="height: 33px;">
							<label for="yes">
								<?php
								echo '<input type="radio" id="pro_hotel_yes" name="pro_hotel" value="yes" checked />Oui'."\n";
								?>
							</label>
							<label for="no">
								<?php					
								echo '<input type="radio" id="pro_hotel_no" name="pro_hotel" value="no" />Non'."\n";
								?>
							</label>
						</div>
						<?php					
						echo '<input type="" name="no_heb_pro_hotel" value="'.$no_heb_pro_hotel.'" hidden />'."\n";
						echo '<input type="" name="no_heb_pro_no_hotel" value="'.$no_heb_pro_no_hotel.'" hidden />'."\n";
						?>
						<?php } ?>
						<input type="hidden" name="ex3" value="ex3">
						<br>
						<div id="calque_package_golfeur_2">
							<div class="separateur_ter"></div>
							<div id="package_facture">
								<b><u><?=$txt_am_etape6_soustitre_recapitulatif?></u></b><br><br>
								<table width="660" border="0" cellapdding="0" cellspacing="0">
									<tr>
										<td style="width: 320px;" class="entete_colonne"><?=$txt_am_etape6_colonne_description?></td>
										<td style="width: 120px;" class="entete_colonne"><?=$txt_am_etape6_colonne_prix_ht?></td>
										<td style="width: 100px;" class="entete_colonne"><?=$txt_am_etape6_colonne_tva?> (<?=$facture_tva?>%)</td>
										<td style="width: 120px;" class="entete_colonne"><?=$txt_am_etape6_colonne_prix_ttc?></td>
									</tr>
									<?php 
									if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0){

										$facture_prix_total_ht = $facture_prix_accompagnateur_ht * count($_SESSION['SessionWeb_joueurs_acc']);
										$facture_prix_tva = ($facture_prix_total_ht * $facture_tva) / 100;
										$facture_prix_total_ttc = $facture_prix_total_ht + $facture_prix_tva;

										echo '<tr style="height: 30px;">'."\n";
											echo '<td>&nbsp;&nbsp;&nbsp;'.$txt_pro_etape6_ligne_accompagnateur.'</td>'."\n";
											echo '<td align="right">'.number_format($facture_prix_accompagnateur_ht, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;</td>'."\n";
											echo '<td align="right">'.count($_SESSION['SessionWeb_joueurs_acc']).'&nbsp;&nbsp;&nbsp;</td>'."\n";
											echo '<td align="right">'.number_format($facture_prix_total_ht, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;</td>'."\n";
										echo '</tr>'."\n";
									}
									?>
								 	<?php
								 	foreach ($lignes_table as $key => $value) {
								 		if($value['desc'] != '') { ?>
											<tr style="height: 30px;">
												<td <?php if($key==0){ echo "class='change_js_bis'"; } ?> ><?php echo $value['desc']; ?></td>
												<td align="right" class="change_js_"><?php echo number_format($value['prix'], 2); ?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right"><?php echo number_format(0, 2); ?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right" class="change_js_"><?php echo number_format($value['prix'], 2); ?> &euro;&nbsp;&nbsp;&nbsp;</td>
											</tr>

								 		<?php } 
								 	}
									?>
									<tr>
										<td class="ligne_vide">&nbsp;</td>
										<td colspan="2" class="entete_ligne"><?=$txt_am_etape6_colonne_sous_total_ht?>&nbsp;&nbsp;&nbsp;</td>
										<td align="right" class="change_js_"><?=number_format($facture_prix_total_ht, 2).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
									</tr>
									<tr>
										<td class="ligne_vide">&nbsp;</td>
										<td colspan="2" class="entete_ligne"><?=$txt_am_etape6_colonne_tva?> (<?=number_format($facture_tva, 2)?>%)&nbsp;&nbsp;&nbsp;</td>
										<td align="right"><?=number_format($facture_prix_tva, 2).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
									</tr>
									<tr>
										<td class="ligne_vide">&nbsp;</td>
										<td colspan="2" class="entete_ligne"><?=$txt_am_etape6_colonne_total_ttc?>&nbsp;&nbsp;&nbsp;</td>
										<td align="right" class="change_js_" style="background-color: #EFEFEF; font-weight: bold;"><?=number_format($facture_prix_total_ttc, 2).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
									</tr>
								</table>
								<br>
							</div>
						</div>
						<div class="separateur_ter"></div>
						<b><?=$txt_am_etape3_saisir_nom_prenom_email?></b><br><br>
						<div class="colonne_gauche" style="width: 74px;"><?=$prenom_?></div>
						<div class="colonne_droite" style="width: 220px;"><input type="text" name="joueur_pro_prenom" value="<?=$joueur_pro_prenom?>" style="width: 170px;"></div>
						<div class="colonne_gauche" style="width: 76px;"><?=$nom_?></div>
						<div class="colonne_droite" style="width: 200px;"><input type="text" name="joueur_pro_nom" value="<?=$joueur_pro_nom?>" style="width: 170px;"></div>
						<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_pro_inconnu', $formulaire_erreur)==true AND isset($autorisation) AND $autorisation=='facturation') { echo '<div class="erreur">'.$txt_am_etape3_erreur_joueur_inconnu.'</div>'; } elseif(count($formulaire_erreur)!=0 AND in_array('joueur_pro_impossible_1', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_am_etape3_erreur_equipe_incomplete.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_pro_impossible_2', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_am_etape3_erreur_nb_joueurs_depasse.'</div>'; } 
						?>
						<br clear="all">
						<div class="separateur_ter"></div>
						<?=$txt_facture_message_heures?><br>
						<textarea name="facture_message_heures" style="width: 645px; height: 100px; margin-top: 5px; resize: vertical;"><?=$facture_message_heures?></textarea>
						<br clear="all">
						<br>
						<?=$txt_am_etape6_laisser_message_facturation?><br>
						<textarea name="facture_message_joueur" style="width: 645px; height: 100px; margin-top: 5px; resize: vertical;"><?=$facture_message_joueur?></textarea>
						<div style="float: left; width: 120px; margin: 40px 0px 20px 0px;"><input type="button" value="<?=$txt_bouton_retour?>" onclick="window.location='./inscription_hebergement.php';" class="bouton_annuler"></div>
						<div align="right" style="margin: 40px 71px 20px 0px;"><input type="submit" value="<?=$txt_bouton_je_valide_inscription?>"></div><br clear="all">

					</form>
					<div class="separateur_ter"></div>
					<div id="texte">
						<div id="calque_package_golfeur_infos">
							<?=$text_package_?>

							<?php echo $text_package_0.number_format($prix_forfait, 2).$text_package_1.number_format($no_heb_pro_no_hotel, 2).$text_package_2.number_format($no_heb_pro_hotel, 2).$text_package_3; ?>

							<div class="separateur_ter"></div>
						</div>
						<?php if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0){ ?>
							<h2><?=$txt_package_accompagnateur_nom?></h2><br>
							<?=$txt_package_accompagnateur_texte?>
							<div class="separateur_ter"></div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</body>
</html>


<script type="text/javascript">

	function number_format (number, decimals, dec_point, thousands_sep) {
	    // Strip all characters but numerical ones.
	    number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
	    var n = !isFinite(+number) ? 0 : +number,
	        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
	        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
	        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
	        s = '',
	        toFixedFix = function (n, prec) {
	            var k = Math.pow(10, prec);
	            return '' + Math.round(n * k) / k;
	        };
	    // Fix for IE parseFloat(0.55).toFixed(0) = 0;
	    s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
	    if (s[0].length > 3) {
	        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
	    }
	    if ((s[1] || '').length < prec) {
	        s[1] = s[1] || '';
	        s[1] += new Array(prec - s[1].length + 1).join('0');
	    }
	    return s.join(dec);
	}
	
	$( document ).ready(function() {
		$("#langue > a").click(function(e){
			var lang = $(this).attr("href").replace('?', '');
			//alert("ki");
			e.preventDefault();
			if(window.location.href.indexOf("langue") > 0) {
				window.location = window.location.href.replace(/langue=[ef][nr]/, lang);
			} else {
				window.location = window.location.href + "&" + lang;
			}
		});
	    $("#joueur_package_golfeur").prop("checked", true);
		var val = $('input[name="no_heb_pro_hotel"]').val();
		var val2 = $('input[name="no_heb_pro_no_hotel"]').val();
		if( val !== undefined ) {
		    $('input[name="facture_golfeur_prix_total_ttc"]').val(val);
		    $("input[name='facture_golfeur_prix_total_ht']").val(val);
		}

		

		if(document.location.href.indexOf("prologe") > 0) {
			alert("param");
			let searchParams = new URLSearchParams(window.location.search);
			let param = searchParams.get('prologe');
			//alert(param);
			if(param=='yes')
				$( "#pro_hotel_yes" ).prop("checked", true);
			else
				$( "#pro_hotel_no" ).prop("checked", true);
		}

	    $( "[name='pro_hotel']" ).change(function() {


	    	if (this.value=="no") {

				

				$('input[name="facture_prix_forfait"]').val(val2);

	    		$('input[name="facture_golfeur_prix_total_ttc"]').val(val2);
	    		$('input[name="facture_golfeur_prix_total_ht"]').val(val2);
	    		$('input[name="facture_prix_golfeur_membre_ht"]').val(val2);
	    		$('input[name="facture_prix_golfeur_membre_ttc"]').val(val2);
	    		$('input[name="facture_prix_golfeur_pasmembre_ht"]').val(val2);
	    		$('input[name="facture_prix_golfeur_pasmembre_ttc"]').val(val2);
	    		$('.change_js_').html(number_format(val2, 2, '.', ',')+" € &nbsp;&nbsp;");
	    		$('.change_js_bis').text($('input[name="desc_forfait_amateur_prononloge"]').val());
	    	
	    	} else {
				
				$('input[name="facture_prix_forfait"]').val(val);

	    		var val = $('input[name="no_heb_pro_hotel"]').val();
	    		$('input[name="facture_golfeur_prix_total_ttc"]').val(val);
	    		$('input[name="facture_golfeur_prix_total_ht"]').val(val);
	    		$('input[name="facture_prix_golfeur_membre_ht"]').val(val);
	    		$('input[name="facture_prix_golfeur_membre_ttc"]').val(val);
	    		$('input[name="facture_prix_golfeur_pasmembre_ht"]').val(val);
	    		$('input[name="facture_prix_golfeur_pasmembre_ttc"]').val(val);
	    		$('.change_js_').html(number_format(val, 2, '.', ',')+" € &nbsp;&nbsp;");
	    		$('.change_js_bis').text($('input[name="desc_forfait_amateur_prologe"]').val());
	    	}

	    });

	});
</script>