<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(6, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_date_debut, competition_date_fin, competition_golfs, competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4 FROM competitions WHERE competition_active=1 AND competition_archive = 0 ORDER BY competition_annee DESC LIMIT 1');
$nb_competitions = mysqli_num_rows($requete_competition);
if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_date_debut = $resultat_competition[0];
	$competition_date_fin = $resultat_competition[1];
	$competition_golfs = explode(',', $resultat_competition[2]);
	$competition_sponsor[0] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[3])));
	$competition_sponsor[1] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[4])));
	$competition_sponsor[2] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[5])));
	$competition_sponsor[3] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[6])));
}


if(isset($action) AND $action=='rechercher'){

	$requete_where = 'WHERE planning_id<>""';
	$export_parametres = '';

	if(isset($critere_dates) AND count($critere_dates)!=0){
		$requete_where .= ' AND (';
		foreach($critere_dates as $critere_date){
			$requete_where .= 'planning_depart_date="'.$critere_date.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
		$export_parametres .= 'export_dates='.implode('|', $critere_dates).'&';
	}

	if(isset($critere_golfs) AND count($critere_golfs)!=0){
		$requete_where .= ' AND (';
		foreach($critere_golfs as $critere_golf){
			$requete_where .= 'A.golf_id="'.$critere_golf.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
		$export_parametres .= 'export_golfs='.implode('|', $critere_golfs).'&';
	}

	if(isset($critere_groupes) AND count($critere_groupes)!=0){
		$requete_where .= ' AND (';
		foreach($critere_groupes as $critere_groupe){
			$requete_where .= 'planning_groupe="'.$critere_groupe.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
		$export_parametres .= 'export_groupes='.implode('|', $critere_groupes).'&';
	}

	if($recherche_equipe!='0'){
		$requete_where .= ' AND A.equipe_id="'.$recherche_equipe.'"';
		$export_parametres .= 'export_equipe='.$recherche_equipe.'&';
	}

	if($classement=='groupe'){
		$requete_orderby = 'planning_groupe '.$ordre.', planning_depart_date, planning_depart_heure, equipe_nom';
	}elseif($classement=='equipe'){
		$requete_orderby = 'equipe_nom '.$ordre.', planning_depart_date, planning_depart_heure';
	}elseif($classement=='golf'){
		$requete_orderby = 'golf_nom '.$ordre.', planning_depart_date, planning_depart_heure';
	}elseif($classement=='date'){
		$requete_orderby = 'planning_depart_date '.$ordre.', planning_depart_heure, planning_groupe, equipe_nom';
	}elseif($classement=='statut'){
		$requete_orderby = 'planning_depart_heure '.$ordre.', planning_depart_date, planning_groupe, equipe_nom';
	}

	$export_parametres .= 'classement='.$classement.'&ordre='.$ordre.'&';

	if(strlen(trim($export_parametres))!=0){
		$export_parametres = '?'.substr($export_parametres, 0, -1);
	}

}else{

	$requete_where = 'WHERE planning_id<>""';
	$requete_orderby = 'planning_depart_date, planning_depart_heure, planning_groupe, equipe_nom';

	$export_parametres = '?classement=date&ordre=ASC';

}


// Initialisation des tableaux
$tab_roadbook[1] = $tab_roadbook[2] = $tab_roadbook[3] = $tab_roadbook[4] = $tab_roadbook_par = $tab_golf_hcp_coups_recus[1] = $tab_golf_hcp_coups_recus[2] = $tab_golf_hcp_coups_recus[3] = $tab_golf_hcp_coups_recus[4] = array();

// Sélection du roadbook
$requete_roadbook = mysqli_query($connexion_mysql, 'SELECT roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge FROM golfs_roadbook ORDER BY roadbook_golf, roadbook_trou');
$nb_roadbook = mysqli_num_rows($requete_roadbook);
if($nb_roadbook!=0){
	for($roadbook_boucle=0; $roadbook_boucle<$nb_roadbook; $roadbook_boucle++){
		$resultat_roadbook = mysqli_fetch_array($requete_roadbook);
		$roadbook_golf = $resultat_roadbook[0];
		$roadbook_trou = $resultat_roadbook[1];
		$roadbook_par = $resultat_roadbook[2];
		$roadbook_hcp = $resultat_roadbook[3];
		$roadbook_blanche = $resultat_roadbook[4];
		$roadbook_jaune = $resultat_roadbook[5];
		$roadbook_rouge = $resultat_roadbook[6];

		array_push($tab_golf_hcp_coups_recus[$roadbook_golf], $roadbook_hcp);

		array_push($tab_roadbook[$roadbook_golf], array($roadbook_trou, $roadbook_par, $roadbook_hcp, $roadbook_blanche, $roadbook_jaune, $roadbook_rouge));
	}

	for($num_golf=0; $num_golf<=3; $num_golf++){

		$golf_numero = $num_golf + 1;

		// Cacul de la somme des PAR pour le parcours aller
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou<=9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_aller = $resultat_roadbook_par[0];

		// Cacul de la somme des PAR pour le parcours retour
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou>9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_retour = $resultat_roadbook_par[0];

		// Cacul du total des PAR (aller + retour)
		$roadbook_golf_par_total = $roadbook_golf_par_aller + $roadbook_golf_par_retour;

		array_push($tab_roadbook_par, array($golf_numero, $roadbook_golf_par_retour, $roadbook_golf_par_aller, $roadbook_golf_par_total));

	}

}


// Sélection des départs
$requete_planning = mysqli_query($connexion_mysql, 'SELECT planning_id, planning_groupe, A.equipe_id, equipe_nom, A.golf_id, golf_nom, DATE_FORMAT(planning_depart_date, "%d/%m/%Y"), DATE_FORMAT(planning_depart_heure, "%kh%i") FROM (planning A INNER JOIN golfs B ON A.golf_id = B.golf_id) INNER JOIN equipes C ON A.equipe_id = C.equipe_id '.$requete_where.' ORDER BY '.$requete_orderby);


$nb_planning = mysqli_num_rows($requete_planning);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<link rel="stylesheet" type="text/css" href="<?=$general_path_relatif?>css/cartes_score.css">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<script language="Javascript">
	<!-- 
	function supprimer(identifiant, profil, nom){
		resultat = confirm("Désirez-vous réellement supprimer le joueur ' " + nom + " ' ?");
		if(resultat == true){
			window.location = './supprimer.php?joueur_id=' + identifiant + '&joueur_profil=' + profil;
		}
	}
	//-->
</script>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1235px;">

	<div id="contenu_3" align="left" style="width: 935px;">

		<div id="titres">
			<span class="titre_1" style="width: 791px;">Cartes de score</span>
			<?php if(isset($action)){ ?><span class="ajouter" style="width: 130px;"><a href="./exporter.php<?=$export_parametres?>" target="_blank">Exporter (PDF)</a></span><?php } ?>
		</div>
		<br clear="all">

		<?php if(!isset($action)){ ?>

			<div id="bloc" style="height: 640px;">
				effectuez une recherche via le moteur de recherche situé à droite pour afficher les cartes de score.
			</div>

		<?php }else{ ?>

			<?php 
			if($nb_planning==1){
				echo '<div id="ligne_compteur"><b>1</b> carte de score sélectionnée</div>';
			}elseif($nb_planning>1){
				echo '<div id="ligne_compteur"><b>'.$nb_planning.'</b> cartes de score sélectionnées</div>';
			}
			?>

			<div id="bloc">

				<?php 
				if($nb_planning!=0){
					for($planning_boucle=0; $planning_boucle<$nb_planning; $planning_boucle++){
						$resultat_planning = mysqli_fetch_array($requete_planning);
						$planning_id = $resultat_planning[0];
						$planning_groupe = $resultat_planning[1];
						$planning_equipe = $resultat_planning[2];
						$planning_equipe_nom = $resultat_planning[3];
						$planning_golf_id = $resultat_planning[4];
						$planning_golf_nom = strtoupper_max($resultat_planning[5]);
						$planning_depart_date = $resultat_planning[6];
						$planning_depart_heure = $resultat_planning[7];


						// BUG : $requete_carte = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_pro_reference, score_joueur_pro_abandon, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total FROM scores WHERE competition_id="'.$competition_id.'" AND planning_id='.$planning_id);

						// Sélection de la carte de score
						$requete_carte = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_pro_reference, score_joueur_pro_abandon, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total FROM scores WHERE planning_id='.$planning_id);
						$nb_carte = mysqli_num_rows($requete_carte);
						if($nb_carte!=0){

							$resultat_carte = mysqli_fetch_array($requete_carte);
							$score_joueur_pro_id = $resultat_carte[0];
							$score_joueur_pro_resultats = explode(',', $resultat_carte[1]);
							$score_aller = $resultat_carte[2];
							$score_retour = $resultat_carte[3];
							$score_total = $resultat_carte[4];
							$score_joueur_pro_reference = $resultat_carte[5];
							$score_joueur_pro_abandon = $resultat_carte[6];
							$score_joueur_am1_id = $resultat_carte[7];
							$score_joueur_am1_resultats = explode(',', $resultat_carte[8]);
							$score_joueur_am1_coupsrecus = explode(',', $resultat_carte[9]);
							$score_joueur_am2_id = $resultat_carte[10];
							$score_joueur_am2_resultats = explode(',', $resultat_carte[11]);
							$score_joueur_am2_coupsrecus = explode(',', $resultat_carte[12]);
							$score_joueur_am3_id = $resultat_carte[13];
							$score_joueur_am3_resultats = explode(',', $resultat_carte[14]);
							$score_joueur_am3_coupsrecus = explode(',', $resultat_carte[15]);
							$resultat_brut = explode(',', $resultat_carte[16]);
							$resultat_net = explode(',', $resultat_carte[17]);
							$resultat_brut_retour = $resultat_carte[18];
							$resultat_brut_aller = $resultat_carte[19];
							$resultat_brut_total = $resultat_carte[20];
							$resultat_net_retour = $resultat_carte[21];
							$resultat_net_aller = $resultat_carte[22];
							$resultat_net_total = $resultat_carte[23];

							$score = array($score_joueur_pro_id=>$score_joueur_pro_resultats, $score_joueur_am1_id=>$score_joueur_am1_resultats, $score_joueur_am2_id=>$score_joueur_am2_resultats, $score_joueur_am3_id=>$score_joueur_am3_resultats);

						}else{

							// Suppression des variables pour les résultats
							unset($score);
							unset($score_aller);
							unset($score_retour);
							unset($score_total);
							unset($resultat_brut);
							unset($resultat_net);
							unset($resultat_brut_retour);
							unset($resultat_brut_aller);
							unset($resultat_brut_total);
							unset($resultat_net_retour);
							unset($resultat_net_aller);
							unset($resultat_net_total);

						}

						if($planning_boucle!=0){
							echo '<br>';
						}
				?>

						<div id="formulaire_ligne_intertitre" style="width: 890px; font-size: 14px; color: #9C9A8C;">GROUPE&nbsp; <b><?=$planning_groupe?></b> &nbsp;&nbsp;-&nbsp;&nbsp; &Eacute;QUIPE&nbsp; <b><?=$planning_equipe_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; GOLF DE&nbsp; <b><?=$planning_golf_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; <?=$planning_depart_date?> &nbsp;&agrave;&nbsp; <?=$planning_depart_heure?></div>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne">Trou</td>
								<td class="carte_entete">1</td>
								<td class="carte_entete">2</td>
								<td class="carte_entete">3</td>
								<td class="carte_entete">4</td>
								<td class="carte_entete">5</td>
								<td class="carte_entete">6</td>
								<td class="carte_entete">7</td>
								<td class="carte_entete">8</td>
								<td class="carte_entete">9</td>
								<td class="carte_entete">10</td>
								<td class="carte_entete">11</td>
								<td class="carte_entete">12</td>
								<td class="carte_entete">13</td>
								<td class="carte_entete">14</td>
								<td class="carte_entete">15</td>
								<td class="carte_entete">16</td>
								<td class="carte_entete">17</td>
								<td class="carte_entete">18</td>
								<td class="carte_fin_ligne">Retour</td>
								<td class="carte_fin_ligne">Aller</td>
								<td class="carte_fin_ligne">Total</td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Par</td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne" style="font-weight: bold;"><?=$tab_trou[1]?></td>
								<?php } ?>
								<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][1]?></td>
								<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][2]?></td>
								<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][3]?></td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Handicap</td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne"><?=$tab_trou[2]?></td>
								<?php } ?>
							</tr>
						</table>

						<table border="0" id="carte_score">
							<?php 
							// Sélection des joueurs de l'équipe sélectionnée
							$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$planning_equipe.'") AND joueur_actif="1" AND joueur_profil<>"acc" ORDER BY joueur_profil DESC, joueur_handicap, joueur_nom, joueur_prenom');
							$nb_joueurs = mysqli_num_rows($requete_joueurs);
							if($nb_joueurs!=0){
								for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
									$resultat_joueur = mysqli_fetch_array($requete_joueurs);
									$joueur_id = $resultat_joueur[0];
									$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
									$joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2]))), 0, 1).'.';
									$joueur_profil = $resultat_joueur[3];
									$joueur_handicap = number_format($resultat_joueur[4], 1, '.', '');

									if(strlen($joueur_nom)>16){ $joueur_nom = substr($joueur_nom, 0, 15).'.'; }

									/**************************************************************/
									/***  Calcul et attribution des coups reçus pour le joueur  ***/
									/**************************************************************/
									$tab_joueur_coups_recus = array();
									$joueur_coups_recus = round(($joueur_handicap/4)*3);
									foreach($tab_golf_hcp_coups_recus[$planning_golf_id] as $tab_golf_hcp){
										if($tab_golf_hcp<=$joueur_coups_recus){
											array_push($tab_joueur_coups_recus, 1);
										}else{
											array_push($tab_joueur_coups_recus, 0);
										}
									}

									if(substr($joueur_handicap, -2)=='.0'){ $joueur_handicap_libelle = substr($joueur_handicap, 0, -2); }else{ $joueur_handicap_libelle = $joueur_handicap; }
									if($joueur_profil=='am'){ $joueur_handicap_libelle = '<br><span style="font-weight: normal;">('.$joueur_handicap_libelle.')</span>'; }else{ $joueur_handicap_libelle = ''; }
							?>
									<tr>
										<td class="carte_entete_ligne" style="font-size: 10px;"><?=$joueur_nom.' '.$joueur_prenom.$joueur_handicap_libelle?></td>
										<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
											<td class="carte_ligne_resultat"><?php if(isset($score[$joueur_id][$boucle_trou])){ echo $score[$joueur_id][$boucle_trou]; } ?></td>
										<?php } ?>
										<?php if($joueur_profil!='am'){ ?>
											<td class="carte_fin_ligne_resultat"><?php if(isset($score_retour)){ echo $score_retour; }else{ echo '&nbsp;'; } ?></td>
											<td class="carte_fin_ligne_resultat"><?php if(isset($score_aller)){ echo $score_aller; }else{ echo '&nbsp;'; } ?></td>
											<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><?php if($score_joueur_pro_abandon==1){ echo '<span style="font-weight: normal; color: #FF5500; font-size: 16px;">ABD'; }elseif(isset($score_total)){ echo $score_total; }else{ echo '&nbsp;'; } ?></td>
										<?php }elseif($joueur_boucle==1){ ?>
											<td colspan="3" rowspan="2" valign="top" style="padding-top: 10px; color: #999999;">score pro de réf : <?=$score_joueur_pro_reference?></td>
										<?php }else{ ?>
											<td colspan="3" rowspan="2">&nbsp;</td>
										<?php } ?>
									</tr>
									<?php if($joueur_profil=='am'){ ?>
										<tr>
											<td class="carte_ligne_coups_recus">coups reçus</td>
											<?php 
											foreach($tab_joueur_coups_recus as $tab_joueur_coup_recu){
												echo '<td class="carte_ligne_petit" style="height: 15px;">'.$tab_joueur_coup_recu.'</td>'."\n";
											}
											?>
										</tr>
							<?php
									} 
								}
							}
							?>
						</table>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne">Brut</td>
								<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
									<td class="carte_ligne_resultat"><?php if(isset($resultat_brut[$boucle_trou])){ echo $resultat_brut[$boucle_trou]; }else{ echo '&nbsp;'; } ?></td>
								<?php } ?>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_brut_retour)){ echo $resultat_brut_retour; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_brut_aller)){ echo $resultat_brut_aller; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><?php if(isset($resultat_brut_total)){ echo $resultat_brut_total; }else{ echo '&nbsp;'; } ?></td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Net</td>
								<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
									<td class="carte_ligne_resultat"><?php if(isset($resultat_net[$boucle_trou])){ echo $resultat_net[$boucle_trou]; } ?></td>
								<?php } ?>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_net_retour)){ echo $resultat_net_retour; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_net_aller)){ echo $resultat_net_aller; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><?php if(isset($resultat_net_total)){ echo $resultat_net_total; }else{ echo '&nbsp;'; } ?></td>
							</tr>
						</table>

						<div style="float: left; width: 740px;">
							<table border="0" id="carte_score">
								<tr>
									<td class="carte_entete_ligne">Blanches</td>
									<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
										<td class="carte_ligne_petit"><?=$tab_trou[3]?></td>
									<?php } ?>
								</tr>
								<tr>
									<td class="carte_entete_ligne">Jaunes</td>
									<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
										<td class="carte_ligne_petit"><?=$tab_trou[4]?></td>
									<?php } ?>
								</tr>
								<tr>
									<td class="carte_entete_ligne">Rouges</td>
									<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
										<td class="carte_ligne_petit"><?=$tab_trou[5]?></td>
									<?php } ?>
								</tr>
							</table>
						</div>
						<div style="float: left; width: 150px;" align="right">
							<span class="bouton" style="margin: 8px 0px 10px 0px;"><a href="./modifier.php?planning_id=<?=$planning_id?>">Modifier</a></span>
							<span class="bouton"><a href="./exporter.php?planning_id=<?=$planning_id?>" target="_blank">Exporter</a></span>
						</div>
						<br clear="all">

				<?php 
					}

				}else{
					if(isset($action) AND $action=='rechercher'){
						echo '<div>aucune carte de score correspond à votre recherche</div>'."\n";
					}else{
						echo '<div>aucune carte de score sélectionnée</div>'."\n";
					}
				}
				?>

			</div>

		<?php } ?>

	</div>

	<div id="contenu_secondaire">

		<form action="<?=$PHP_SELF?>" method="post">

			<input type="hidden" name="action" value="rechercher">

			<div class="titre">afficher une date</div>

			<?php 
			if(isset($competition_date_debut)){
				$tab_competition_date_debut = explode('-', $competition_date_debut);
				$tab_competition_date_debut_annee = $tab_competition_date_debut[0];
				$tab_competition_date_debut_mois = $tab_competition_date_debut[1];
				$tab_competition_date_debut_jour = $tab_competition_date_debut[2];
				for($bdate=0; $bdate<=3; $bdate++){

					$competition_date = date('Y-m-d', mktime(0, 0, 0, $tab_competition_date_debut_mois, $tab_competition_date_debut_jour+$bdate, $tab_competition_date_debut_annee));
					$competition_date_libelle = date('d/m/Y', mktime(0, 0, 0, $tab_competition_date_debut_mois, $tab_competition_date_debut_jour+$bdate, $tab_competition_date_debut_annee));

					if(isset($critere_dates) AND in_array($competition_date, $critere_dates)==true){ $competition_date_checked = ' checked'; }else{ $competition_date_checked = ''; }

					echo '<input type="checkbox" id="affichage_date_'.$bdate.'" name="critere_dates[]" value="'.$competition_date.'"'.$competition_date_checked.'> <label for="affichage_date_'.$bdate.'">'.$competition_date_libelle.'</label><br>'."\n";
					if($bdate!=3){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}
			}else{
				echo 'aucune date';
			}
			?>

			<div class="titre">afficher un golf</div>

			<?php 
			if(isset($competition_golfs)){
				foreach($competition_golfs as $competition_golf_cle=>$competition_golf){

					// Sélection du golf
					$requete_competition_golf = mysqli_query($connexion_mysql, 'SELECT golf_nom FROM golfs WHERE golf_id="'.$competition_golf.'"');
					$resultat_competition_golf = mysqli_fetch_array($requete_competition_golf);
					$competition_golf_nom = $resultat_competition_golf[0];

					if(isset($critere_golfs) AND in_array($competition_golf, $critere_golfs)==true){ $competition_golf_checked = ' checked'; }else{ $competition_golf_checked = ''; }

					echo '<input type="checkbox" id="affichage_golf_'.$competition_golf_cle.'" name="critere_golfs[]" value="'.$competition_golf.'"'.$competition_golf_checked.'> <label for="affichage_golf_'.$competition_golf_cle.'">'.$competition_golf_nom.'</label><br>'."\n";
					if($competition_golf_cle!=3){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}
			}else{
				echo 'aucun golf';
			}
			?>

			<div class="titre">afficher un groupe</div>

			<?php 
			$requete_groupes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_groupe) FROM planning ORDER BY planning_groupe');
			$nb_groupes = mysqli_num_rows($requete_groupes);
			if($nb_groupes!=0){
				for($groupe_boucle=0; $groupe_boucle<$nb_groupes; $groupe_boucle++){
					$resultat_groupe = mysqli_fetch_array($requete_groupes);
					$competition_groupe = $resultat_groupe[0];

					if(isset($critere_groupes) AND in_array($competition_groupe, $critere_groupes)==true){ $competition_groupe_checked = ' checked'; }else{ $competition_groupe_checked = ''; }

					echo '<input type="checkbox" id="affichage_groupe_'.$competition_groupe.'" name="critere_groupes[]" value="'.$competition_groupe.'"'.$competition_groupe_checked.'> <label for="affichage_groupe_'.$competition_groupe.'">Groupe '.$competition_groupe.'</label><br>'."\n";
					if($groupe_boucle!=($nb_groupes-1)){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}
			}else{
				echo 'aucun groupe';
			}
			?>

			<div class="titre">afficher une équipe</div>

			<select name="recherche_equipe" size="1" class="select" style="width: 170px;">
				<option value="0">-</option>
				<?php 
				// Sélection des équipes enregistrées
				$requete_recherche_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes ORDER BY equipe_nom');
				$nb_recherche_equipes = mysqli_num_rows($requete_recherche_equipes);
				if($nb_recherche_equipes!=0){
					for($equipe_recherche_boucle=0; $equipe_recherche_boucle<$nb_recherche_equipes; $equipe_recherche_boucle++){
						$resultat_recherche_equipe = mysqli_fetch_array($requete_recherche_equipes);
						$recherche_equipe_id = $resultat_recherche_equipe[0];
						$recherche_equipe_nom = $resultat_recherche_equipe[1];

						if($recherche_equipe_id==$recherche_equipe){ $recherche_equipe_selection = ' selected'; }else{ $recherche_equipe_selection = ''; }

						echo '<option value="'.$recherche_equipe_id.'"'.$recherche_equipe_selection.'>'.$recherche_equipe_nom.'</option>'."\n";
					}
				}
				?>
			</select>

			<div class="titre">classer les résultats</div>

			<input type="radio" id="classement_date" name="classement" value="date" <?php if((isset($classement) AND $classement=='date') OR !isset($classement)){ echo 'checked'; } ?>> <label for="classement_date">par date</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_heure" name="classement" value="heure" <?php if(isset($classement) AND $classement=='heure'){ echo 'checked'; } ?>> <label for="classement_heure">par heure</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_groupe" name="classement" value="groupe" <?php if(isset($classement) AND $classement=='groupe'){ echo 'checked'; } ?>> <label for="classement_groupe">par groupe</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_equipe" name="classement" value="equipe" <?php if(isset($classement) AND $classement=='equipe'){ echo 'checked'; } ?>> <label for="classement_profil">par équipe</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_golf" name="classement" value="golf" <?php if(isset($classement) AND $classement=='golf'){ echo 'checked'; } ?>> <label for="classement_golf">par golf</label><br>


			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 10px 0px;"><br>

			<input type="radio" id="classement_ordre_croissant" name="ordre" value="ASC" <?php if((isset($ordre) AND $ordre=='ASC') OR !isset($ordre)){ echo 'checked'; } ?>> <label for="classement_ordre_croissant">ordre croissant</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_ordre_decroissant" name="ordre" value="DESC" <?php if(isset($ordre) AND $ordre=='DESC'){ echo 'checked'; } ?>> <label for="classement_ordre_decroissant">ordre décroissant</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 20px 0px;"><br>

			<center><input type="submit" value="valider" style="width: 100px;"></center>

		</form>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
