<?php 
include '../lib/configuration.inc';


// Si le profil du joueur n'est pas connu, alors retour à l'inscription
if(!isset($_SESSION['SessionWeb_joueur_profil'])){
	header('Location: ./inscription_1.php');
	exit;
}


if(isset($autorisation) AND $autorisation=='inscription'){

	if(strlen(trim($joueur_sexe))==0){
		$formulaire_erreur[] = 'joueur_sexe';
	}
	if(strlen(trim($joueur_nom))==0){
		$formulaire_erreur[] = 'joueur_nom';
	}
	if(strlen(trim($joueur_prenom))==0){
		$formulaire_erreur[] = 'joueur_prenom';
	}

	if(count($formulaire_erreur)==0){

		// Traitement des informations pour enregistrement en base de données
		$joueur_nom = htmlentities(strtoupper_max(stripslashes($joueur_nom)), ENT_QUOTES);
		$joueur_prenom = htmlentities(ucfirst(strtolower_max(stripslashes($joueur_prenom))), ENT_QUOTES);

		if(!isset($jacc)){ $jacc = 0; }

		// Enregistrement en session du joueur
		$_SESSION['SessionWeb_joueurs_acc'][$jacc]['sexe'] = $joueur_sexe;
		$_SESSION['SessionWeb_joueurs_acc'][$jacc]['nom'] = $joueur_nom;
		$_SESSION['SessionWeb_joueurs_acc'][$jacc]['prenom'] = $joueur_prenom;

		header('Location: ./inscription_3_'.$_SESSION['SessionWeb_joueur_profil'].'.php');		// Redirection vers la 3e page d'inscription (composition de l'équipe)
		exit;

	}else{
		// Traitement d'affichage en cas d'erreur dans le formulaire
		$joueur_nom = stripslashes($joueur_nom);
		$joueur_prenom = stripslashes($joueur_prenom);
	}

}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='inscription')){

	if(isset($jacc) AND isset($_SESSION['SessionWeb_joueurs_acc'][$jacc]['nom']) AND strlen(trim($_SESSION['SessionWeb_joueurs_acc'][$jacc]['nom']))!=0){

		$joueur_sexe = $_SESSION['SessionWeb_joueurs_acc'][$jacc]['sexe'];
		$joueur_nom = $_SESSION['SessionWeb_joueurs_acc'][$jacc]['nom'];
		$joueur_prenom = $_SESSION['SessionWeb_joueurs_acc'][$jacc]['prenom'];

	}else{

		// Valeurs par défaut lorsque le formulaire est vierge
		if(!isset($jacc)){ $jacc = 0; }
		$joueur_sexe = '';
		$joueur_nom = '';
		$joueur_prenom = '';

	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_page_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php include './commun/entete.inc'; ?>

		<div id="formulaire">

			<form action="<?=$REQUEST_URI?>" method="post">

				<input type="hidden" name="autorisation" value="inscription">
				<input type="hidden" name="jacc" value="<?=$jacc?>">

				<h1><?=$txt_acc_etape5_titre?></h1>

				<div class="separateur"></div>

				<div class="colonne_gauche_obligatoire" style="height: 33px; padding-top: 0px;"><?=$txt_acc_etape5_champ_sexe?></div>
				<div class="colonne_droite" style="height: 33px;">
					<input type="radio" id="joueur_sexe_homme" name="joueur_sexe" value="H"<?php if($joueur_sexe=='H'){ echo ' checked'; } ?>> <label for="joueur_sexe_homme"><?=$txt_acc_etape5_champ_sexe_homme?></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
					<input type="radio" id="joueur_sexe_femme" name="joueur_sexe" value="F"<?php if($joueur_sexe=='F'){ echo ' checked'; } ?>> <label for="joueur_sexe_femme"><?=$txt_acc_etape5_champ_sexe_femme?></label>
				</div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_sexe', $formulaire_erreur)==true){ echo '<div class="erreur" style="margin-top: 0px;">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_acc_etape5_champ_nom?></div>
				<div class="colonne_droite"><input type="text" name="joueur_nom" value="<?=$joueur_nom?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_nom', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_acc_etape5_champ_prenom?></div>
				<div class="colonne_droite"><input type="text" name="joueur_prenom" value="<?=$joueur_prenom?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_prenom', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="separateur"></div>

				<?php if($_SESSION['SessionWeb_joueur_profil']=='acc'){ ?>
					<?php if($jacc==0){ ?>
						<div style="float: left; width: 150px;"><input type="button" value="<?=$txt_bouton_retour?>" onclick="window.location='./inscription_annulation.php';" class="bouton_annuler"></div>
					<?php }else{ ?>
						<div style="float: left; width: 150px;"><input type="button" value="<?=$txt_bouton_retour?>" onclick="window.location='./inscription_3_acc.php';" class="bouton_annuler"></div>
					<?php } ?>
					<div align="right" style="margin-right: 130px;"><input type="submit" value="<?=$txt_bouton_etape_suivante?>"></div>
				<?php }else{ ?>
					<div style="float: left; width: 150px;"><input type="button" value="<?=$txt_bouton_retour?>" onclick="window.location='./inscription_3_<?=$_SESSION['SessionWeb_joueur_profil']?>.php';" class="bouton_annuler"></div>
					<div align="right" style="margin-right: 130px;"><input type="submit" value="<?=$txt_bouton_valider_retourner_equipe?>"></div>
				<?php }e ?>

			</form>

			<br><br><br>
			<?=$txt_champs_obligatoires_vert?><br>

		</div>

	</div>

</div>

</body>
</html>
