<?php 
require_once '../../../../lib/configuration.inc';
require '../../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(6, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


define('ESPACE', chr(32));		// Remplace le caractère Espace (&nbsp;)


// Sélection de la compétition
$requete_competition = mysql_query('SELECT competition_date_debut, competition_date_fin, competition_golfs, competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4 FROM competitions WHERE competition_active="1"');
$resultat_competition = mysql_fetch_array($requete_competition);
$competition_date_debut = $resultat_competition[0];
$competition_date_fin = $resultat_competition[1];
$competition_golfs = explode(',', $resultat_competition[2]);
$competition_sponsor[0] = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[3]))));
$competition_sponsor[1] = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[4]))));
$competition_sponsor[2] = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[5]))));
$competition_sponsor[3] = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[6]))));


$tab_competition_date_debut = explode('-', $competition_date_debut);
$competition_date_debut_annee = $tab_competition_date_debut[0];
$competition_date_debut_mois = $tab_competition_date_debut[1];
$competition_date_debut_jour = $tab_competition_date_debut[2];

$competition_date_jour2 = date('Y-m-d', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+1, $competition_date_debut_annee));
$competition_date_jour3 = date('Y-m-d', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+2, $competition_date_debut_annee));
$competition_date_jour4 = date('Y-m-d', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+3, $competition_date_debut_annee));



/********************************/
/**  CRITERES DE LA SELECTION  **/
/********************************/

if(isset($export_dates)){ $critere_dates = explode(',', $export_dates); }
if(isset($export_golfs)){ $critere_golfs = explode(',', $export_golfs); }
if(isset($export_groupes)){ $critere_groupes = explode(',', $export_groupes); }

if(isset($critere_dates) AND count($critere_dates)!=0){
	$requete_where .= ' AND (';
	foreach($critere_dates as $critere_date){
		$requete_where .= 'planning_depart_date="'.$critere_date.'" OR ';
	}
	$requete_where = substr($requete_where, 0, -4).')';
}

if(isset($critere_golfs) AND count($critere_golfs)!=0){
	$requete_where .= ' AND (';
	foreach($critere_golfs as $critere_golf){
		$requete_where .= 'A.golf_id="'.$critere_golf.'" OR ';
	}
	$requete_where = substr($requete_where, 0, -4).')';
}

if(isset($critere_groupes) AND count($critere_groupes)!=0){
	$requete_where .= ' AND (';
	foreach($critere_groupes as $critere_groupe){
		$requete_where .= 'planning_groupe="'.$critere_groupe.'" OR ';
	}
	$requete_where = substr($requete_where, 0, -4).')';
}

if(isset($export_equipe) AND $export_equipe!='0'){
	$requete_where .= ' AND A.equipe_id="'.$export_equipe.'"';
}

if(isset($planning_id) AND $planning_id!='0'){
	$requete_where .= ' AND planning_id='.$planning_id.'';
}


if(isset($classement) AND $classement=='groupe'){
	$requete_orderby = 'planning_groupe '.$ordre.', planning_depart_date, planning_depart_heure, equipe_nom';
}elseif(isset($classement) AND $classement=='equipe'){
	$requete_orderby = 'equipe_nom '.$ordre.', planning_depart_date, planning_depart_heure';
}elseif(isset($classement) AND $classement=='golf'){
	$requete_orderby = 'golf_nom '.$ordre.', planning_depart_date, planning_depart_heure';
}elseif(isset($classement) AND $classement=='date'){
	$requete_orderby = 'planning_depart_date '.$ordre.', planning_depart_heure, planning_groupe, equipe_nom';
}elseif(isset($classement) AND $classement=='statut'){
	$requete_orderby = 'planning_depart_heure '.$ordre.', planning_depart_date, planning_groupe, equipe_nom';
}else{
	$requete_orderby = 'planning_depart_date, planning_depart_heure';
}


// Sélection des départs
$requete_planning = mysql_query('SELECT planning_id, planning_groupe, A.equipe_id, equipe_nom, A.golf_id, golf_nom, planning_depart_date, DATE_FORMAT(planning_depart_date, "%d/%m/%Y"), DATE_FORMAT(planning_depart_heure, "%k H %i") FROM (planning A INNER JOIN golfs B ON A.golf_id=B.golf_id) INNER JOIN equipes C ON A.equipe_id=C.equipe_id '.$requete_where.' ORDER BY '.$requete_orderby);
$nb_planning = mysql_num_rows($requete_planning);


// Initialisation des tableaux
$tab_roadbook[1] = $tab_roadbook[2] = $tab_roadbook[3] = $tab_roadbook[4] = $tab_roadbook_par = $tab_golf_hcp_coups_recus[1] = $tab_golf_hcp_coups_recus[2] = $tab_golf_hcp_coups_recus[3] = $tab_golf_hcp_coups_recus[4] = array();

// Sélection du roadbook
$requete_roadbook = mysql_query('SELECT roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge FROM golfs_roadbook ORDER BY roadbook_golf, roadbook_trou');
$nb_roadbook = mysql_num_rows($requete_roadbook);
if($nb_roadbook!=0){
	for($roadbook_boucle=0; $roadbook_boucle<$nb_roadbook; $roadbook_boucle++){
		$resultat_roadbook = mysql_fetch_array($requete_roadbook);
		$roadbook_golf = $resultat_roadbook[0];
		$roadbook_trou = $resultat_roadbook[1];
		$roadbook_par = $resultat_roadbook[2];
		$roadbook_hcp = $resultat_roadbook[3];
		$roadbook_blanche = $resultat_roadbook[4];
		$roadbook_jaune = $resultat_roadbook[5];
		$roadbook_rouge = $resultat_roadbook[6];

		array_push($tab_golf_hcp_coups_recus[$roadbook_golf], $roadbook_hcp);

		array_push($tab_roadbook[$roadbook_golf], array($roadbook_trou, $roadbook_par, $roadbook_hcp, $roadbook_blanche, $roadbook_jaune, $roadbook_rouge));
	}

	for($num_golf=0; $num_golf<=3; $num_golf++){

		$golf_numero = $num_golf + 1;

		// Cacul de la somme des PAR pour le parcours aller
		$requete_roadbook_par = mysql_query('SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou<=9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysql_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_aller = $resultat_roadbook_par[0];

		// Cacul de la somme des PAR pour le parcours retour
		$requete_roadbook_par = mysql_query('SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou>9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysql_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_retour = $resultat_roadbook_par[0];

		// Cacul du total des PAR (aller + retour)
		$roadbook_golf_par_total = $roadbook_golf_par_aller + $roadbook_golf_par_retour;

		array_push($tab_roadbook_par, array($golf_numero, $roadbook_golf_par_retour, $roadbook_golf_par_aller, $roadbook_golf_par_total));

	}

}


/**************************************************************************************************************************************/

class PDF extends FPDF {


	function Scores($planning_id, $planning_equipe, $planning_golf_id, $tab_roadbook, $tab_roadbook_par, $tab_golf_hcp_coups_recus){

		// Sélection de la carte de score
		$requete_carte = mysql_query('SELECT score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_pro_abandon, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total FROM scores WHERE planning_id='.$planning_id);
		$nb_carte = mysql_num_rows($requete_carte);
		if($nb_carte!=0){

			$resultat_carte = mysql_fetch_array($requete_carte);
			$score_joueur_pro_id = $resultat_carte[0];
			$score_joueur_pro_resultats = explode(',', $resultat_carte[1]);
			$score_aller = $resultat_carte[2];
			$score_retour = $resultat_carte[3];
			$score_total = $resultat_carte[4];
			$score_joueur_pro_abandon = $resultat_carte[5];
			$score_joueur_am1_id = $resultat_carte[6];
			$score_joueur_am1_resultats = explode(',', $resultat_carte[7]);
			$score_joueur_am1_coupsrecus = explode(',', $resultat_carte[8]);
			$score_joueur_am2_id = $resultat_carte[9];
			$score_joueur_am2_resultats = explode(',', $resultat_carte[10]);
			$score_joueur_am2_coupsrecus = explode(',', $resultat_carte[11]);
			$score_joueur_am3_id = $resultat_carte[12];
			$score_joueur_am3_resultats = explode(',', $resultat_carte[13]);
			$score_joueur_am3_coupsrecus = explode(',', $resultat_carte[14]);
			$resultat_brut = explode(',', $resultat_carte[15]);
			$resultat_net = explode(',', $resultat_carte[16]);
			$resultat_brut_retour = $resultat_carte[17];
			$resultat_brut_aller = $resultat_carte[18];
			$resultat_brut_total = $resultat_carte[19];
			$resultat_net_retour = $resultat_carte[20];
			$resultat_net_aller = $resultat_carte[21];
			$resultat_net_total = $resultat_carte[22];

			$score = array($score_joueur_pro_id=>$score_joueur_pro_resultats, $score_joueur_am1_id=>$score_joueur_am1_resultats, $score_joueur_am2_id=>$score_joueur_am2_resultats, $score_joueur_am3_id=>$score_joueur_am3_resultats);

		}else{

			// Suppression des variables pour les résultats
			unset($score);
			unset($score_aller);
			unset($score_retour);
			unset($score_total);
			unset($resultat_brut);
			unset($resultat_net);
			unset($resultat_brut_retour);
			unset($resultat_brut_aller);
			unset($resultat_brut_total);
			unset($resultat_net_retour);
			unset($resultat_net_aller);
			unset($resultat_net_total);

		}


		$this->SetFont('Arial', 'B', 9);
		$this->Cell(36.5, 6, 'Trou', 1, 0, 'L', false);

		$this->SetFont('Arial', '', 9);
		for($t=0; $t<=17; $t++){
			$this->Cell(7.5, 6, ($t+1), 1, 0, 'C', false);
		}
		$this->Cell(11, 6, 'Retour', 1, 0, 'C', false);
		$this->Cell(11, 6, 'Aller', 1, 0, 'C', false);
		$this->Cell(12, 6, 'Total', 1, 1, 'C', false);

		$this->SetFont('Arial', 'B', 9);
		$this->Cell(36.5, 6, 'Par', 1, 0, 'L', false);
		foreach($tab_roadbook as $tab_trou){
			$this->Cell(7.5, 6, $tab_trou[1], 1, 0, 'C', false);
		}
		$this->Cell(11, 6, $tab_roadbook_par[1], 1, 0, 'C', false);
		$this->Cell(11, 6, $tab_roadbook_par[2], 1, 0, 'C', false);
		$this->Cell(12, 6, $tab_roadbook_par[3], 1, 1, 'C', false);

		$this->Cell(36.5, 6, 'Handicap', 1, 0, 'L', false);
		$this->SetFont('Arial', '', 9);
		foreach($tab_roadbook as $tab_trou){
			$this->Cell(7.5, 6, $tab_trou[2], 1, 0, 'C', false);
		}
		$this->Cell(1, 6, '', 0, 1, 'C', false);

		$this->Ln(2);


		/***************/
		/**  JOUEURS  **/
		/***************/

		// Sélection des joueurs de l'équipe sélectionnée
		$requete_joueurs = mysql_query('SELECT joueur_id, joueur_nom, joueur_prenom, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$planning_equipe.'") AND joueur_actif="1" AND joueur_profil<>"acc" ORDER BY joueur_profil DESC, joueur_handicap, joueur_nom, joueur_prenom');
		$nb_joueurs = mysql_num_rows($requete_joueurs);
		if($nb_joueurs!=0){
			for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
				$resultat_joueur = mysql_fetch_array($requete_joueurs);
				$joueur_id = $resultat_joueur[0];
				$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
				$joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2]))), 0, 1).'.';
				$joueur_profil = $resultat_joueur[3];
				$joueur_handicap = number_format($resultat_joueur[4], 1, '.', '');

				if(strlen($joueur_nom)>15){ $joueur_nom = substr($joueur_nom, 0, 14).'.'; }

				if(substr($joueur_handicap, -2)=='.0'){ $joueur_handicap_libelle = substr($joueur_handicap, 0, -2); }else{ $joueur_handicap_libelle = $joueur_handicap; }

				/**************************************************************/
				/***  Calcul et attribution des coups reçus pour le joueur  ***/
				/**************************************************************/
				$tab_joueur_coups_recus = array();
				$joueur_coups_recus = round(($joueur_handicap/4)*3);
				foreach($tab_golf_hcp_coups_recus[$planning_golf_id] as $tab_golf_hcp){
					if($tab_golf_hcp<=$joueur_coups_recus){
						array_push($tab_joueur_coups_recus, 1);
					}else{
						array_push($tab_joueur_coups_recus, 0);
					}
				}

				$this->SetFont('Arial', 'B', 9);
				$this->Cell(36.5, 10, $joueur_nom.' '.$joueur_prenom, 'TLR', 0, 'L', false);		// Nom du joueur
				$this->SetFont('Arial', 'B', 15);
				for($trou=0; $trou<=17; $trou++){
					if(isset($score[$joueur_id][$trou])){
						$this->Cell(7.5, 10, $score[$joueur_id][$trou], 1, 0, 'C', false);			// Score du joueur par trou
					}else{
						$this->Cell(7.5, 10, '', 1, 0, 'C', false);									// Score du joueur par trou vide
					}
				}
				if($joueur_profil=='pro'){
					$this->SetFont('Arial', '', 13);
					$this->Cell(11, 10, $score_retour, 1, 0, 'C', false);
					$this->Cell(11, 10, $score_aller, 1, 0, 'C', false);
					$this->SetFont('Arial', 'B', 13);
					if($score_joueur_pro_abandon==1){
						$this->Cell(12, 10, 'ABD', 1, 1, 'C', false);								// Affichage "ABD" si le joueur pro a abandonné
					}else{
						$this->Cell(12, 10, $score_total, 1, 1, 'C', false);
					}
				}else{
					$this->Cell(11, 10, '', 0, 1, 'C', false);
				}

				if($joueur_profil!='pro'){
		
					$this->SetFont('Arial', '', 8);
					$this->Cell(8, 5, '('.$joueur_handicap_libelle.')', 'BL', 0, 'L', false);		// Handicap
					$this->Cell(28.5, 5, utf8_decode('coups reçus').ESPACE, 'BR', 0, 'R', false);
					$this->SetFont('Arial', '', 8);
					foreach($tab_joueur_coups_recus as $tab_joueur_coup_recu){
						$this->Cell(7.5, 5, $tab_joueur_coup_recu, 1, 0, 'C', false);				// Nombre de coups reçus
					}
					$this->Cell(11, 5, '', 0, 1, 'C', false);

				}

			}

		}


		$this->Ln(2);


		/******************/
		/**  BRUT & NET  **/
		/******************/

		$this->SetFont('Arial', 'B', 9);
		$this->Cell(36.5, 7, 'Brut', 1, 0, 'L', false);
		$this->SetFont('Arial', '', 11);
		for($trou=0; $trou<=17; $trou++){
			if(isset($resultat_brut[$trou])){
				$this->Cell(7.5, 7, $resultat_brut[$trou], 1, 0, 'C', false);		// Résultat brut par trou
			}else{
				$this->Cell(7.5, 7, '', 1, 0, 'C', false);							// Résultat brut par trou vide
			}
		}
		$this->SetFont('Arial', '', 12);
		$this->Cell(11, 7, $resultat_brut_retour, 1, 0, 'C', false);				// Résultat brut pour le retour
		$this->Cell(11, 7, $resultat_brut_aller, 1, 0, 'C', false);					// Résultat brut pour l'aller
		$this->SetFont('Arial', 'B', 12);
		$this->Cell(12, 7, $resultat_brut_total, 1, 1, 'C', false);					// Résultat brut total

		/******************/

		$this->SetFont('Arial', 'B', 9);
		$this->Cell(36.5, 7, 'Net', 1, 0, 'L', false);
		$this->SetFont('Arial', '', 11);
		for($trou=0; $trou<=17; $trou++){
			if(isset($resultat_net[$trou])){
				$this->Cell(7.5, 7, $resultat_net[$trou], 1, 0, 'C', false);		// Résultat net par trou
			}else{
				$this->Cell(7.5, 7, '', 1, 0, 'C', false);							// Résultat net par trou vide
			}
		}
		$this->SetFont('Arial', '', 12);
		$this->Cell(11, 7, $resultat_net_retour, 1, 0, 'C', false);					// Résultat net pour le retour
		$this->Cell(11, 7, $resultat_net_aller, 1, 0, 'C', false);					// Résultat net pour l'aller
		$this->SetFont('Arial', 'B', 12);
		$this->Cell(12, 7, $resultat_net_total, 1, 1, 'C', false);					// Résultat net total

	}


	/*****************************************/
	/**  LIGNES BLANCHES / JAUNES / ROUGES  **/
	/*****************************************/

	function Parcours($tab_roadbook){

		$this->Ln(2);

		$this->SetFont('Arial', 'B', 9);
		$this->Cell(36.5, 6, 'Blanches', 1, 0, 'L', false);
		$this->SetFont('Arial', '', 8);
		foreach($tab_roadbook as $tab_trou){
			$this->Cell(7.5, 6, $tab_trou[3], 1, 0, 'C', false);
		}
		$this->Cell(5, 6, '', 0, 1, 'C', false);

		$this->SetFont('Arial', 'B', 9);
		$this->Cell(36.5, 6, 'Jaunes', 1, 0, 'L', false);
		$this->SetFont('Arial', '', 8);
		foreach($tab_roadbook as $tab_trou){
			$this->Cell(7.5, 6, $tab_trou[4], 1, 0, 'C', false);
		}
		$this->Cell(5, 6, '', 0, 1, 'C', false);

		$this->SetFont('Arial', 'B', 9);
		$this->Cell(36.5, 6, 'Rouges', 1, 0, 'L', false);
		$this->SetFont('Arial', '', 8);
		foreach($tab_roadbook as $tab_trou){
			$this->Cell(7.5, 6, $tab_trou[5], 1, 0, 'C', false);
		}
		$this->Cell(5, 6, '', 0, 1, 'C', false);

	}



	function Informations($planning_equipe_nom, $planning_golf_nom, $planning_depart_date, $planning_depart_heure, $sponsor, $cumul_statut, $cumul_pro, $cumul_brut_equipe, $cumul_net_equipe){

		$tab_jour = array('Monday'=>'Lundi', 'Tuesday'=>'Mardi', 'Wednesday'=>'Mercredi', 'Thursday'=>'Jeudi', 'Friday'=>'Vendredi', 'Saturday'=>'Samedi', 'Sunday'=>'Dimanche');
		$tab_mois = array('01'=>'Janvier', '02'=>'Février', '03'=>'Mars', '04'=>'Avril', '05'=>'Mai', '06'=>'Juin', '07'=>'Juillet', '08'=>'Août', '09'=>'Septembre', '10'=>'Octobre', '11'=>'Novembre', '12'=>'Décembre');

		$tab_depart_date = explode('/', $planning_depart_date);
		$depart_jour = $tab_depart_date[0];
		$depart_mois = $tab_depart_date[1];
		$depart_annee = $tab_depart_date[2];

		$depart_jour_anglais = date('l', mktime(0, 0, 0, $depart_mois, $depart_jour, $depart_annee));

		$depart_date = $tab_jour[$depart_jour_anglais].' '.$depart_jour.' '.utf8_decode($tab_mois[$depart_mois]).' '.$depart_annee;



		$this->Ln(5);

		/******************/

		$this->Cell(12, 4, utf8_decode('Équipe :'), 0, 0, 'L', false);
		$this->SetFont('Arial', 'B', 10);
		$this->Cell(50, 4, utf8_decode($planning_equipe_nom), 0, 0, 'L', false);

		if($cumul_statut==1){

			$this->SetFont('Arial', '', 10);
			$this->Cell(20, 4, 'Cumul pro :', 0, 0, 'L', false);				// Score cumulé du professionnel
			$this->SetFont('Arial', 'B', 10);
			$this->Cell(15, 4, $cumul_pro, 0, 0, 'L', false);
			$this->SetFont('Arial', '', 10);
			$this->Cell(21, 4, 'Cumul brut :', 0, 0, 'L', false);				// Score brut cumulé de l'équipe
			$this->SetFont('Arial', 'B', 10);
			$this->Cell(17, 4, $cumul_brut_equipe, 0, 0, 'L', false);
			$this->SetFont('Arial', '', 10);
			$this->Cell(20, 4, 'Cumul net :', 0, 0, 'L', false);				// Score net cumulé de l'équipe
			$this->SetFont('Arial', 'B', 10);
			$this->Cell(15, 4, $cumul_net_equipe, 0, 1, 'L', false);

		}else{

			$this->Cell(15, 4, '', 0, 1, 'L', false);

		}

		$this->Ln(4);

		/******************/

		$this->SetFont('Arial', 'B', 10);

		$this->Cell(60, 2, '', 'TL', 0, 'L', false);
		$this->Cell(5, 2, '', 'LR', 0, 'C', false);
		$this->Cell(68, 2, '', 'TR', 0, 'L', false);
		$this->Cell(62, 2, '', 0, 1, 'L', false);

		/******************/

		$this->Cell(60, 6, ESPACE.ESPACE.ESPACE.$depart_date, 'L', 0, 'L', false);			// Date du départ
		$this->Cell(5, 6, '', 'LR', 0, 'C', false);
		$this->Cell(68, 6, ESPACE.ESPACE.'Signatures', 'R', 0, 'L', false);					// Signature
		$this->Cell(1, 6, '', 0, 0, 'C', false);

		$this->SetFont('Arial', 'B', 14);
		$this->Cell(73, 6, utf8_decode($sponsor), 0, 1, 'C', false);

		/******************/

		$this->SetFont('Arial', 'B', 10);

		$this->Cell(60, 6, ESPACE.ESPACE.ESPACE.'Golf de '.utf8_decode($planning_golf_nom), 'LR', 0, 'L', false);				// Nom du golf

		$this->Cell(5, 6, '', 'LR', 0, 'C', false);
		$this->Cell(68, 6, '', 'LR', 1, 'C', false);

		/******************/

		$this->Cell(60, 6, ESPACE.ESPACE.ESPACE.utf8_decode('Départ à ').$planning_depart_heure, 'LR', 0, 'L', false);			// Heure du départ
		$this->Cell(5, 6, '', 'LR', 0, 'C', false);
		$this->Cell(68, 6, '', 'LR', 1, 'C', false);

		/******************/

		$this->Cell(60, 2, '', 'BL', 0, 'L', false);
		$this->Cell(5, 2, '', 'LR', 0, 'C', false);
		$this->Cell(68, 2, '', 'BR', 0, 'L', false);
		$this->Cell(62, 2, '', 0, 1, 'L', false);

		$this->SetTextColor(0, 0, 0);

	}

}

/**************************************************************************************************************************************/

// Instanciation de la classe dérivée
$pdf = new PDF();
$pdf->AliasNbPages();

if($nb_planning!=0){

	for($planning_boucle=0; $planning_boucle<$nb_planning; $planning_boucle++){
		$resultat_planning = mysql_fetch_array($requete_planning);
		$planning_id = $resultat_planning[0];
		$planning_groupe = $resultat_planning[1];
		$planning_equipe = $resultat_planning[2];
		$planning_equipe_nom = $resultat_planning[3];
		$planning_golf_id = $resultat_planning[4];
		$planning_golf_nom = strtoupper_max($resultat_planning[5]);
		$planning_depart_date_origine = $resultat_planning[6];
		$planning_depart_date = $resultat_planning[7];
		$planning_depart_heure = $resultat_planning[8];

		if($planning_depart_date_origine==$competition_date_debut){
			$cumul_statut = 0;
			$cumul_pro = $cumul_brut_equipe = $cumul_net_equipe = '';
		}else{

			$cumul_statut = 1;

			// Cacul du cumul du professionnel
			$requete_cumul_pro = mysql_query('SELECT SUM(score_joueur_pro_resultats_total) AS total FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$planning_equipe.'" AND planning_depart_date<="'.$planning_depart_date_origine.'"');
			$resultat_cumul_pro = mysql_fetch_array($requete_cumul_pro);
			$cumul_pro = $resultat_cumul_pro[0];

			// Cacul du cumul brut de l'équipe
			$requete_cumul_brut_equipe = mysql_query('SELECT SUM(score_joueur_brut_total) AS total FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$planning_equipe.'" AND planning_depart_date<="'.$planning_depart_date_origine.'"');
			$resultat_cumul_brut_equipe = mysql_fetch_array($requete_cumul_brut_equipe);
			$cumul_brut_equipe = $resultat_cumul_brut_equipe[0];

			// Cacul du cumul du professionnel
			$requete_cumul_net_equipe = mysql_query('SELECT SUM(score_joueur_net_total) AS total FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$planning_equipe.'" AND planning_depart_date<="'.$planning_depart_date_origine.'"');
			$resultat_cumul_net_equipe = mysql_fetch_array($requete_cumul_net_equipe);
			$cumul_net_equipe = $resultat_cumul_net_equipe[0];

		}

		if($planning_depart_date_origine==$competition_date_debut){
			$sponsor = $competition_sponsor[0];
		}elseif($planning_depart_date_origine==$competition_date_jour2){
			$sponsor = $competition_sponsor[1];
		}elseif($planning_depart_date_origine==$competition_date_jour3){
			$sponsor = $competition_sponsor[2];
		}elseif($planning_depart_date_origine==$competition_date_jour4){
			$sponsor = $competition_sponsor[3];
		}

		$pdf->SetMargins(1.8, 1, 1);
		$pdf->SetAutoPageBreak(false, 1);
		$pdf->AddPage('L', 'A5');

		$pdf->Scores($planning_id, $planning_equipe, $planning_golf_id, $tab_roadbook[$planning_golf_id], $tab_roadbook_par[($planning_golf_id-1)], $tab_golf_hcp_coups_recus);
		$pdf->Parcours($tab_roadbook[$planning_golf_id]);
		$pdf->Informations($planning_equipe_nom, $planning_golf_nom, $planning_depart_date, $planning_depart_heure, $sponsor, $cumul_statut, $cumul_pro, $cumul_brut_equipe, $cumul_net_equipe);

	}
}

if(isset($archive) AND $archive==1){
	$pdf->Output('../../../archives/archive_'.$competition_date_debut_annee.'_cartes_score.pdf', 'F');
	header('Location: ../../competitions/competitions/archiver.php?process=classement_cumule_brut_net');
	exit;
}else{
	$pdf->Output('Cartes_score.pdf', 'I');
}
?>
