<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(4, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	// Reconstitution des tableaux de joueurs
	$tableau_amateurs = array($joueur_am_1, $joueur_am_2, $joueur_am_3);
	$tableau_accompagnateurs = array($joueur_acc_1, $joueur_acc_2, $joueur_acc_3, $joueur_acc_4, $joueur_acc_5);


	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($equipe_nom))==0){
		$erreur_message .= "- le nom est manquant<br>";
	}
	if(strlen(trim($equipe_motdepasse))!=0 AND strlen(trim($equipe_motdepasse))<8){
		$erreur_message .= "- le mot de passe est incorrect (minimum 8 caractères)<br>";
	}
	if($joueur_am_1!=0 AND $joueur_am_2!=0 AND $joueur_am_1==$joueur_am_2){
		$erreur_message .= "- la sélection du joueur amateur 1 et 2 doit être différente<br>";
	}
	if($joueur_am_2!=0 AND $joueur_am_3!=0 AND $joueur_am_2==$joueur_am_3){
		$erreur_message .= "- la sélection du joueur amateur 2 et 3 doit être différente<br>";
	}
	if($joueur_am_1!=0 AND $joueur_am_3!=0 AND $joueur_am_1==$joueur_am_3){
		$erreur_message .= "- la sélection du joueur amateur 1 et 3 doit être différente<br>";
	}
	if($joueur_acc_1!=0 AND $joueur_acc_2!=0 AND $joueur_acc_1==$joueur_acc_2){
		$erreur_message .= "- la sélection du joueur accompagnateur 1 et 2 doit être différente<br>";
	}
	if($joueur_acc_2!=0 AND $joueur_acc_3!=0 AND $joueur_acc_2==$joueur_acc_3){
		$erreur_message .= "- la sélection du joueur accompagnateur 2 et 3 doit être différente<br>";
	}
	if($joueur_acc_3!=0 AND $joueur_acc_4!=0 AND $joueur_acc_3==$joueur_acc_4){
		$erreur_message .= "- la sélection du joueur accompagnateur 3 et 4 doit être différente<br>";
	}
	if($joueur_acc_4!=0 AND $joueur_acc_5!=0 AND $joueur_acc_4==$joueur_acc_5){
		$erreur_message .= "- la sélection du joueur accompagnateur 4 et 5 doit être différente<br>";
	}
	if($joueur_acc_1!=0 AND $joueur_acc_3!=0 AND $joueur_acc_1==$joueur_acc_3){
		$erreur_message .= "- la sélection du joueur accompagnateur 1 et 3 doit être différente<br>";
	}
	if($joueur_acc_1!=0 AND $joueur_acc_4!=0 AND $joueur_acc_1==$joueur_acc_4){
		$erreur_message .= "- la sélection du joueur accompagnateur 1 et 4 doit être différente<br>";
	}
	if($joueur_acc_1!=0 AND $joueur_acc_5!=0 AND $joueur_acc_1==$joueur_acc_5){
		$erreur_message .= "- la sélection du joueur accompagnateur 1 et 5 doit être différente<br>";
	}

	if($joueur_acc_2!=0 AND $joueur_acc_4!=0 AND $joueur_acc_2==$joueur_acc_4){
		$erreur_message .= "- la sélection du joueur accompagnateur 2 et 4 doit être différente<br>";
	}
	if($joueur_acc_2!=0 AND $joueur_acc_5!=0 AND $joueur_acc_2==$joueur_acc_5){
		$erreur_message .= "- la sélection du joueur accompagnateur 2 et 5 doit être différente<br>";
	}
	if($joueur_acc_3!=0 AND $joueur_acc_5!=0 AND $joueur_acc_3==$joueur_acc_5){
		$erreur_message .= "- la sélection du joueur accompagnateur 3 et 5 doit être différente<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$equipe_nom = htmlentities(strtoupper($equipe_nom), ENT_QUOTES);

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		if(strlen(trim($equipe_motdepasse))!=0){ $requete_motdepasse = ', equipe_motdepasse="'.md5(trim($equipe_motdepasse)).'"'; }else{ $requete_motdepasse = ''; }

		// Requête de mise à jour de l'équipe
		$requete_maj_1 = mysqli_query($connexion_mysql, 'UPDATE equipes SET equipe_nom="'.$equipe_nom.'"'.$requete_motdepasse.', equipe_active="'.$equipe_active.'" WHERE equipe_id="'.$equipe_id.'"');

		// Requête de suppression (purge) des liaisons équipe / joueur
		$requete_ej_suppression = mysqli_query($connexion_mysql, 'DELETE FROM equipes_joueurs WHERE ej_equipe="'.$equipe_id.'"');

		$ej_id = uniqid();

		if($joueur_pro!=0){
			// Requête de mise à jour de la liaison équipe / joueur
			$requete_ej_insertion_1 = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_pro.'")');
		}

		// Fusion des 2 tableaux de joueurs
		$tableau_joueurs = array_merge($tableau_amateurs, $tableau_accompagnateurs);

		foreach($tableau_joueurs as $joueur){
			if($joueur!=0){

				$ej_id = uniqid();

				// Requête de mise à jour de la liaison équipe / joueur
				$requete_ej_insertion_2 = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur.'")');

			}
		}

		header('Location: ./');
		exit;

	}else{
		$equipe_nom = stripslashes($equipe_nom);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection de l'équipe
	$requete_equipe = mysqli_query($connexion_mysql, 'SELECT equipe_nom, equipe_motdepasse, equipe_active FROM equipes WHERE equipe_id="'.$equipe_id.'"');
	$resultat_equipe = mysqli_fetch_array($requete_equipe);
	$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[0])));
	$equipe_motdepasse = $resultat_equipe[1];
	$equipe_active = $resultat_equipe[2];

	// Sélection du joueur professionnel
	$requete_professionnel = mysqli_query($connexion_mysql, 'SELECT ej_joueur FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
	$nb_professionnel = mysqli_num_rows($requete_professionnel);
	if($nb_professionnel!=0){
		$resultat_professionnel = mysqli_fetch_array($requete_professionnel);
		$joueur_pro = $resultat_professionnel[0];
	}else{
		$joueur_pro = '';
	}

	// Sélection des amateurs de l'équipe
	$requete_amateurs = mysqli_query($connexion_mysql, 'SELECT ej_joueur FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="am"');
	$nb_amateurs = mysqli_num_rows($requete_amateurs);
	if($nb_amateurs!=0){
		for($amateur_boucle=0; $amateur_boucle<$nb_amateurs; $amateur_boucle++){
			$resultat_amateur = mysqli_fetch_array($requete_amateurs);
			$tableau_amateurs[$amateur_boucle] = $resultat_amateur[0];
		}
	}

	// Sélection des accompagnateurs de l'équipe
	$requete_accompagnateurs = mysqli_query($connexion_mysql, 'SELECT ej_joueur FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="acc"');
	$nb_accompagnateurs = mysqli_num_rows($requete_accompagnateurs);
	if($nb_accompagnateurs!=0){
		for($accompagnateur_boucle=0; $accompagnateur_boucle<$nb_accompagnateurs; $accompagnateur_boucle++){
			$resultat_accompagnateur = mysqli_fetch_array($requete_accompagnateurs);
			$tableau_accompagnateurs[$accompagnateur_boucle] = $resultat_accompagnateur[0];
		}
	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery-ui-personalized-1.6rc6.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none"></head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Équipes</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="equipe_id" value="<?=$equipe_id?>">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Statut</div>
					<div id="formulaire_champ" style="width: 470px;">
						<input type="radio" id="equipe_active_1" name="equipe_active" value="1" <?php if($equipe_active==1){ echo 'checked'; } ?> class="radio"> <label for="equipe_active_1">Actif</label>
						<input type="radio" id="equipe_active_0" name="equipe_active" value="0" <?php if($equipe_active==0){ echo 'checked'; } ?> class="radio" style="margin-left: 20px;"> <label for="equipe_active_0">Inactif</label>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire" style="width: 130px;">Nom</div>
					<div id="formulaire_champ" style="width: 470px;"><input type="text" name="equipe_nom" value="<?=$equipe_nom?>" class="input" style="width: 440px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Mot de passe</div>
					<div id="formulaire_champ" style="width: 470px;"><input type="password" name="equipe_motdepasse" class="input" style="width: 100px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">JOUEURS</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Professionnel</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_pro" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs professionnels non liés à une équipe
							$requete_joueurs_pro = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="pro" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_pro = mysqli_num_rows($requete_joueurs_pro);
							if($nb_joueurs_pro!=0){
								for($joueur_pro_boucle=0; $joueur_pro_boucle<$nb_joueurs_pro; $joueur_pro_boucle++){
									$resultat_joueur_pro = mysqli_fetch_array($requete_joueurs_pro);
									$joueur_professionnel_id = $resultat_joueur_pro[0];
									$joueur_professionnel_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_pro[1])));
									$joueur_professionnel_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_pro[2])));

									if(isset($joueur_pro) AND $joueur_pro==$joueur_professionnel_id){ $joueur_pro_selection = ' selected'; }else{ $joueur_pro_selection = ''; }

									echo '<option value="'.$joueur_professionnel_id.'"'.$joueur_pro_selection.'>'.$joueur_professionnel_nom.' '.$joueur_professionnel_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_separateur"></div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Amateur 1</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_am_1" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs amateurs non liés à une équipe
							$requete_joueur_am_1 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="am" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_am_1 = mysqli_num_rows($requete_joueur_am_1);
							if($nb_joueurs_am_1!=0){
								for($joueur_am_1_boucle=0; $joueur_am_1_boucle<$nb_joueurs_am_1; $joueur_am_1_boucle++){
									$resultat_joueur_am_1 = mysqli_fetch_array($requete_joueur_am_1);
									$joueur_am_1_id = $resultat_joueur_am_1[0];
									$joueur_am_1_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_am_1[1])));
									$joueur_am_1_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_am_1[2])));

									if(isset($tableau_amateurs[0]) AND $tableau_amateurs[0]==$joueur_am_1_id){ $joueur_am_1_selection = ' selected'; }else{ $joueur_am_1_selection = ''; }

									echo '<option value="'.$joueur_am_1_id.'"'.$joueur_am_1_selection.'>'.$joueur_am_1_nom.' '.$joueur_am_1_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Amateur 2</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_am_2" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs amateurs non liés à une équipe
							$requete_joueur_am_2 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="am" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_am_2 = mysqli_num_rows($requete_joueur_am_2);
							if($nb_joueurs_am_2!=0){
								for($joueur_am_2_boucle=0; $joueur_am_2_boucle<$nb_joueurs_am_2; $joueur_am_2_boucle++){
									$resultat_joueur_am_2 = mysqli_fetch_array($requete_joueur_am_2);
									$joueur_am_2_id = $resultat_joueur_am_2[0];
									$joueur_am_2_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_am_2[1])));
									$joueur_am_2_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_am_2[2])));

									if(isset($tableau_amateurs[1]) AND $tableau_amateurs[1]==$joueur_am_2_id){ $joueur_am_2_selection = ' selected'; }else{ $joueur_am_2_selection = ''; }

									echo '<option value="'.$joueur_am_2_id.'"'.$joueur_am_2_selection.'>'.$joueur_am_2_nom.' '.$joueur_am_2_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Amateur 3</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_am_3" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs amateurs non liés à une équipe
							$requete_joueur_am_3 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="am" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_am_3 = mysqli_num_rows($requete_joueur_am_3);
							if($nb_joueurs_am_3!=0){
								for($joueur_am_3_boucle=0; $joueur_am_3_boucle<$nb_joueurs_am_3; $joueur_am_3_boucle++){
									$resultat_joueur_am_3 = mysqli_fetch_array($requete_joueur_am_3);
									$joueur_am_3_id = $resultat_joueur_am_3[0];
									$joueur_am_3_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_am_3[1])));
									$joueur_am_3_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_am_3[2])));

									if(isset($tableau_amateurs[2]) AND $tableau_amateurs[2]==$joueur_am_3_id){ $joueur_am_3_selection = ' selected'; }else{ $joueur_am_3_selection = ''; }

									echo '<option value="'.$joueur_am_3_id.'"'.$joueur_am_3_selection.'>'.$joueur_am_3_nom.' '.$joueur_am_3_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_separateur"></div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Accompagnateur 1</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_acc_1" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs accompagnateurs non liés à une équipe
							$requete_joueur_acc_1 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="acc" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_acc_1 = mysqli_num_rows($requete_joueur_acc_1);
							if($nb_joueurs_acc_1!=0){
								for($joueur_acc_1_boucle=0; $joueur_acc_1_boucle<$nb_joueurs_acc_1; $joueur_acc_1_boucle++){
									$resultat_joueur_acc_1 = mysqli_fetch_array($requete_joueur_acc_1);
									$joueur_acc_1_id = $resultat_joueur_acc_1[0];
									$joueur_acc_1_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_1[1])));
									$joueur_acc_1_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_1[2])));

									if(isset($tableau_accompagnateurs[0]) AND $tableau_accompagnateurs[0]==$joueur_acc_1_id){ $joueur_acc_1_selection = ' selected'; }else{ $joueur_acc_1_selection = ''; }

									echo '<option value="'.$joueur_acc_1_id.'"'.$joueur_acc_1_selection.'>'.$joueur_acc_1_nom.' '.$joueur_acc_1_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Accompagnateur 2</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_acc_2" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs accompagnateurs non liés à une équipe
							$requete_joueur_acc_2 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="acc" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_acc_2 = mysqli_num_rows($requete_joueur_acc_2);
							if($nb_joueurs_acc_2!=0){
								for($joueur_acc_2_boucle=0; $joueur_acc_2_boucle<$nb_joueurs_acc_2; $joueur_acc_2_boucle++){
									$resultat_joueur_acc_2 = mysqli_fetch_array($requete_joueur_acc_2);
									$joueur_acc_2_id = $resultat_joueur_acc_2[0];
									$joueur_acc_2_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_2[1])));
									$joueur_acc_2_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_2[2])));

									if(isset($tableau_accompagnateurs[1]) AND $tableau_accompagnateurs[1]==$joueur_acc_2_id){ $joueur_acc_2_selection = ' selected'; }else{ $joueur_acc_2_selection = ''; }

									echo '<option value="'.$joueur_acc_2_id.'"'.$joueur_acc_2_selection.'>'.$joueur_acc_2_nom.' '.$joueur_acc_2_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Accompagnateur 3</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_acc_3" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs accompagnateurs non liés à une équipe
							$requete_joueur_acc_3 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="acc" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_acc_3 = mysqli_num_rows($requete_joueur_acc_3);
							if($nb_joueurs_acc_3!=0){
								for($joueur_acc_3_boucle=0; $joueur_acc_3_boucle<$nb_joueurs_acc_3; $joueur_acc_3_boucle++){
									$resultat_joueur_acc_3 = mysqli_fetch_array($requete_joueur_acc_3);
									$joueur_acc_3_id = $resultat_joueur_acc_3[0];
									$joueur_acc_3_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_3[1])));
									$joueur_acc_3_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_3[2])));

									if(isset($tableau_accompagnateurs[2]) AND $tableau_accompagnateurs[2]==$joueur_acc_3_id){ $joueur_acc_3_selection = ' selected'; }else{ $joueur_acc_3_selection = ''; }

									echo '<option value="'.$joueur_acc_3_id.'"'.$joueur_acc_3_selection.'>'.$joueur_acc_3_nom.' '.$joueur_acc_3_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Accompagnateur 4</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_acc_4" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs accompagnateurs non liés à une équipe
							$requete_joueur_acc_4 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="acc" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_acc_4 = mysqli_num_rows($requete_joueur_acc_4);
							if($nb_joueurs_acc_4!=0){
								for($joueur_acc_4_boucle=0; $joueur_acc_4_boucle<$nb_joueurs_acc_4; $joueur_acc_4_boucle++){
									$resultat_joueur_acc_4 = mysqli_fetch_array($requete_joueur_acc_4);
									$joueur_acc_4_id = $resultat_joueur_acc_4[0];
									$joueur_acc_4_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_4[1])));
									$joueur_acc_4_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_4[2])));

									if(isset($tableau_accompagnateurs[3]) AND $tableau_accompagnateurs[3]==$joueur_acc_4_id){ $joueur_acc_4_selection = ' selected'; }else{ $joueur_acc_4_selection = ''; }

									echo '<option value="'.$joueur_acc_4_id.'"'.$joueur_acc_4_selection.'>'.$joueur_acc_4_nom.' '.$joueur_acc_4_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle" style="width: 130px;">Accompagnateur 5</div>
					<div id="formulaire_champ" style="width: 470px;">
						<select name="joueur_acc_5" size="1" class="select" style="min-width: 200px;">
							<option value="0">-</option>
							<?php 
							// Sélection des joueurs accompagnateurs non liés à une équipe
							$requete_joueur_acc_5 = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil="acc" ORDER BY joueur_nom, joueur_prenom');
							$nb_joueurs_acc_5 = mysqli_num_rows($requete_joueur_acc_5);
							if($nb_joueurs_acc_5!=0){
								for($joueur_acc_5_boucle=0; $joueur_acc_5_boucle<$nb_joueurs_acc_5; $joueur_acc_5_boucle++){
									$resultat_joueur_acc_5 = mysqli_fetch_array($requete_joueur_acc_5);
									$joueur_acc_5_id = $resultat_joueur_acc_5[0];
									$joueur_acc_5_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_5[1])));
									$joueur_acc_5_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc_5[2])));

									if(isset($tableau_accompagnateurs[4]) AND $tableau_accompagnateurs[4]==$joueur_acc_5_id){ $joueur_acc_5_selection = ' selected'; }else{ $joueur_acc_5_selection = ''; }

									echo '<option value="'.$joueur_acc_5_id.'"'.$joueur_acc_5_selection.'>'.$joueur_acc_5_nom.' '.$joueur_acc_5_prenom.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>


				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.modifier.equipe_nom.focus();
	//-->
</script>

</body>
</html>
