<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(3, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Valeurs par défaut
if(!isset($classement)){
	$classement = 'nom';
	$ordre = 'ASC';
}


$contenu_excel  = "<html>\n";
$contenu_excel .= "<head>\n";
	$contenu_excel .= "<meta http-equiv=Content-Type content='text/html; charset=UTF-8'>\n";
	$contenu_excel .= "<style>\n";
		$contenu_excel .= ".tableau_1 { font-family:arial; color:black; font-size:14.0pt; font-weight:700; text-decoration:underline; text-underline-style:single; text-align:left; vertical-align:middle; background:white; }\n";
		$contenu_excel .= ".tableau_2 { font-family:arial; color:black; font-size:12.0pt; font-weight:700; text-underline-style:single; text-align:left; vertical-align:middle; background:white; }\n";
		$contenu_excel .= ".colonnes_titre { font-family:arial; color:black; font-size:10.0pt; font-weight:700; text-underline-style:single; text-align:center; vertical-align:middle; background:white; border: 1px solid black; }\n";
		$contenu_excel .= ".cellules_standard_1 { font-family:arial; color:black; font-size:10.0pt; font-weight:200; text-underline-style:single; text-align:center; vertical-align:middle; background:white; border: 1px solid black; }\n";
		$contenu_excel .= ".cellules_standard_2 { font-family:arial; color:black; font-size:10.0pt; font-weight:200; text-underline-style:single; text-align:left; vertical-align:middle; background:white; border: 1px solid black; }\n";
	$contenu_excel .= "</style>\n";
$contenu_excel .= "</head>\n";
$contenu_excel .= "<body>\n\n";

$contenu_excel .= "<table width=2850 border=0 cellpadding=0 cellspacing=0 style='border-collapse: collapse;table-layout:fixed'>\n";
	$contenu_excel .= "<col width=100>\n";				// Colonne du profil du joueur
	$contenu_excel .= "<col width=100>\n";				// Colonne du numéro de licence du joueur
	$contenu_excel .= "<col width=200>\n";				// Colonne du club du joueur
	$contenu_excel .= "<col width=80>\n";				// Colonne de membre de l'un des clubs de la compétition
	$contenu_excel .= "<col width=50>\n";				// Colonne du handicap du joueur
	$contenu_excel .= "<col width=50>\n";				// Colonne de la validation du handicap du joueur
	$contenu_excel .= "<col width=130>\n";				// Colonne du nom de l'équipe
	$contenu_excel .= "<col width=120>\n";				// Colonne du nom de l'accompagnant (si profil acc)
	$contenu_excel .= "<col width=50>\n";				// Colonne du sexe du joueur
	$contenu_excel .= "<col width=120>\n";				// Colonne du nom du joueur
	$contenu_excel .= "<col width=120>\n";				// Colonne du prénom du joueur
	$contenu_excel .= "<col width=80>\n";				// Colonne de la date de naissance du joueur
	$contenu_excel .= "<col width=40>\n";				// Colonne de la taille du polo du joueur
	$contenu_excel .= "<col width=200>\n";				// Colonne de l'adresse 1 du joueur
	$contenu_excel .= "<col width=170>\n";				// Colonne de l'adresse 2 du joueur
	$contenu_excel .= "<col width=80>\n";				// Colonne du code postal du joueur
	$contenu_excel .= "<col width=150>\n";				// Colonne de la ville du joueur
	$contenu_excel .= "<col width=50>\n";				// Colonne du pays du joueur
	$contenu_excel .= "<col width=200>\n";				// Colonne de l'e-mail du joueur
	$contenu_excel .= "<col width=120>\n";				// Colonne du mobile du joueur
	$contenu_excel .= "<col width=120>\n";				// Colonne du téléphone du joueur
	$contenu_excel .= "<col width=250>\n";				// Colonne de la société (facturation)
	$contenu_excel .= "<col width=80>\n";				// Colonne de la langue du joueur
	$contenu_excel .= "<col width=120>\n";				// Colonne de la date de création du joueur

	$contenu_excel .= "<tr height=30><td height=30 colspan=24 class=tableau_1>LISTE DES JOUEURS AU ".date('d/m/Y H\hi')."</td></tr>\n";
	$contenu_excel .= "<tr height=20><td height=20 colspan=24 class=tableau_2>&nbsp;</td></tr>\n";
	$contenu_excel .= "<tr height=30>\n";
		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre>PROFIL</td>\n";
		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre>N° LICENCE</td>\n";
		$contenu_excel .= "<td width=200 height=30 class=colonnes_titre>CLUB</td>\n";
		$contenu_excel .= "<td width=80 height=30 class=colonnes_titre>MEMBRE UN DES 4 CLUBS</td>\n";
		$contenu_excel .= "<td width=50 height=30 class=colonnes_titre>HDCP</td>\n";
		$contenu_excel .= "<td width=50 height=30 class=colonnes_titre>VALID.</td>\n";
		$contenu_excel .= "<td width=130 height=30 class=colonnes_titre>ÉQUIPE</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>ACCOMPAGNANT</td>\n";
		$contenu_excel .= "<td width=50 height=30 class=colonnes_titre>SEXE</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>NOM</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>PRÉNOM</td>\n";
		$contenu_excel .= "<td width=80 height=30 class=colonnes_titre>NÉ(E) LE</td>\n";
		$contenu_excel .= "<td width=40 height=30 class=colonnes_titre>POLO</td>\n";
		$contenu_excel .= "<td width=200 height=30 class=colonnes_titre>ADRESSE 1</td>\n";
		$contenu_excel .= "<td width=170 height=30 class=colonnes_titre>ADRESSE 2</td>\n";
		$contenu_excel .= "<td width=80 height=30 class=colonnes_titre>CP</td>\n";
		$contenu_excel .= "<td width=150 height=30 class=colonnes_titre>VILLE</td>\n";
		$contenu_excel .= "<td width=50 height=30 class=colonnes_titre>PAYS</td>\n";
		$contenu_excel .= "<td width=200 height=30 class=colonnes_titre>E-MAIL</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>MOBILE</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>TÉLÉPHONE</td>\n";
		$contenu_excel .= "<td width=250 height=30 class=colonnes_titre>SOCIÉTÉ</td>\n";
		$contenu_excel .= "<td width=80 height=30 class=colonnes_titre>LANGUE</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>DATE CRÉATION</td>\n";
	$contenu_excel .= "</tr>\n";


	$requete_where = 'WHERE joueur_id<>""';

	if(strlen(trim($export_joueur_motcle))!=0){
		$requete_where .= ' AND (joueur_id LIKE "%'.$export_joueur_motcle.'%" OR joueur_nom LIKE "%'.$export_joueur_motcle.'%" OR joueur_prenom LIKE "%'.$export_joueur_motcle.'%")';
	}

	if(isset($export_equipe) AND $export_equipe!='0'){
		$requete_where .= ' AND joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$export_equipe.'")';
	}

	if((isset($export_joueur_actif) AND $export_joueur_actif==1) OR (isset($export_joueur_inactif) AND $export_joueur_inactif==1)){
		$requete_where .= ' AND (';
		if(isset($export_joueur_actif) AND $export_joueur_actif==1){
			$requete_where .= 'joueur_actif="1" OR ';
		}
		if(isset($export_joueur_inactif) AND $export_joueur_inactif==1){
			$requete_where .= 'joueur_actif="0" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
	}

	if(isset($export_joueur_langues) AND count($export_joueur_langues)!=0){
		$export_joueur_langues = explode('|', $export_joueur_langues);
		$requete_where .= ' AND (';
		foreach($export_joueur_langues as $export_joueur_langue){
			$requete_where .= 'joueur_langue="'.$export_joueur_langue.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
	}

	if($export_joueur_equipe=='avec'){
		$requete_where .= ' AND joueur_id IN (SELECT ej_joueur FROM equipes_joueurs)';
	}elseif($export_joueur_equipe=='sans'){
		$requete_where .= ' AND joueur_id NOT IN (SELECT ej_joueur FROM equipes_joueurs)';
	}

	if(isset($export_joueur_profils) AND count($export_joueur_profils)!=0){
		$export_joueur_profils = explode('|', $export_joueur_profils);
		$requete_where .= ' AND (';
		foreach($export_joueur_profils as $export_joueur_profil){
			$requete_where .= 'joueur_profil="'.$export_joueur_profil.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
	}

	if($classement=='nom'){
		$requete_orderby = 'joueur_nom '.$ordre.', joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='profil'){
		$requete_orderby = 'joueur_profil '.$ordre.', joueur_nom, joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='equipe'){
		$requete_orderby = '(SELECT equipe_nom FROM equipes A INNER JOIN equipes_joueurs B ON A.equipe_id=B.ej_equipe WHERE B.ej_joueur=joueur_id) '.$ordre.', joueur_profil DESC, joueur_nom, joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='date'){
		$requete_orderby = 'joueur_datetime_creation '.$ordre.', joueur_nom, joueur_prenom';
	}elseif($classement=='statut'){
		$requete_orderby = 'joueur_actif '.$ordre.', joueur_datetime_creation';
	}

	// Sélection des joueurs enregistrés
	$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(joueur_id), joueur_profil, joueur_club, joueur_licence, joueur_handicap, joueur_handicap_validation, joueur_membre_club_competition, joueur_taille_polo, joueur_sexe, joueur_nom, joueur_prenom, DATE_FORMAT(joueur_date_naissance, "%d/%m/%Y"), joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_langue, DATE_FORMAT(joueur_datetime_creation, "%d/%m/%y %H:%i") FROM joueurs '.$requete_where.' ORDER BY '.$requete_orderby);
	$nb_joueurs = mysqli_num_rows($requete_joueurs);
	if($nb_joueurs!=0){

		for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
			$resultat_joueur = mysqli_fetch_array($requete_joueurs);
			$joueur_id = $resultat_joueur[0];
			$joueur_profil = $resultat_joueur[1];
			$joueur_club = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2])));
			$joueur_licence = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[3])));
			$joueur_handicap = $resultat_joueur[4];
			$joueur_handicap_validation = $resultat_joueur[5];
			$joueur_membre_club_competition = $resultat_joueur[6];
			$joueur_taille_polo = $resultat_joueur[7];
			$joueur_sexe = $resultat_joueur[8];
			$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[9])));
			$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[10])));
			$joueur_date_naissance = $resultat_joueur[11];
			$joueur_adresse_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[12])));
			$joueur_adresse_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[13])));
			$joueur_code_postal = $resultat_joueur[14];
			$joueur_ville = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[15])));
			$joueur_pays = $resultat_joueur[16];
			$joueur_email = $resultat_joueur[17];
			$joueur_mobile = $resultat_joueur[18];
			$joueur_telephone = $resultat_joueur[19];
			$joueur_langue = strtoupper($resultat_joueur[20]);
			$joueur_datetime_creation = $resultat_joueur[21];

			// Sélection du nom de l'équipe
			$requete_equipe = mysqli_query($connexion_mysql, 'SELECT equipe_nom FROM equipes_joueurs A INNER JOIN equipes B ON A.ej_equipe=B.equipe_id WHERE ej_joueur="'.$joueur_id.'"');
			$nb_equipe = mysqli_num_rows($requete_equipe);
			if($nb_equipe!=0){
				$resultat_equipe = mysqli_fetch_array($requete_equipe);
				$equipe_nom = $resultat_equipe[0];
			}else{
				$equipe_nom = '-';
			}

			if($joueur_profil!='acc'){

				if($joueur_profil=='pro'){ $joueur_profil = 'Professionnel'; }else{ $joueur_profil = 'Amateur'; }

				if($joueur_handicap=='0.0'){
					$joueur_handicap = '-';
				}elseif(substr($joueur_handicap, -2)!='.0'){
					$joueur_handicap = number_format($joueur_handicap, 1, ',', '');
				}elseif(substr($joueur_handicap, -2)=='.0'){
					$joueur_handicap = number_format($joueur_handicap, 0);
				}

				if($joueur_handicap_validation==0){ $joueur_handicap_validation = 'non'; }else{ $joueur_handicap_validation = 'oui'; }
				if($joueur_membre_club_competition==0){ $joueur_membre_club_competition = 'non'; }else{ $joueur_membre_club_competition = 'oui'; }
				$joueur_acc_nom = $joueur_acc_prenom = '';

			}else{
				$joueur_profil = 'Accompagnateur';
				$joueur_licence = '-';
				$joueur_club = '-';
				$joueur_handicap = '-';
				$joueur_handicap_validation = '-';
				$joueur_membre_club_competition = '-';

				// Sélection du joueur accompagnant enregistré
				$requete_joueur_acc = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur_accompagnant=B.joueur_id WHERE ej_joueur="'.$joueur_id.'"');
				$resultat_joueur_acc = mysqli_fetch_array($requete_joueur_acc);
				$joueur_acc_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc[0])));
				$joueur_acc_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur_acc[1])));
			}

			if($joueur_date_naissance=='00/00/0000'){ $joueur_date_naissance = '-'; }
			if(strlen(trim($equipe_nom))==0){ $equipe_nom = '-'; }


			// Sélection de la société s'il y a
			$requete_societe = mysqli_query($connexion_mysql, 'SELECT facture_entreprise_nom FROM factures WHERE joueur_id="'.$joueur_id.'"');
			$nb_societe = mysqli_num_rows($requete_societe);
			if($nb_societe!=0){
				$resultat_societe = mysqli_fetch_array($requete_societe);
				$joueur_societe = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_societe[0]))));
			}else{
				$joueur_societe = '';
			}


			$contenu_excel .= "<tr height=18>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_profil."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_licence."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_club."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_membre_club_competition."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_handicap."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_handicap_validation."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$equipe_nom."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_acc_nom.' '.$joueur_acc_prenom."</td>\n";

				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_sexe."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_nom."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_prenom."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_date_naissance."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_taille_polo."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_adresse_1."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_adresse_2."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_code_postal."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_ville."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_pays."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_email."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_mobile."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_telephone."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_societe."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_langue."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$joueur_datetime_creation."</td>\n";
			$contenu_excel .= "</tr>\n";

		}

	}

$contenu_excel .= "</table>\n";

$contenu_excel .= "\n</body>\n";
$contenu_excel .= "</html>\n";

/*********************************************************************************************************************/

if(!isset($archive)){

	$fichier_excel = 'Export_joueurs_'.date('Y-m-d').'.xls';
	$path_temp = '../../../temp/';
	$path_temp_fichier_excel = $path_temp.$fichier_excel;

	$fichier_extraction = fopen($path_temp_fichier_excel, 'w+');
	if($fichier_extraction){
		fputs($fichier_extraction, $contenu_excel);		// Ecriture dans le fichier d'extraction
	}else{
		echo 'Impossible de créer le fichier Excel pour l\'exportation de la liste des joueurs.';
	}
	fclose($fichier_extraction);

	// Sortie du document Excel
	header("Content-Type: application/vnd.ms-excel");
	header("Content-Disposition: attachment; filename=$fichier_excel");
	header("Pragma: no-cache");
	header("Expires: 0");
	$document = fopen($path_temp_fichier_excel , 'r');
	fpassthru($document);
	exit;

}else{

	$path_archive_fichier_excel = '../../../archives/archive_'.$annee.'_joueurs.xls';

	$fichier_extraction = fopen($path_archive_fichier_excel, 'w+');
	if($fichier_extraction){
		fputs($fichier_extraction, $contenu_excel);		// Ecriture dans le fichier d'extraction
	}else{
		echo 'Impossible de créer le fichier Excel pour l\'archivage de la liste des joueurs.';
	}
	fclose($fichier_extraction);

	header('Location: ../../competitions/competitions/archiver.php?process=joueurs_equipes');
	exit;

}
?>