<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(11, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Initialisation des tableaux
$tab_roadbook[1] = $tab_roadbook[2] = $tab_roadbook[3] = $tab_roadbook[4] = $tab_roadbook_par = $tab_golf_hcp_coups_recus[1] = $tab_golf_hcp_coups_recus[2] = $tab_golf_hcp_coups_recus[3] = $tab_golf_hcp_coups_recus[4] = array();

// Sélection du roadbook
$requete_roadbook = mysqli_query($connexion_mysql, 'SELECT roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge FROM golfs_roadbook ORDER BY roadbook_golf, roadbook_trou');
$nb_roadbook = mysqli_num_rows($requete_roadbook);
if($nb_roadbook!=0){
	for($roadbook_boucle=0; $roadbook_boucle<$nb_roadbook; $roadbook_boucle++){
		$resultat_roadbook = mysqli_fetch_array($requete_roadbook);
		$roadbook_golf = $resultat_roadbook[0];
		$roadbook_trou = $resultat_roadbook[1];
		$roadbook_par = $resultat_roadbook[2];
		$roadbook_hcp = $resultat_roadbook[3];
		$roadbook_blanche = $resultat_roadbook[4];
		$roadbook_jaune = $resultat_roadbook[5];
		$roadbook_rouge = $resultat_roadbook[6];

		array_push($tab_golf_hcp_coups_recus[$roadbook_golf], $roadbook_hcp);

		array_push($tab_roadbook[$roadbook_golf], array($roadbook_trou, $roadbook_par, $roadbook_hcp, $roadbook_blanche, $roadbook_jaune, $roadbook_rouge));
	}

	for($num_golf=0; $num_golf<=3; $num_golf++){

		$golf_numero = $num_golf + 1;

		// Cacul de la somme des PAR pour le parcours aller
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou<=9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_aller = $resultat_roadbook_par[0];

		// Cacul de la somme des PAR pour le parcours retour
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou>9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_retour = $resultat_roadbook_par[0];

		// Cacul du total des PAR (aller + retour)
		$roadbook_golf_par_total = $roadbook_golf_par_aller + $roadbook_golf_par_retour;

		array_push($tab_roadbook_par, array($golf_numero, $roadbook_golf_par_retour, $roadbook_golf_par_aller, $roadbook_golf_par_total));

	}

}

// Sélection des parcours de golf
$requete_golfs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(roadbook_golf), golf_nom FROM golfs_roadbook A INNER JOIN golfs B ON A.roadbook_golf=B.golf_id ORDER BY roadbook_golf');
$nb_golfs = mysqli_num_rows($requete_golfs);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<link rel="stylesheet" type="text/css" href="<?=$general_path_relatif?>css/cartes_score.css">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1235px;">

	<div id="contenu_3" align="left" style="width: 935px;">

		<div id="titres">
			<span class="titre_1" style="width: 140px;">Roadbooks</span>
			<?php if($nb_golfs!=0 AND count($tab_roadbook)!=0){ ?>
				<span class="ajouter" style="width: 190px; margin-left: 593px;"><a href="./modifier.php">Modifier les roadbooks</a></span>
			<?php }else{ ?>
				<span style="float: left; width: 396px;">&nbsp;</span>
			<?php } ?>
		</div>
		<br clear="all">

		<div id="bloc">

			<?php 
			if($nb_golfs!=0 OR count($tab_roadbook)==0){

				for($golf_boucle=0; $golf_boucle<$nb_golfs; $golf_boucle++){
					$resultat_golf = mysqli_fetch_array($requete_golfs);
					$golf_id = $resultat_golf[0];
					$golf_nom = strtoupper_max($resultat_golf[1]);
			?>

					<div id="formulaire_ligne_intertitre" style="width: 890px; font-size: 14px; color: #9C9A8C;"><b><?=$golf_nom?></b></div>

					<table border="0" id="carte_score">
						<tr>
							<td class="carte_entete_ligne">Trou</td>
							<td class="carte_entete">1</td>
							<td class="carte_entete">2</td>
							<td class="carte_entete">3</td>
							<td class="carte_entete">4</td>
							<td class="carte_entete">5</td>
							<td class="carte_entete">6</td>
							<td class="carte_entete">7</td>
							<td class="carte_entete">8</td>
							<td class="carte_entete">9</td>
							<td class="carte_entete">10</td>
							<td class="carte_entete">11</td>
							<td class="carte_entete">12</td>
							<td class="carte_entete">13</td>
							<td class="carte_entete">14</td>
							<td class="carte_entete">15</td>
							<td class="carte_entete">16</td>
							<td class="carte_entete">17</td>
							<td class="carte_entete">18</td>
							<td class="carte_fin_ligne">Retour</td>
							<td class="carte_fin_ligne">Aller</td>
							<td class="carte_fin_ligne">Total</td>
						</tr>
						<tr>
							<td class="carte_entete_ligne">Par</td>
							<?php foreach($tab_roadbook[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
								<td class="carte_ligne" style="font-weight: bold;"><?=$tab_trou[1]?></td>
							<?php } ?>
							<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($golf_id-1)][1]?></td>
							<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($golf_id-1)][2]?></td>
							<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($golf_id-1)][3]?></td>
						</tr>
						<tr>
							<td class="carte_entete_ligne">Handicap</td>
							<?php foreach($tab_roadbook[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
								<td class="carte_ligne"><?=$tab_trou[2]?></td>
							<?php } ?>
						</tr>
					</table>
					<table border="0" id="carte_score">
						<tr>
							<td class="carte_entete_ligne">Blanches</td>
							<?php foreach($tab_roadbook[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
								<td class="carte_ligne_petit"><?=$tab_trou[3]?></td>
							<?php } ?>
						</tr>
						<tr>
							<td class="carte_entete_ligne">Jaunes</td>
							<?php foreach($tab_roadbook[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
								<td class="carte_ligne_petit"><?=$tab_trou[4]?></td>
							<?php } ?>
						</tr>
						<tr>
							<td class="carte_entete_ligne">Rouges</td>
							<?php foreach($tab_roadbook[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
								<td class="carte_ligne_petit"><?=$tab_trou[5]?></td>
							<?php } ?>
						</tr>
					</table>
					<br clear="all">
			<?php 
				}

			}else{
				echo 'aucun parcours dans le roadbook.'."\n";
			}
			?>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
