<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(10, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Sélection des compétitions enregistrées
$requete_competitions = mysqli_query($connexion_mysql, 'SELECT competition_id, competition_annee, DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), DATE_FORMAT(competition_date_fin, "%d/%m/%Y"), competition_archive, competition_active FROM competitions ORDER BY competition_annee DESC');
$nb_competitions = mysqli_num_rows($requete_competitions);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<script language="Javascript">
	<!-- 
	function supprimer(identifiant, nom){
		resultat = confirm("Désirez-vous réellement supprimer la compétition " + nom + " ?");
		if(resultat == true){
			window.location = './supprimer.php?compet_id=' + identifiant;
		}
	}

	function archiver(identifiant, nom){
		resultat = confirm("Désirez-vous réellement archiver la compétition " + nom + " ?");
		if(resultat == true){
			window.location = './archiver.php?compet_id=' + identifiant + '&compet_annee=' + nom;
		}
	}
	//-->
</script>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 630px;">

		<div id="titres">
			<span class="titre_1" style="width: 281px;">Compétitions</span>
			<span class="ajouter" style="width: 200px; margin-right: 30px;"><a href="./modifier_parametres.php">Modifier les paramètres</a></span>
			<span class="ajouter"><a href="./ajouter.php">Ajouter</a></span>
		</div>
		<br clear="all">

		<?php 
		if($nb_competitions==1){
			echo '<div id="ligne_compteur"><b>1</b> compétition sélectionnée</div>';
		}elseif($nb_competitions>1){
			echo '<div id="ligne_compteur"><b>'.$nb_competitions.'</b> compétitions sélectionnées</div>';
		}
		?>

		<div id="bloc">

			<?php if($nb_competitions!=0){ ?>

				<div id="ligne_entete">
					<div style="float: left; width: 250px;" title="Année">NOM & ANNÉE</div>
					<div align="center" style="float: left; width: 100px; border-left: 1px solid #CCCCCC;" title="Date de début">DATE DE DÉBUT</div>
					<div align="center" style="float: left; width: 100px; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" title="Date de fin">DATE DE FIN</div>
				</div>

			<?php 
				for($competition_boucle=0; $competition_boucle<$nb_competitions; $competition_boucle++){
					$resultat_competition = mysqli_fetch_array($requete_competitions);
					$compet_id = $resultat_competition[0];
					$competition_annee = $resultat_competition[1];
					$competition_date_debut = $resultat_competition[2];
					$competition_date_fin = $resultat_competition[3];
					$competition_archive = $resultat_competition[4];
					$competition_active = $resultat_competition[5];

					if($competition_active==1){ $competition_ligne_css = 'ligne'; }else{ $competition_ligne_css = 'ligne_inactive'; }
			?>

					<div id="<?=$competition_ligne_css?>">
						<?php if($competition_archive==1){ ?>
							<div style="float: left; width: 250px;" title="Compétition">Duos Du Golf d'Agadir<b><?=$competition_annee?></b></div>
						<?php }else{ ?>
							<div style="float: left; width: 250px;" title="Compétition"><a href="./modifier.php?compet_id=<?=$compet_id?>">Duos Du Golf d'Agadir <b><?=$competition_annee?></b></a></div>
						<?php } ?>
						<div align="center" style="float: left; width: 100px; border-left: 1px solid #CCCCCC;" title="Date de début"><?=$competition_date_debut?></div>
						<div align="center" style="float: left; width: 100px; border-left: 1px solid #CCCCCC;" title="Date de fin"><?=$competition_date_fin?></div>
						<?php if($competition_archive==1){ ?>
							<div align="center" style="float: left; width: 161px; margin-right: 5px; border-left: 1px solid #CCCCCC;" title="Archivée"><i>compétition archivée</i></div>
						<?php }else{ ?>
							<div align="center" style="float: left; width: 100px; margin-right: 5px; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" title="Archiver"><a href="Javascript:void(0);" onclick="archiver('<?=$compet_id?>', '<?=addslashes($competition_annee)?>')" title="Archiver">archiver</a></div>
							<div id="ligne_icone"><a href="./modifier.php?compet_id=<?=$compet_id?>" title="Modifier"><img src="<?=$admin_img?>picto_modifier.png" width="10" height="10"></a></div>
							<div id="ligne_icone"><a href="Javascript:void(0);" onclick="supprimer('<?=$compet_id?>', '<?=addslashes($competition_annee)?>')" title="Supprimer"><img src="<?=$admin_img?>picto_supprimer.png" width="10" height="10"></a></div>
						<?php } ?>
					</div>
					<?php if($competition_archive==1){ ?>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Liste des joueurs (XLS)"><a href="../../../archives/archive_<?=$competition_annee?>_joueurs.xls" target="_blank">Liste des joueurs (XLS)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Liste des joueurs (PDF)"><a href="../../../archives/archive_<?=$competition_annee?>_joueurs_equipes.pdf" target="_blank">Liste des joueurs (PDF)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Liste des équipes (XLS)"><a href="../../../archives/archive_<?=$competition_annee?>_equipes.xls" target="_blank">Liste des équipes (XLS)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Liste des équipes (XLS)"><a href="../../../archives/archive_<?=$competition_annee?>_facturation.xls" target="_blank">Facturation (XLS)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Liste des équipes (XLS)"><a href="../../../archives/archive_<?=$competition_annee?>_factures.pdf" target="_blank">Factures (PDF)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Planning (PDF)"><a href="../../../archives/archive_<?=$competition_annee?>_planning.pdf" target="_blank">Planning (PDF)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Cartes de score (PDF)"><a href="../../../archives/archive_<?=$competition_annee?>_cartes_score.pdf" target="_blank">Cartes de score (PDF)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Classement cumulé brut & net (PDF)"><a href="../../../archives/archive_<?=$competition_annee?>_classement_cumule_brut_net.pdf" target="_blank">Classement cumulé brut & net (PDF)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Classement cumulé pro (PDF)"><a href="../../../archives/archive_<?=$competition_annee?>_classement_cumule_pro.pdf" target="_blank">Classement cumulé pro (PDF)</a></div>
						</div>
						<div id="ligne" style="margin-left: 50px;">
							<div style="width: 500px;" title="Base de données (SQL)"><a href="../../../archives/archive_<?=$competition_annee?>_base_de_donnees.sql" target="_blank">Base de données (SQL)</a></div>
						</div>
					<?php } ?>

			<?php 
				}
			}else{
				echo '<div id="ligne">aucue compétition disponible</div>'."\n";
			}
			?>

		</div>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
