<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(3, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='rechercher'){

	$requete_where = 'WHERE joueur_id<>""';
	$export_parametres = '';

	if(strlen(trim($recherche_motcle))!=0){
		$recherche_motcle = htmlentities($recherche_motcle, ENT_QUOTES);
		$requete_where .= ' AND (joueur_id LIKE "%'.$recherche_motcle.'%" OR joueur_nom LIKE "%'.$recherche_motcle.'%" OR joueur_prenom LIKE "%'.$recherche_motcle.'%")';
		$export_parametres .= 'export_joueur_motcle='.$recherche_motcle.'&';
	}

	if($recherche_equipe!='0'){
		$requete_where .= ' AND joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$recherche_equipe.'")';
		$export_parametres .= 'export_equipe='.$recherche_equipe.'&';
	}

	if((isset($critere_actif) AND $critere_actif==1) OR (isset($critere_inactif) AND $critere_inactif==1)){
		$requete_where .= ' AND (';
		if(isset($critere_actif) AND $critere_actif==1){
			$requete_where .= 'joueur_actif="1" OR ';
			$export_parametres .= 'export_joueur_actif=1&';
		}
		if(isset($critere_inactif) AND $critere_inactif==1){
			$requete_where .= 'joueur_actif="0" OR ';
			$export_parametres .= 'export_joueur_inactif=1&';
		}
		$requete_where = substr($requete_where, 0, -4).')';
	}

	if(isset($critere_langues) AND count($critere_langues)!=0){
		$requete_where .= ' AND (';
		foreach($critere_langues as $critere_langue){
			$requete_where .= 'joueur_langue="'.$critere_langue.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
		$export_parametres .= 'export_joueur_langues='.implode('|', $critere_langues).'&';
	}

	if($critere_equipe=='avec'){
		$requete_where .= ' AND joueur_id IN (SELECT ej_joueur FROM equipes_joueurs)';
	}elseif($critere_equipe=='sans'){
		$requete_where .= ' AND joueur_id NOT IN (SELECT ej_joueur FROM equipes_joueurs)';
	}
	$export_parametres .= 'export_joueur_equipe='.$critere_equipe.'&';

	if(isset($critere_profils) AND count($critere_profils)!=0){
		$requete_where .= ' AND (';
		foreach($critere_profils as $critere_profil){
			$requete_where .= 'joueur_profil="'.$critere_profil.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
		$export_parametres .= 'export_joueur_profils='.implode('|', $critere_profils).'&';
	}

	if($classement=='nom'){
		$requete_orderby = 'joueur_nom '.$ordre.', joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='profil'){
		$requete_orderby = 'joueur_profil '.$ordre.', joueur_nom, joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='equipe'){
		$requete_orderby = '(SELECT equipe_nom FROM equipes A INNER JOIN equipes_joueurs B ON A.equipe_id=B.ej_equipe WHERE B.ej_joueur=joueur_id) '.$ordre.', joueur_profil DESC, joueur_nom, joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='date'){
		$requete_orderby = 'joueur_datetime_creation '.$ordre.', joueur_nom, joueur_prenom';
	}elseif($classement=='statut'){
		$requete_orderby = 'joueur_actif '.$ordre.', joueur_nom, joueur_prenom';
	}
	$export_parametres .= 'classement='.$classement.'&ordre='.$ordre.'&';

	if(strlen(trim($export_parametres))!=0){
		$export_parametres = '?'.substr($export_parametres, 0, -1);
	}

}else{

	$requete_where = 'WHERE joueur_id<>""';
	$requete_orderby = 'joueur_nom ASC, joueur_prenom';

	$export_parametres = '?classement=nom&ordre=ASC';

}

// Sélection des joueurs enregistrés
$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_profil, joueur_handicap, joueur_handicap_validation, joueur_nom, joueur_prenom, joueur_langue, DATE_FORMAT(joueur_confirmation_envoyee, "%d/%m/%Y à %Hh%i"), DATE_FORMAT(joueur_datetime_creation, "%d/%m/%y %H:%i"), joueur_admin, joueur_actif FROM joueurs '.$requete_where.' ORDER BY '.$requete_orderby);
$nb_joueurs = mysqli_num_rows($requete_joueurs);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<script language="Javascript">
	<!-- 
	function supprimer(identifiant, profil, nom){
		resultat = confirm("Désirez-vous réellement supprimer le joueur ' " + nom + " ' ?");
		if(resultat == true){
			window.location = './supprimer.php?joueur_id=' + identifiant + '&joueur_profil=' + profil;
		}
	}
	//-->
</script>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1200px;">

	<div id="contenu_3" align="left" style="width: 900px;">

		<div id="titres">
			<span class="titre_1" style="width: 504px;">Joueurs</span>
			<?php if($nb_joueurs!=0){ ?>
				<span class="ajouter" style="width: 130px; margin-right: 20px;"><a href="./valider_hdcp.php">Valider HDCP</a></span>
				<span class="ajouter" style="width: 100px; margin-right: 20px;"><a href="./exporter.php<?=$export_parametres?>">Exporter</a></span>
			<?php }else{ ?>
				<span style="float: left; width: 262px;">&nbsp;</span>
			<?php } ?>
			<span class="ajouter" style="width: 90px;"><a href="./ajouter.php">Ajouter</a></span>
		</div>
		<br clear="all">

		<?php 
		if($nb_joueurs==1){
			echo '<div id="ligne_compteur"><b>1</b> joueur sélectionné</div>';
		}elseif($nb_joueurs>1){
			echo '<div id="ligne_compteur"><b>'.$nb_joueurs.'</b> joueurs sélectionnés</div>';
		}
		?>

		<div id="bloc">

			<?php if($nb_joueurs!=0){ ?>

				<div id="ligne_entete">
					<div style="float: left; width: 230px;" title="Nom Prénom">NOM & PRÉNOM</div>
					<div style="float: left; width: 120px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Profil">PROFIL</div>
					<div align="center" style="float: left; width: 60px; border-left: 1px solid #CCCCCC;" title="Handicap joueur">HDCP</div>
					<div style="float: left; width: 150px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Equipe">NOM DE L'ÉQUIPE</div>
					<div align="center" style="float: left; width: 45px; border-left: 1px solid #CCCCCC;" title="Langue">LNG</div>
					<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Envoi par e-mail">ENVOI MAIL</div>
					<div align="center" style="float: left; width: 120px; border-left: 1px solid #CCCCCC;" title="Date / Heure de création">DATE DE CRÉATION</div>
				</div>

			<?php 
				for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
					$resultat_joueur = mysqli_fetch_array($requete_joueurs);
					$joueur_id = $resultat_joueur[0];
					$joueur_profil_brut = $resultat_joueur[1];
					$joueur_handicap = $resultat_joueur[2];
					$joueur_handicap_validation = $resultat_joueur[3];
					$joueur_nom = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[4]))));
					$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[5])));
					$joueur_langue = strtoupper($resultat_joueur[6]);
					$joueur_confirmation_envoyee = $resultat_joueur[7];
					$joueur_datetime_creation = $resultat_joueur[8];
					$joueur_admin = $resultat_joueur[9];
					$joueur_actif = $resultat_joueur[10];

					if($joueur_profil_brut=='pro'){ $joueur_profil = 'Professionnel'; }elseif($joueur_profil_brut=='am'){ $joueur_profil = 'Amateur'; }else{ $joueur_profil = 'Accompagnateur'; }

					if($joueur_profil_brut=='am'){
						if($joueur_handicap==NULL){
							$joueur_handicap = 0;
						}elseif(substr($joueur_handicap, -2)!='.0'){
							$joueur_handicap = number_format($joueur_handicap, 1, ',', '');
						}elseif(substr($joueur_handicap, -2)=='.0'){
							$joueur_handicap = number_format($joueur_handicap, 0);
						}
					}else{
						$joueur_handicap = '-';
					}

					if($joueur_admin==1){ $joueur_admin_libelle = ' (admin)'; }else{ $joueur_admin_libelle = ''; }

					if($joueur_profil_brut!='acc' AND $joueur_handicap!='-' AND $joueur_handicap_validation==0){ $joueur_handicap_css = ' color: orange;'; }else{ $joueur_handicap_css = ''; }
					if($joueur_actif==1){ $joueur_ligne_css = 'ligne'; }else{ $joueur_ligne_css = 'ligne_inactive'; }


					// Sélection l'équipe du joueur
					$requete_equipe = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes_joueurs A INNER JOIN equipes B ON A.ej_equipe=B.equipe_id WHERE ej_joueur="'.$joueur_id.'"');
					$nb_equipe = mysqli_num_rows($requete_equipe);
					if($nb_equipe!=0){
						$resultat_equipe = mysqli_fetch_array($requete_equipe);
						$equipe_id = $resultat_equipe[0];
						$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[1])));
					}else{
						$equipe_id = 0;
						$equipe_nom = '-';
					}

					if($joueur_profil_brut=='pro'){
						// Vérification du nombre de joueurs dans l'équipe du joueur sélectionné
						$requete_verif_equipe = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs WHERE ej_equipe="'.$equipe_id.'"');
						$nb_verif_equipe = mysqli_num_rows($requete_verif_equipe);
					}
			?>

					<div id="<?=$joueur_ligne_css?>">
						<div style="float: left; width: 230px;" title="Nom Prénom"><a href="./modifier.php?joueur_id=<?=$joueur_id?>"><?=$joueur_nom.' '.$joueur_prenom?></a></div>
						<div style="float: left; width: 120px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Profil"><a href="./modifier.php?joueur_id=<?=$joueur_id?>"><?=$joueur_profil?></a></div>
						<div align="center" style="float: left; width: 60px; border-left: 1px solid #CCCCCC;<?=$joueur_handicap_css?>" title="Handicap joueur"><?=$joueur_handicap?></div>
						<div style="float: left; width: 150px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Equipe"><?=$equipe_nom?></div>
						<div align="center" style="float: left; width: 45px; border-left: 1px solid #CCCCCC;" title="Langue"><?=$joueur_langue?></div>
						<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;"><a href="./envoyer_confirmation.php?joueur_id=<?=$joueur_id?>" style="font-size: 10px; color: <?php if($joueur_confirmation_envoyee!='00/00/0000 à 00h00'){ echo '#5CB341; font-weight: bold;'; }else{ echo '#777777'; } ?>"><?php if($joueur_confirmation_envoyee!='00/00/0000 à 00h00'){ echo '<span title="Confirmation envoyée le '.$joueur_confirmation_envoyee.'">ENVOYÉE</span>'; }else{ echo '<span title="Envoyez la confirmation par e-mail">ENVOYEZ</span>'; } ?></a></div>
						<div align="center" style="float: left; width: 120px; border-left: 1px solid #CCCCCC;" title="Date / Heure de création<?=$joueur_admin_libelle?>"><?=$joueur_datetime_creation?></div>
						<div id="ligne_icone"><a href="./modifier.php?joueur_id=<?=$joueur_id?>" title="Modifier"><img src="<?=$admin_img?>picto_modifier.png" width="10" height="10"></a></div>
						<?php if($joueur_profil_brut!='pro' OR ($joueur_profil_brut=='pro' AND $nb_verif_equipe<=1)){ ?>
							<div id="ligne_icone"><a href="Javascript:void(0);" onclick="supprimer('<?=$joueur_id?>', '<?=$joueur_profil_brut?>', '<?=$joueur_prenom?> <?=$joueur_nom?>')" title="Supprimer"><img src="<?=$admin_img?>picto_supprimer.png" width="10" height="10"></a></div>
						<?php }else{ ?>
							<div id="ligne_icone"><img src="<?=$admin_img?>picto_supprimer_off.png" width="10" height="10" title="Pour supprimer ce joueur professionnel, veuillez avant supprimer les autres joueurs de l'équipe."></div>
						<?php } ?>
					</div>

			<?php 
				}
			}else{
				if(isset($action) AND $action=='rechercher'){
					echo '<div id="ligne">aucun joueur correspond à votre recherche</div>'."\n";
				}else{
					echo '<div id="ligne">aucun joueur enregistré</div>'."\n";
				}
			}
			?>

		</div>

	</div>

	<div id="contenu_secondaire">

		<form action="<?=$PHP_SELF?>" method="post">

			<input type="hidden" name="action" value="rechercher">

			<div class="titre">rechercher</div>

			<input type="text" name="recherche_motcle" value="<?php if(isset($recherche_motcle)){ echo $recherche_motcle; } ?>" class="input" style="width: 156px;"><br>

			<div class="titre">sélectionner une équipe</div>

			<select name="recherche_equipe" size="1" class="select" style="width: 170px;">
				<option value="0">-</option>
				<?php 
				// Sélection des équipes enregistrées
				$requete_recherche_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes ORDER BY equipe_nom');
				$nb_recherche_equipes = mysqli_num_rows($requete_recherche_equipes);
				if($nb_recherche_equipes!=0){
					for($equipe_recherche_boucle=0; $equipe_recherche_boucle<$nb_recherche_equipes; $equipe_recherche_boucle++){
						$resultat_recherche_equipe = mysqli_fetch_array($requete_recherche_equipes);
						$recherche_equipe_id = $resultat_recherche_equipe[0];
						$recherche_equipe_nom = $resultat_recherche_equipe[1];

						if($recherche_equipe_id==$recherche_equipe){ $recherche_equipe_selection = ' selected'; }else{ $recherche_equipe_selection = ''; }

						echo '<option value="'.$recherche_equipe_id.'"'.$recherche_equipe_selection.'>'.$recherche_equipe_nom.'</option>'."\n";
					}
				}
				?>
			</select>

			<div class="titre">afficher les joueurs</div>

			<input type="checkbox" id="affichage_critere_actif" name="critere_actif" value="1" <?php if((isset($critere_actif) AND $critere_actif==1) OR !isset($action)){ echo 'checked'; } ?>> <label for="affichage_critere_actif">Actif</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
			<input type="checkbox" id="affichage_critere_inactif" name="critere_inactif" value="1" <?php if((isset($critere_inactif) AND $critere_inactif==1) OR !isset($action)){ echo 'checked'; } ?>> <label for="affichage_critere_inactif">Inactif</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 10px 0px;"><br>

			<input type="checkbox" id="affichage_langue_FR" name="critere_langues[]" value="FR" <?php if((isset($critere_langues) AND in_array('FR', $critere_langues)==true) OR !isset($action)){ echo 'checked'; } ?>> <label for="affichage_langue_FR">FR</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
			<input type="checkbox" id="affichage_langue_EN" name="critere_langues[]" value="EN" <?php if((isset($critere_langues) AND in_array('EN', $critere_langues)==true) OR !isset($action)){ echo 'checked'; } ?>> <label for="affichage_langue_EN">EN</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 10px 0px;"><br>

			<input type="radio" id="affichage_ensemble_equipe" name="critere_equipe" value="ensemble" <?php if((isset($critere_equipe) AND $critere_equipe=='ensemble') OR !isset($critere_equipe)){ echo 'checked'; } ?>> <label for="affichage_ensemble_equipe">avec / sans équipe</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="affichage_avec_equipe" name="critere_equipe" value="avec" <?php if(isset($critere_equipe) AND $critere_equipe=='avec'){ echo 'checked'; } ?>> <label for="affichage_avec_equipe">avec équipe</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="affichage_sans_equipe" name="critere_equipe" value="sans" <?php if(isset($critere_equipe) AND $critere_equipe=='sans'){ echo 'checked'; } ?>> <label for="affichage_sans_equipe">sans équipe</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 10px 0px;"><br>

			<input type="checkbox" id="affichage_profils_professionnels" name="critere_profils[]" value="pro" <?php if((isset($critere_profils) AND in_array('pro', $critere_profils)==true) OR !isset($critere_profils)){ echo 'checked'; } ?>> <label for="affichage_profils_professionnels">Professionnels</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="checkbox" id="affichage_profils_amateurs" name="critere_profils[]" value="am" <?php if((isset($critere_profils) AND in_array('am', $critere_profils)==true) OR !isset($critere_profils)){ echo 'checked'; } ?>> <label for="affichage_profils_amateurs">Amateurs</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="checkbox" id="affichage_profils_accompagnateurs" name="critere_profils[]" value="acc" <?php if((isset($critere_profils) AND in_array('acc', $critere_profils)==true) OR !isset($critere_profils)){ echo 'checked'; } ?>> <label for="affichage_profils_accompagnateurs">Accompagnateurs</label><br>

			<div class="titre">classer les résultats</div>

			<input type="radio" id="classement_nom" name="classement" value="nom" <?php if((isset($classement) AND $classement=='nom') OR !isset($classement)){ echo 'checked'; } ?>> <label for="classement_nom">par nom / prénom</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_profil" name="classement" value="profil" <?php if(isset($classement) AND $classement=='profil'){ echo 'checked'; } ?>> <label for="classement_profil">par profil</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_equipe" name="classement" value="equipe" <?php if(isset($classement) AND $classement=='equipe'){ echo 'checked'; } ?>> <label for="classement_equipe">par équipe</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_date" name="classement" value="date" <?php if(isset($classement) AND $classement=='date'){ echo 'checked'; } ?>> <label for="classement_date">par date</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_statut" name="classement" value="statut" <?php if(isset($classement) AND $classement=='statut'){ echo 'checked'; } ?>> <label for="classement_statut">par statut (actif ou inactif)</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 10px 0px;"><br>

			<input type="radio" id="classement_ordre_croissant" name="ordre" value="ASC" <?php if((isset($ordre) AND $ordre=='ASC') OR !isset($ordre)){ echo 'checked'; } ?>> <label for="classement_ordre_croissant">ordre croissant</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_ordre_decroissant" name="ordre" value="DESC" <?php if(isset($ordre) AND $ordre=='DESC'){ echo 'checked'; } ?>> <label for="classement_ordre_decroissant">ordre décroissant</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 20px 0px;"><br>

			<center><input type="submit" value="valider" style="width: 100px;"></center>

		</form>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
