<?php
require_once '../../../../lib/configuration.inc';
require_once '../../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(4, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


define('ESPACE', chr(32));		// Remplace le caractère Espace (&nbsp;)


// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_annee FROM competitions WHERE competition_active=1 AND competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
$nb_competitions = mysqli_num_rows($requete_competition);
if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_annee = $resultat_competition[0];
}else{
	header('Location: ../../../');
}


// Sélection des joueurs enregistrés
$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(joueur_id), joueur_nom, joueur_prenom, joueur_profil, joueur_handicap, equipe_nom, planning_groupe FROM ((joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur) INNER JOIN equipes C ON B.ej_equipe=C.equipe_id) INNER JOIN planning D ON C.equipe_id=D.equipe_id WHERE A.competition_id="'.$competition_id.'" AND joueur_profil<>"acc" ORDER BY joueur_nom, joueur_prenom, joueur_profil DESC');
$nb_joueurs = mysqli_num_rows($requete_joueurs);


/**************************************************************************************************************************************/

class PDF extends FPDF {

	function Header(){

		global $competition_annee;

		$this->Image('./biarritzlogo.png', 8, 8.4, -300);		// Image de l'entête

		$this->SetFont('Arial', 'B', 38);
		$this->SetTextColor(0,0,0);
		$this->Cell(38.5, 15, '', 0, 0, 'L', false);
		$this->Cell(30, 29, $competition_annee, 0, 0, 'L', false);

		$this->SetFont('Arial', '', 20);
		$this->Cell(130, 9, utf8_decode('Joueurs par ordre alphabétique'), 0, 2, 'C', false);
		$this->Cell(130, 8, 'Player\'s listing', 0, 1, 'C', false);

		$this->ln(10);

		$this->SetFont('Arial', 'B', 8);
		$this->Cell(47, 6, 'JOUEUR', 'B', 0, 'L', false);
		$this->Cell(30, 6, utf8_decode('ÉQUIPE'), 'B', 0, 'L', false);
		$this->Cell(16, 6, 'GROUPE', 'B', 0, 'C', false);

		$this->Cell(2, 6, '', 0, 0, 'L', false);
		$this->Cell(1, 6, '', 'L', 0, 'L', false);
		$this->Cell(2, 6, '', 0, 0, 'L', false);

		$this->Cell(47, 6, 'JOUEUR', 'B', 0, 'L', false);
		$this->Cell(30, 6, utf8_decode('ÉQUIPE'), 'B', 0, 'L', false);
		$this->Cell(16, 6, 'GROUPE', 'B', 1, 'C', false);

		$this->Cell(93, 1, '', 0, 0, 'L', false);
		$this->Cell(2, 1, '', 0, 0, 'L', false);
		$this->Cell(1, 1, '', 'L', 0, 'L', false);
		$this->Cell(2, 1, '', 0, 0, 'L', false);
		$this->Cell(93, 1, '', 0, 1, 'L', false);

	}


	function Lignes($requete_joueurs, $nb_joueurs){

		$boucle = 0;

		for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
			$resultat_joueur = mysqli_fetch_array($requete_joueurs);
			$joueur_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))));
			$joueur_prenom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2]))));
			$joueur_profil = $resultat_joueur[3];
			$joueur_handicap = preg_replace('/,0/', '', number_format($resultat_joueur[4], 1, ',', ' '));
			$equipe_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[5]))));
			$planning_groupe = $resultat_joueur[6];

			$joueur_nom_prenom = $joueur_nom.' '.$joueur_prenom;
			if(strlen($joueur_nom_prenom)>19){ $joueur_nom_prenom = substr($joueur_nom_prenom, 0, 19).'.'; }

			if($joueur_profil=='pro'){
				$joueur_nom_prenom .= ESPACE.' (PRO)'; 
			}else{
				$joueur_nom_prenom .= ESPACE.' ('.$joueur_handicap.')'; 
			}

			if($boucle==0){
				$retour_ligne = 0;
				$boucle++;
			}else{
				$retour_ligne = 1;
				$boucle = 0;
			}

			$this->SetFont('Arial', 'B', 8);
			$this->Cell(47, 6, $joueur_nom_prenom, 0, 0, 'L', false);
			$this->SetFont('Arial', 'I', 8);
			$this->Cell(30, 6, $equipe_nom, 0, 0, 'L', false);
			$this->SetFont('Arial', '', 8);
			$this->Cell(16, 6, $planning_groupe, 0, $retour_ligne, 'C', false);

			if($retour_ligne==0){
				$this->Cell(2, 6, '', 0, 0, 'L', false);
				$this->Cell(1, 6, '', 'L', 0, 'L', false);
				$this->Cell(2, 6, '', 0, 0, 'L', false);
			}

		}

	}


	// Pied de page
	function Footer(){

		$this->SetXY(0, -10);													// Positionnement à 0 cm à gauche et à 1,5 cm du bas

		$this->SetFont('Arial', '', 9);
		$this->SetTextColor(0,0,0);
		$this->Cell(205, 4, $this->PageNo().' / {nb}', 0, 1, 'R', false);		// Numéro de page

	}

}

/**************************************************************************************************************************************/

// Instanciation de la classe dérivée
$pdf = new PDF();
$pdf->AliasNbPages();

$pdf->SetMargins(8, 10, 8);
$pdf->AddPage();

$pdf->Lignes($requete_joueurs, $nb_joueurs);

if(isset($archive) AND $archive==1){
	$pdf->Output('../../../archives/archive_'.$competition_annee.'_joueurs_equipes.pdf', 'F');
	header('Location: ../../competitions/competitions/archiver.php?process=equipes&compet_annee='.$competition_annee);
	exit;
}else{
	$pdf->Output('Liste_Joueurs_'.$competition_annee.'.pdf', 'I');
}
?>
