<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(6, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


$tab_score_aleatoire = array(1, 2, 3, 4, 5, 6, 7, 8, 9);


// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_id, competition_date_debut, competition_date_fin, competition_golfs, competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4 FROM competitions WHERE competition_active="1"');
$resultat_competition = mysqli_fetch_array($requete_competition);
$competition_id = $resultat_competition[0];
$competition_date_debut = $resultat_competition[1];
$competition_date_fin = $resultat_competition[2];
$competition_golfs = explode(',', $resultat_competition[3]);
$competition_sponsor[0] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[4])));
$competition_sponsor[1] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[5])));
$competition_sponsor[2] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[6])));
$competition_sponsor[3] = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[7])));


// Initialisation des tableaux
$tab_roadbook[1] = $tab_roadbook[2] = $tab_roadbook[3] = $tab_roadbook[4] = $tab_roadbook_par = $tab_golf_hcp_coups_recus[1] = $tab_golf_hcp_coups_recus[2] = $tab_golf_hcp_coups_recus[3] = $tab_golf_hcp_coups_recus[4] = array();

// Sélection du roadbook
$requete_roadbook = mysqli_query($connexion_mysql, 'SELECT roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge FROM golfs_roadbook ORDER BY roadbook_golf, roadbook_trou');
$nb_roadbook = mysqli_num_rows($requete_roadbook);
if($nb_roadbook!=0){
	for($roadbook_boucle=0; $roadbook_boucle<$nb_roadbook; $roadbook_boucle++){
		$resultat_roadbook = mysqli_fetch_array($requete_roadbook);
		$roadbook_golf = $resultat_roadbook[0];
		$roadbook_trou = $resultat_roadbook[1];
		$roadbook_par = $resultat_roadbook[2];
		$roadbook_hcp = $resultat_roadbook[3];
		$roadbook_blanche = $resultat_roadbook[4];
		$roadbook_jaune = $resultat_roadbook[5];
		$roadbook_rouge = $resultat_roadbook[6];

		array_push($tab_golf_hcp_coups_recus[$roadbook_golf], $roadbook_hcp);

		array_push($tab_roadbook[$roadbook_golf], array($roadbook_trou, $roadbook_par, $roadbook_hcp, $roadbook_blanche, $roadbook_jaune, $roadbook_rouge));
	}

	for($num_golf=0; $num_golf<=3; $num_golf++){

		$golf_numero = $num_golf + 1;

		// Cacul de la somme des PAR pour le parcours aller
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou<=9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_aller = $resultat_roadbook_par[0];

		// Cacul de la somme des PAR pour le parcours retour
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou>9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_retour = $resultat_roadbook_par[0];

		// Cacul du total des PAR (aller + retour)
		$roadbook_golf_par_total = $roadbook_golf_par_aller + $roadbook_golf_par_retour;

		array_push($tab_roadbook_par, array($golf_numero, $roadbook_golf_par_retour, $roadbook_golf_par_aller, $roadbook_golf_par_total));

	}

}


// Sélection des départs
$requete_planning = mysqli_query($connexion_mysql, 'SELECT planning_id, planning_groupe, A.equipe_id, equipe_nom, A.golf_id, golf_nom, DATE_FORMAT(planning_depart_date, "%d/%m/%Y"), DATE_FORMAT(planning_depart_heure, "%kh%i") FROM (planning A INNER JOIN golfs B ON A.golf_id=B.golf_id) INNER JOIN equipes C ON A.equipe_id=C.equipe_id WHERE (planning_depart_date="2014-04-23" OR planning_depart_date="2014-04-24" OR planning_depart_date="2014-04-25" OR planning_depart_date="2014-04-26") ORDER BY planning_depart_date '.$ordre.', planning_depart_heure, planning_groupe, equipe_nom');
$nb_planning = mysqli_num_rows($requete_planning);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<link rel="stylesheet" type="text/css" href="<?=$general_path_relatif?>css/cartes_score.css">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1235px;">

	<div id="contenu_3" align="left" style="width: 935px;">

		<div id="titres">
			<span class="titre_1" style="width: 791px;">Cartes de score</span>
			<?php if(isset($action)){ ?><span class="ajouter" style="width: 130px;"><a href="./exporter.php<?=$export_parametres?>" target="_blank">Exporter (PDF)</a></span><?php } ?>
		</div>
		<br clear="all">

			<?php 
			if($nb_planning==1){
				echo '<div id="ligne_compteur"><b>1</b> carte de score sélectionnée</div>';
			}elseif($nb_planning>1){
				echo '<div id="ligne_compteur"><b>'.$nb_planning.'</b> cartes de score sélectionnées</div>';
			}
			?>

			<div id="bloc">

				<?php 
				if($nb_planning!=0){
					for($planning_boucle=0; $planning_boucle<$nb_planning; $planning_boucle++){
						$resultat_planning = mysqli_fetch_array($requete_planning);
						$planning_id = $resultat_planning[0];
						$planning_groupe = $resultat_planning[1];
						$planning_equipe = $resultat_planning[2];
						$planning_equipe_nom = $resultat_planning[3];
						$planning_golf_id = $resultat_planning[4];
						$planning_golf_nom = strtoupper_max($resultat_planning[5]);
						$planning_depart_date = $resultat_planning[6];
						$planning_depart_heure = $resultat_planning[7];


						$tab_planning_scores_brut = $tab_planning_scores_net = array();


						// Sélection de la carte de score
						$requete_carte = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total FROM scores WHERE competition_id="'.$competition_id.'" AND planning_id='.$planning_id);
						$nb_carte = mysqli_num_rows($requete_carte);
						if($nb_carte!=0){

							$resultat_carte = mysqli_fetch_array($requete_carte);
							$score_joueur_pro_id = $resultat_carte[0];
							$score_joueur_pro_resultats = explode(',', $resultat_carte[1]);
							$score_aller = $resultat_carte[2];
							$score_retour = $resultat_carte[3];
							$score_total = $resultat_carte[4];
							$score_joueur_am1_id = $resultat_carte[5];
							$score_joueur_am1_resultats = explode(',', $resultat_carte[6]);
							$score_joueur_am1_coupsrecus = explode(',', $resultat_carte[7]);
							$score_joueur_am2_id = $resultat_carte[8];
							$score_joueur_am2_resultats = explode(',', $resultat_carte[9]);
							$score_joueur_am2_coupsrecus = explode(',', $resultat_carte[10]);
							$score_joueur_am3_id = $resultat_carte[11];
							$score_joueur_am3_resultats = explode(',', $resultat_carte[12]);
							$score_joueur_am3_coupsrecus = explode(',', $resultat_carte[13]);
							$resultat_brut = explode(',', $resultat_carte[14]);
							$resultat_net = explode(',', $resultat_carte[15]);
							$resultat_brut_retour = $resultat_carte[16];
							$resultat_brut_aller = $resultat_carte[17];
							$resultat_brut_total = $resultat_carte[18];
							$resultat_net_retour = $resultat_carte[19];
							$resultat_net_aller = $resultat_carte[20];
							$resultat_net_total = $resultat_carte[21];

							$score = array($score_joueur_pro_id=>$score_joueur_pro_resultats, $score_joueur_am1_id=>$score_joueur_am1_resultats, $score_joueur_am2_id=>$score_joueur_am2_resultats, $score_joueur_am3_id=>$score_joueur_am3_resultats);

						}else{

							// Suppression des variables pour les résultats
							unset($score);
							unset($score_aller);
							unset($score_retour);
							unset($score_total);
							unset($resultat_brut);
							unset($resultat_net);
							unset($resultat_brut_retour);
							unset($resultat_brut_aller);
							unset($resultat_brut_total);
							unset($resultat_net_retour);
							unset($resultat_net_aller);
							unset($resultat_net_total);

						}


						if($planning_boucle!=0){
							echo '<br>';
						}
				?>

						<div id="formulaire_ligne_intertitre" style="width: 890px; font-size: 14px; color: #9C9A8C;">GROUPE&nbsp; <b><?=$planning_groupe?></b> &nbsp;&nbsp;-&nbsp;&nbsp; &Eacute;QUIPE&nbsp; <b><?=$planning_equipe_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; GOLF DE&nbsp; <b><?=$planning_golf_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; <?=$planning_depart_date?> &nbsp;&agrave;&nbsp; <?=$planning_depart_heure?></div>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne">Trou</td>
								<td class="carte_entete">1</td>
								<td class="carte_entete">2</td>
								<td class="carte_entete">3</td>
								<td class="carte_entete">4</td>
								<td class="carte_entete">5</td>
								<td class="carte_entete">6</td>
								<td class="carte_entete">7</td>
								<td class="carte_entete">8</td>
								<td class="carte_entete">9</td>
								<td class="carte_entete">10</td>
								<td class="carte_entete">11</td>
								<td class="carte_entete">12</td>
								<td class="carte_entete">13</td>
								<td class="carte_entete">14</td>
								<td class="carte_entete">15</td>
								<td class="carte_entete">16</td>
								<td class="carte_entete">17</td>
								<td class="carte_entete">18</td>
								<td class="carte_fin_ligne">Retour</td>
								<td class="carte_fin_ligne">Aller</td>
								<td class="carte_fin_ligne">Total</td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Par</td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne" style="font-weight: bold;"><?=$tab_trou[1]?></td>
								<?php } ?>
								<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][1]?></td>
								<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][2]?></td>
								<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][3]?></td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Handicap</td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne"><?=$tab_trou[2]?></td>
								<?php } ?>
							</tr>
						</table>

						<table border="0" id="carte_score">
							<?php 
							// Sélection des joueurs de l'équipe sélectionnée
							$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$planning_equipe.'") AND joueur_actif="1" AND joueur_profil<>"acc" ORDER BY joueur_profil DESC, joueur_handicap, joueur_nom, joueur_prenom');
							$nb_joueurs = mysqli_num_rows($requete_joueurs);
							if($nb_joueurs!=0){
								for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
									$resultat_joueur = mysqli_fetch_array($requete_joueurs);
									$joueur_id = $resultat_joueur[0];
									$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
									$joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2]))), 0, 1).'.';
									$joueur_profil = $resultat_joueur[3];
									$joueur_handicap = number_format($resultat_joueur[4], 1, '.', '');


									/**************************************************************/
									/***  Calcul et attribution des coups reçus pour le joueur  ***/
									/**************************************************************/
									$tab_joueur_coups_recus = array();
									$joueur_coups_recus = round(($joueur_handicap/4)*3);
									foreach($tab_golf_hcp_coups_recus[$planning_golf_id] as $tab_golf_hcp){
										if($tab_golf_hcp<=$joueur_coups_recus){
											array_push($tab_joueur_coups_recus, 1);
										}else{
											array_push($tab_joueur_coups_recus, 0);
										}
									}


									if($joueur_boucle==0){
										$score_joueur_pro_resultats_aller = $score_joueur_pro_resultats_retour = $score_joueur_pro_resultats_total = 0;
									}

									$score_aleatoire = array();
									for($bscore=0; $bscore<=17; $bscore++){
										$score_aleatoire_cle = array_rand($tab_score_aleatoire);
										array_push($score_aleatoire, $tab_score_aleatoire[$score_aleatoire_cle]);
										if($joueur_boucle==0){
											if($bscore<=8){
												$score_joueur_pro_resultats_aller = $score_joueur_pro_resultats_aller + $tab_score_aleatoire[$score_aleatoire_cle];
											}else{
												$score_joueur_pro_resultats_retour = $score_joueur_pro_resultats_retour + $tab_score_aleatoire[$score_aleatoire_cle];
											}
										}

										array_push($tab_planning_scores_brut, $tab_score_aleatoire[$score_aleatoire_cle]);

										$score_net = $tab_score_aleatoire[$score_aleatoire_cle] - $tab_joueur_coups_recus[$bscore];
										array_push($tab_planning_scores_net, $score_net);
									}
									$score_aleatoire = implode(',', $score_aleatoire);

									if($joueur_boucle==0){
										$joueur_pro_id = $joueur_id;
										$score_pro_resultats = $score_aleatoire;
										$score_joueur_pro_resultats_total = $score_joueur_pro_resultats_aller + $score_joueur_pro_resultats_retour;
									}
									if($joueur_boucle==1){
										$joueur_am1_id = $joueur_id;
										$score_am1_resultats = $score_aleatoire;
										$req_am1_coups_recus = implode(',', $tab_joueur_coups_recus);
									}
									if($joueur_boucle==2){
										$joueur_am2_id = $joueur_id;
										$score_am2_resultats = $score_aleatoire;
										$req_am2_coups_recus = implode(',', $tab_joueur_coups_recus);
									}
									if($joueur_boucle==3){
										$joueur_am3_id = $joueur_id;
										$score_am3_resultats = $score_aleatoire;
										$req_am3_coups_recus = implode(',', $tab_joueur_coups_recus);
									}


									if(substr($joueur_handicap, -2)=='.0'){ $joueur_handicap_libelle = substr($joueur_handicap, 0, -2); }else{ $joueur_handicap_libelle = $joueur_handicap; }
									if($joueur_profil=='am'){ $joueur_handicap_libelle = '<br><span style="font-weight: normal;">('.$joueur_handicap_libelle.')</span>'; }else{ $joueur_handicap_libelle = ''; }
							?>
									<tr>
										<td class="carte_entete_ligne" style="font-size: 10px;"><?=$joueur_nom.' '.$joueur_prenom.$joueur_handicap_libelle?></td>
										<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
											<td class="carte_ligne_resultat"><?php if(isset($score[$joueur_id][$boucle_trou])){ echo $score[$joueur_id][$boucle_trou]; } ?></td>
										<?php } ?>
										<td<?php if($joueur_profil=='am'){ echo ' rowspan="2"'; } ?> class="carte_fin_ligne_resultat"><?php if($joueur_profil!='am' AND isset($score_retour)){ echo $score_retour; }else{ echo '&nbsp;'; } ?></td>
										<td<?php if($joueur_profil=='am'){ echo ' rowspan="2"'; } ?> class="carte_fin_ligne_resultat"><?php if($joueur_profil!='am' AND isset($score_aller)){ echo $score_aller; }else{ echo '&nbsp;'; } ?></td>
										<td<?php if($joueur_profil=='am'){ echo ' rowspan="2"'; } ?> class="carte_fin_ligne_resultat" style="font-weight: bold;"><?php if($joueur_profil!='am' AND isset($score_total)){ echo $score_total; }else{ echo '&nbsp;'; } ?></td>
									</tr>
									<?php if($joueur_profil=='am'){ ?>
										<tr>
											<td class="carte_ligne_coups_recus">coups reçus</td>
											<?php 
											foreach($tab_joueur_coups_recus as $tab_joueur_coup_recu){
												echo '<td class="carte_ligne_petit" style="height: 15px;">'.$tab_joueur_coup_recu.'</td>'."\n";
											}
											?>
										</tr>
							<?php
									} 
								}
							}
							?>
						</table>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne">Brut</td>
								<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
									<td class="carte_ligne_resultat"><?php if(isset($resultat_brut[$boucle_trou])){ echo $resultat_brut[$boucle_trou]; }else{ echo '&nbsp;'; } ?></td>
								<?php } ?>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_brut_retour)){ echo $resultat_brut_retour; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_brut_aller)){ echo $resultat_brut_aller; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><?php if(isset($resultat_brut_total)){ echo $resultat_brut_total; }else{ echo '&nbsp;'; } ?></td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Net</td>
								<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
									<td class="carte_ligne_resultat"><?php if(isset($resultat_net[$boucle_trou])){ echo $resultat_net[$boucle_trou]; } ?></td>
								<?php } ?>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_net_retour)){ echo $resultat_net_retour; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat"><?php if(isset($resultat_net_aller)){ echo $resultat_net_aller; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><?php if(isset($resultat_net_total)){ echo $resultat_net_total; }else{ echo '&nbsp;'; } ?></td>
							</tr>
						</table>

				<?php 
						// Requête d'insertion des résultats
						$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO scores (competition_id, planning_id, equipe_id, score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total) VALUES("'.$competition_id.'", '.$planning_id.', "'.$planning_equipe.'", "'.$joueur_pro_id.'", "'.$score_pro_resultats.'", '.$score_joueur_pro_resultats_aller.', '.$score_joueur_pro_resultats_retour.', '.$score_joueur_pro_resultats_total.', "'.$joueur_am1_id.'", "'.$score_am1_resultats.'", "'.$req_am1_coups_recus.'", "'.$joueur_am2_id.'", "'.$score_am2_resultats.'", "'.$req_am2_coups_recus.'", "'.$joueur_am3_id.'", "'.$score_am3_resultats.'", "'.$req_am3_coups_recus.'", "'.$planning_scores_brut.'", "'.$planning_scores_net.'", 0, 0, 0, 0, 0, 0)');

					}
				?>

			</div>

		<?php } ?>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
