<?php 

/********************************************/
/**  FONCTION DE VERIFICATION DES E-MAILS  **/
/********************************************/
function verification_email($email){

	if(is_array($email)==false){

		$email = trim($email);

		if(preg_match('/@/', $email)==false OR preg_match('/\./', $email)==false){
			$resultat = false;		// E-mail refusé
		}else{
			$resultat = true;		// E-mail accepté
		}

	}else{

		foreach($email as $email_item){
			$email_item = trim($email_item);

			if(preg_match('/@/', $email_item)==false OR preg_match('/\./', $email_item)==false){
				$resultat = false;		// E-mail refusé
				break;
			}else{
				$resultat = true;		// E-mail accepté
			}
		}

	}

	return $resultat;

}


/*******************************************/
/**  FONCTION DE VERIFICATION DES IMAGES  **/
/*******************************************/
function verification_image($type, $poids, $poids_limite){

	$types_autorises = array('image/jpeg', 'image/pjpeg', 'image/gif', 'image/png');		// Extensions autorisées des images

	// Vérification du type-mine de l'image
	if(in_array($type, $types_autorises)==false){
		return false;		// Image refusée
	}else{

		// Vérification du poids de l'image
		if($poids > $poids_limite){
			return false;		// Image refusée
		}else{
			return true;		// Image acceptée
		}

	}
}


/**********************************************/
/**  FONCTION DE VERIFICATION DES DOCUMENTS  **/
/**********************************************/
function verification_document($type, $poids, $poids_limite){

	$types_autorises = array('application/pdf', 'application/zip', 'multipart/x-zip', 'application/x-zip-compressed', 'application/x-rar-compressed', 'application/msword', 'application/vnd.ms-excel', 'application/vnd.ms-powerpoint', 'text/plain', 'text/rtf', 'video/x-ms-wmv');		// Extensions autorisées des documents

	// Vérification du type-mine du document
	if(in_array($type, $types_autorises)==false){
		return false;		// Image refusée
	}else{

		// Vérification du poids du document
		if($poids > $poids_limite){
			return false;		// Document refusé
		}else{
			return true;		// Document accepté
		}

	}
}


/***************************************/
/**  FONCTION VERIFICATION DES DATES  **/
/***************************************/
function verification_date($date){

	$jour = substr($date, 0, 2);
	$slash_1 = substr($date, 2, 1);
	$mois = substr($date, 3, 2);
	$slash_2 = substr($date, 5, 1);
	$annee = substr($date, 6, 4);

	if(strlen(trim($date))==10 AND is_numeric($jour)==true AND $slash_1=='/' AND is_numeric($mois)==true AND $slash_2=='/' AND is_numeric($annee)==true AND checkdate($mois, $jour, $annee)==true){
		$resultat = true;
	}else{
		$resultat = false;
	}

	return $resultat;
}


/*********************************************************/
/**  FONCTION DE CRÉATION DU MOT DE PASSE PERSONNALISÉ  **/
/*********************************************************/
function creation_motdepasse($debug, $nb_caracteres){

	// Tableaux des données
	$lettres_minuscules = array('a','b','c','d','e','f','g','h','i','j','k','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','J','K','L','M','N','P','Q','R','S','T','U','V','W','X','Y','Z','1','2','3','4','5','6','7','8','9');

	// Initialisation des variables
	$tableau_lettres = array();
	$pazword = '';

	/***********************************/
	/**  Traitement des informations  **/
	/***********************************/

	// Vérification du nombre de caractères
	if($nb_caracteres=='-'){
		return 'erreur_1';
	}else{
		// Calcul du nombre de lettres final
		$nb_lettres = $nb_caracteres;
	}

	// Création du tableau des lettres
	if($nb_lettres!=0){

		$lettres = $lettres_minuscules;

		if($debug==1){
			echo '<font color="green"><b>lettres brut :</b></font>&nbsp;&nbsp;';
			echo '<pre>'.print_r($lettres).'</pre><hr>';
		}

		$tableau_lettres_cle = array_rand($lettres, $nb_lettres);

		if(count($tableau_lettres_cle)!=1){
			foreach($tableau_lettres_cle as $tableau_lettres_valeur){
				array_push($tableau_lettres, $lettres[$tableau_lettres_valeur]); 
			}
		}else{
			$tableau_lettres = array($lettres[$tableau_lettres_cle]);
		}

		if($debug==1){
			echo '<font color="green"><b>lettres final :</b></font>&nbsp;&nbsp;';
			echo '<pre>'.print_r($tableau_lettres).'</pre><hr>';
		}
	}

	if($debug==1){
		echo '<font color="red"><b>final :</b></font>&nbsp;&nbsp;';
		echo '<pre>'.print_r($tableau_final).'</pre><hr>';
	}

	// Création du mot de passe à afficher
	if(count($tableau_lettres)!=1){
		shuffle($tableau_lettres);  // Mélange aléatoire du tableau

		if($debug==1){
			echo '<font color="red"><b>final m&eacute;lang&eacute; :</b></font>&nbsp;&nbsp;';
			echo '<pre>'.print_r($tableau_lettres).'</pre><hr>';
		}

		foreach($tableau_lettres as $tableau_lettres_valeur){
			$pazword .= $tableau_lettres_valeur;
		}

	}else{
		$pazword = $tableau_lettres[0];
	}

	return $pazword;
}


/************************************************/
/**  FONCTION D'ENREGISTREMENT DES TELEPHONES  **/
/************************************************/
function enregistrement_telephone($telephone){

	$telephone = trim($telephone);
	$telephone = preg_replace('/ /', '', $telephone);
	$telephone = preg_replace('/\./', '', $telephone);
	$telephone = preg_replace('/-/', '', $telephone);
	$telephone = preg_replace('/\//', '', $telephone);
	$telephone = trim($telephone);

	return $telephone;
}


/***********************************************************/
/**  FONCTION D'ENREGISTREMENT DES MONTANTS EN FORMAT US  **/
/***********************************************************/
function enregistrement_montant($montant){

	$montant = trim($montant);
	$montant = preg_replace('/ /', '', $montant);
	$montant = preg_replace('/,/', '.', $montant);
	$montant = trim($montant);

	$montant = number_format($montant, 2, '.', '');

	return $montant;
}


/******************************************/
/**  FONCTION D'ENREGISTREMENT DES URLS  **/
/******************************************/
function enregistrement_url($url){

	$url = trim($url);

	if(strlen($url)!=0 AND substr($url, 0, 7) != 'http://'){
		$url = strtolower('http://'.$url);
	}

	return $url;
}


/********************************************/
/**  FONCTION DE FORMATAGE DES TELEPHONES  **/
/********************************************/
function formatage_telephone($telephone, $separateur=' '){

	$telephone = trim($telephone);

	if(strlen($telephone)!=0){
		$telephone_final = substr($telephone, 0, 2).$separateur.substr($telephone, 2, 2).$separateur.substr($telephone, 4, 2).$separateur.substr($telephone, 6, 2).$separateur.substr($telephone, 8, 2);
	}

	if(strlen($telephone)==14){
		$telephone_final .= ' / '.substr($telephone, 10, 2).$separateur.substr($telephone, 12, 2);
	}

	return $telephone_final;
}


/**********************************************/
/**  FONCTION DE FORMATAGE DU SIREN / SIRET  **/
/**********************************************/
function formatage_siren_siret($numero, $separateur=' '){

	$numero = trim($numero);

	if(strlen($numero)!=0){
		$numero = preg_replace('/ /', '', $numero);

		$numero_final = substr($numero, 0, 3).$separateur.substr($numero, 3, 3).$separateur.substr($numero, 6, 3);
		if(strlen($numero)==14){ $numero_final .= ' '.substr($numero, 9, 5); }
	}

	return $numero_final;
}


/********************************************************/
/**  FONCTION DE FORMATAGE AU PLURIEL OU AU SINGULIER  **/
/********************************************************/
function formatage_pluriel($libelle, $nombre){

	$libelle = trim($libelle);

	$derniere_lettre = substr(strtolower($libelle), -1);
	$tab_voyelles = array('u');

	if($nombre>1){
		if(in_array($derniere_lettre, $tab_voyelles)==true){
			$libelle .= 'x';
		}else{
			$libelle .= 's';
		}
	}

	return $libelle;
}


/********************************************************/
/**  FONCTION DE FORMATAGE AU PLURIEL OU AU SINGULIER  **/
/********************************************************/
function age($date){

	$age = date('Y') - date('Y', strtotime($date));
	if(date('md') < date('md', strtotime($date))){
		return $age - 1;
	}

	return $age;
}


/********************************************/
/**  FONCTION DE DECODAGE DES APOSTROPHES  **/
/********************************************/
function decodage_apostrophe($chaine){

	$chaine = preg_replace('/&#039;/', "'", $chaine);

	return $chaine;
}


/***************************************/
/**  FONCTION DE TRAITEMENT DES PRIX  **/
/***************************************/
function traitement_prix($prix){

	$prix = preg_replace('/,/', '.', $prix);
	$prix = preg_replace('/ /', '', $prix);

	return $prix;
}


/************************************************************/
/**  FONCTION DE TRADUCTION DES JOURS ANGLAIS EN FRANCAIS  **/
/************************************************************/
function traduction_jour($jour_anglais){

	if($jour_anglais == 'Monday'){
		$jour_francais = 'lundi';
	}elseif($jour_anglais == 'Tuesday'){
		$jour_francais = 'mardi';
	}elseif($jour_anglais == 'Wednesday'){
		$jour_francais = 'mercredi';
	}elseif($jour_anglais == 'Thirsday'){
		$jour_francais = 'jeudi';
	}elseif($jour_anglais == 'Friday'){
		$jour_francais = 'vendredi';
	}elseif($jour_anglais == 'Saturday'){
		$jour_francais = 'samedi';
	}elseif($jour_anglais == 'Sunday'){
		$jour_francais = 'dimanche';
	}

	return $jour_francais;
}


/***********************************************************/
/**  FONCTION DE TRADUCTION DES MOIS ANGLAIS EN FRANCAIS  **/
/***********************************************************/
function traduction_mois($mois_anglais='', $mois_chiffre){

	if($mois_anglais=='January' OR $mois_chiffre==1){
		$mois_francais = 'janvier';
	}elseif($mois_anglais=='February' OR $mois_chiffre==2){
		$mois_francais = 'février';
	}elseif($mois_anglais=='March' OR $mois_chiffre==3){
		$mois_francais = 'mars';
	}elseif($mois_anglais=='April' OR $mois_chiffre==4){
		$mois_francais = 'avril';
	}elseif($mois_anglais=='May' OR $mois_chiffre==5){
		$mois_francais = 'mai';
	}elseif($mois_anglais=='June' OR $mois_chiffre==6){
		$mois_francais = 'juin';
	}elseif($mois_anglais=='July' OR $mois_chiffre==7){
		$mois_francais = 'juillet';
	}elseif($mois_anglais=='August' OR $mois_chiffre==8){
		$mois_francais = 'août';
	}elseif($mois_anglais=='September' OR $mois_chiffre==9){
		$mois_francais = 'septembre';
	}elseif($mois_anglais=='October' OR $mois_chiffre==10){
		$mois_francais = 'octobre';
	}elseif($mois_anglais=='November' OR $mois_chiffre==11){
		$mois_francais = 'novembre';
	}else{
		$mois_francais = 'décembre';
	}

	return $mois_francais;
}


/*******************************************************************/
/**  FONCTION DE TRAITEMENT DES CARATERES ACCENTUES EN MAJUSCULE  **/
/*******************************************************************/
function strtoupper_max($chaine_accentuee){

	$chaine_accentuee = strtoupper(trim($chaine_accentuee));

	$chaine_accentuee = preg_replace('/à/', 'À', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/á/', 'Á', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/â/', 'Â', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ä/', 'Ä', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ç/', 'Ç', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/è/', 'È', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/é/', 'É', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ê/', 'Ê', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ë/', 'Ë', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ï/', 'Ï', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/î/', 'Î', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ô/', 'Ô', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ö/', 'Ö', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ü/', 'Ü', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/û/', 'Û', $chaine_accentuee);

	return $chaine_accentuee;
}


/*******************************************************************/
/**  FONCTION DE TRAITEMENT DES CARATERES ACCENTUES EN MINUSCULE  **/
/*******************************************************************/
function strtolower_max($chaine_accentuee){

	$chaine_accentuee = strtolower(trim($chaine_accentuee));

	$chaine_accentuee = preg_replace('/À/', 'à', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Á/', 'á', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Â/', 'â', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ä/', 'ä', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ç/', 'ç', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/È/', 'è', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/É/', 'é', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ê/', 'ê', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ë/', 'ë', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ï/', 'ï', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Î/', 'î', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ô/', 'ô', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ö/', 'ö', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Ü/', 'ü', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/Û/', 'û', $chaine_accentuee);

	return $chaine_accentuee;
}


/*********************************************************************/
/**  FONCTION DE REMPLACEMENT DES CARATERES ACCENTUES EN MAJUSCULE  **/
/*********************************************************************/
function remplacement_accent($chaine_accentuee){

	$chaine_accentuee = preg_replace('/à/', 'a', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/á/', 'a', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/â/', 'a', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ä/', 'a', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ç/', 'c', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/è/', 'e', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/é/', 'e', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ê/', 'e', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ë/', 'e', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ï/', 'i', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/î/', 'i', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ô/', 'o', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ö/', 'o', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/ü/', 'u', $chaine_accentuee);
	$chaine_accentuee = preg_replace('/û/', 'u', $chaine_accentuee);

	return $chaine_accentuee;
}


/*****************************************************************/
/**  FONCTION DE NETTOYAGE DES CARATERES POUR REECRITURE D'URL  **/
/*****************************************************************/
function nettoyage_chaine_url($chaine){

	$chaine = strtolower_max($chaine);

	$chaine = preg_replace('/#/', '', $chaine);
	$chaine = preg_replace('/%/', '', $chaine);
	$chaine = preg_replace('/&/', '', $chaine);
	$chaine = preg_replace('/£/', '', $chaine);
	$chaine = preg_replace('/§/', '', $chaine);
	$chaine = preg_replace('/@/', '', $chaine);
	$chaine = preg_replace('/²/', '', $chaine);
	$chaine = preg_replace('/³/', '', $chaine);
	$chaine = preg_replace('/°/', '', $chaine);
	$chaine = preg_replace('/«/', '', $chaine);
	$chaine = preg_replace('/»/', '', $chaine);
	$chaine = preg_replace('/\|/', '', $chaine);
	$chaine = preg_replace('/:/', '', $chaine);
	$chaine = preg_replace('/=/', '', $chaine);
	$chaine = preg_replace('/\+/', '', $chaine);
	$chaine = preg_replace('/\*/', '', $chaine);
	$chaine = preg_replace('/\(/', '', $chaine);
	$chaine = preg_replace('/\)/', '', $chaine);
	$chaine = preg_replace('/\./', '', $chaine);

	$chaine = preg_replace('/à/', 'a', $chaine);
	$chaine = preg_replace('/á/', 'a', $chaine);
	$chaine = preg_replace('/â/', 'a', $chaine);
	$chaine = preg_replace('/ä/', 'a', $chaine);
	$chaine = preg_replace('/ç/', 'c', $chaine);
	$chaine = preg_replace('/è/', 'e', $chaine);
	$chaine = preg_replace('/é/', 'e', $chaine);
	$chaine = preg_replace('/ê/', 'e', $chaine);
	$chaine = preg_replace('/ë/', 'e', $chaine);
	$chaine = preg_replace('/ï/', 'i', $chaine);
	$chaine = preg_replace('/î/', 'i', $chaine);
	$chaine = preg_replace('/ô/', 'o', $chaine);
	$chaine = preg_replace('/ö/', 'o', $chaine);
	$chaine = preg_replace('/ü/', 'u', $chaine);
	$chaine = preg_replace('/û/', 'u', $chaine);
	$chaine = preg_replace('/æ/', 'ae', $chaine);

	$chaine = preg_replace('/  /', ' ', trim($chaine));

	$chaine = preg_replace('/ \/ /', '_', $chaine);
	$chaine = preg_replace('/\//', '-', $chaine);
	$chaine = preg_replace('/\'/', '_', $chaine);
	$chaine = preg_replace('/"/', '_', $chaine);
	$chaine = preg_replace('/ /', '_', $chaine);
	$chaine = preg_replace('/__/', '_', $chaine);
	$chaine = preg_replace('/__/', '_', $chaine);

	return $chaine;
}


/*******************************************/
/**  FONCTION DE CHARGEMENT DES FICHIERS  **/
/*******************************************/
function chargement_fichier($action, $chemin_temporaire, $fichier, $chemin_archives, $repertoire, $fichier_ancien=''){

	// Si modification du fichier ou une suppression, alors suppression de l'ancien fichier
	if($action=='modifier' OR $action=='supprimer'){
		if(file_exists($chemin_archives.$repertoire.'/'.$fichier_ancien)==true){
			unlink($chemin_archives.$repertoire.'/'.$fichier_ancien);
		}
	}

	if(strlen(trim($fichier))!=0){

		if($action=='ajouter' AND strlen(trim($fichier_ancien))!=0){

			$tableau_fichier_ancien = explode('.', $fichier_ancien);
			$nb_elements_fichier_ancien = count($tableau_fichier_ancien) - 1;
			$fichier_ancien = preg_replace('/\.'.$tableau_fichier_ancien[$nb_elements_fichier_ancien].'/', '', $fichier_ancien);

			$tableau_fichier = explode('.', $fichier);
			$nb_elements = count($tableau_fichier) - 1;

			$nom = $fichier_ancien.'.'.$tableau_fichier[$nb_elements];

		}elseif($action=='modifier'){
			$nom = $fichier_ancien;
		}else{
			$nom = uniqid('').strtolower(substr($fichier, -4));		// Création du nom du fichier image en conservant le format
		}

		$transfert = move_uploaded_file($chemin_temporaire, $chemin_archives.$repertoire.'/'.$nom);		// Chargement du fichier
		if(!$transfert){ echo "<div style='font-family: verdana; font-size: 12px; color: #FF0000;'><b>Erreur :</b> le transfert du fichier a échoué.</div>"; exit; }

	}else{
		$nom = '';
	}

	return $nom;
}


/**************************************************/
/**  FONCTION DE REDIMENSIONNEMENT DES FICHIERS  **/
/**************************************************/
function redimensionnement_image($image_origine, $image_finale, $chemin_archives, $repertoire, $image_paysage, $image_portrait){

	$image_origine = $chemin_archives.$repertoire.'/'.$image_origine;

	$image_origine_tab = getimagesize($image_origine);
	$image_origine_largeur = $image_origine_tab[0];
	$image_origine_hauteur = $image_origine_tab[1];
	$image_origine_tab = pathinfo($image_origine);
	$image_origine_extension = $image_origine_tab['extension'];

	if($image_origine_hauteur>$image_origine_largeur){
		$format = 'portrait';
		$image_finale_largeur = $image_portrait[0];
		$image_finale_hauteur = $image_portrait[1];
		$image_cote_fixe = $image_portrait[2];
	}else{
		$format = 'paysage';
		$image_finale_largeur = $image_paysage[0];
		$image_finale_hauteur = $image_paysage[1];
		$image_cote_fixe = $image_paysage[2];
	}

	// echo 'Infos sur l\'image = '.$image_origine_largeur.' '.$image_origine_hauteur.' '.$image_origine_extension.'<br>';

	$image_finale_temporaire = preg_replace('/.'.$image_origine_extension.'/', '', $image_finale);
	// echo 'Image temporaire = '.$image_finale_temporaire.'<br>';

	$image = new Image($image_origine);
	$image->name($image_finale_temporaire);

	$redimensionnement = 0;

	if($format=='paysage'){

		if(($image_cote_fixe=='largeur' AND $image_origine_largeur>$image_finale_largeur) OR ($image_cote_fixe=='largeur_hauteur' AND $image_origine_largeur>$image_finale_largeur)){
			if($image->width($image_finale_largeur)==false){ $redimensionnement=1; /* echo 'Erreur dans le redimensionnement de la largeur<br>'; */ }else{ $redimensionnement=0; /* echo 'Redimensionnement de la largeur effectué<br>'; */ }
		}

		if(($image_cote_fixe=='hauteur' AND $image_origine_hauteur>$image_finale_hauteur) OR ($image_cote_fixe=='largeur_hauteur' AND $image_origine_hauteur>$image_finale_hauteur)){
			if($image->height($image_finale_hauteur)==false){ $redimensionnement=1; /* echo 'Erreur dans le redimensionnement de la hauteur<br>'; */ }else{ $redimensionnement=0; /* echo 'Redimensionnement de la hauteur effectué<br>'; */ }
		}

	}else{

		if(($image_cote_fixe=='largeur' AND $image_origine_largeur>$image_finale_largeur) OR ($image_cote_fixe=='largeur_hauteur' AND $image_origine_largeur>$image_finale_largeur)){
			if($image->width($image_finale_largeur)==false){ $redimensionnement=1; /* echo 'Erreur dans le redimensionnement de la largeur<br>'; */ }else{ $redimensionnement=0; /* echo 'Redimensionnement de la largeur effectué<br>'; */ }
		}

		if(($image_cote_fixe=='hauteur' AND $image_origine_hauteur>$image_finale_hauteur) OR ($image_cote_fixe=='largeur_hauteur' AND $image_origine_hauteur>$image_finale_hauteur)){
			if($image->height($image_finale_hauteur)==false){ $redimensionnement=1; /* echo 'Erreur dans le redimensionnement de la hauteur<br>'; */ }else{ $redimensionnement=0; /* echo 'Redimensionnement de la hauteur effectué<br>'; */ }
		}

	}

	if($redimensionnement==1){
		$image->save();
	}

	// echo 'Image finale = '.$image_finale.'<br><br><br>';

	return $image_finale;
}


/***********************************/
/**  FONCTION D'ENCODAGE EN UTF8  **/
/***********************************/
function encodage_utf8($chaine){

	$chaine_encodee = '';

	for($boucle=0; $boucle<strlen($chaine); $boucle++){

		$caractere = ord($chaine[$boucle]);

		if($caractere<128){
			$chaine_encodee .= chr($caractere);
		}elseif(($caractere > 128) && ($caractere < 2048)){
			$chaine_encodee .= chr(($caractere >> 6) | 192);
			$chaine_encodee .= chr(($caractere & 63) | 128);
		}else{
			$chaine_encodee .= chr(($caractere >> 12) | 224);
			$chaine_encodee .= chr((($caractere & 6) & 63) | 128);
			$chaine_encodee .= chr(($caractere & 63) | 128);
		}

	}

	return $chaine_encodee;
}


/*******************************************************/
/**  FONCTION DE DETECTION DU TYPE MIME D'UN FICHIER  **/
/*******************************************************/
function mime_content_type_transfert($fichier) {

	$mime_types = array(

		'txt' => 'text/plain',
		'htm' => 'text/html',
		'html' => 'text/html',
		'xml' => 'application/xml',
		'swf' => 'application/x-shockwave-flash',

		// images
		'png' => 'image/png',
		'jpe' => 'image/jpeg',
		'jpeg' => 'image/jpeg',
		'jpg' => 'image/jpeg',
		'gif' => 'image/gif',
		'tiff' => 'image/tiff',
		'tif' => 'image/tiff',

		// archives
		'zip' => 'application/x-zip-compressed',
		'rar' => 'application/x-rar-compressed',

		// audio/video
		'mp3' => 'audio/mpeg',
		'qt' => 'video/quicktime',
		'mov' => 'video/quicktime',

		// adobe
		'pdf' => 'application/pdf',
		'psd' => 'image/vnd.adobe.photoshop',
		'ai' => 'application/postscript',
		'eps' => 'application/postscript',
		'ps' => 'application/postscript',

		// ms office
		'doc' => 'application/msword',
		'rtf' => 'application/rtf',
		'xls' => 'application/vnd.ms-excel',
		'ppt' => 'application/vnd.ms-powerpoint',

		// open office
		'odt' => 'application/vnd.oasis.opendocument.text',
		'ods' => 'application/vnd.oasis.opendocument.spreadsheet'
	);

	$extension = strtolower(array_pop(explode('.', $fichier)));
	if(array_key_exists($extension, $mime_types)){
		return $mime_types[$extension];
	}elseif(function_exists('finfo_open')){
		$finfo = finfo_open(FILEINFO_MIME);
		$mimetype = finfo_file($finfo, $fichier);
		finfo_close($finfo);
		return $mimetype;
	}else{
		return 'application/octet-stream';
	}

}


/*********************************************************************/
/**  FONCTION DE SELECTION DE LA POSITION MAXIMALE D'UN CLASSEMENT  **/
/*********************************************************************/
function position_max($connexion_mysql, $table, $champ, $critere){

	$requete_position_max = mysqli_query($connexion_mysql, 'SELECT MAX('.$champ.') FROM '.$table.' '.$critere);
	$resultat_position_max = mysqli_fetch_array($requete_position_max);
	$position_max = $resultat_position_max[0] + 1;

	return $position_max;
}


/*************************************************************************************/
/**  FONCTION DE CHANGEMENT DE LA POSITION DANS UN CLASSEMENT (MONTER / DESCENDRE)  **/
/*************************************************************************************/
function position_classement($connexion_mysql, $table, $champ_id, $champ_ordre, $critere, $element_id, $position_actuelle, $direction){

	if(strlen(trim($critere))==0){ $where = 'WHERE'; }else{ $where = 'AND'; }

	if($direction=='monter'){
		$position_nouvelle = $position_actuelle - 1;
		$position_element_remplace_actuelle = $position_actuelle - 1;
		$position_element_remplace_nouvelle = $position_actuelle;

		$requete_monter = mysqli_query($connexion_mysql, 'UPDATE '.$table.' SET '.$champ_ordre.'='.$position_element_remplace_nouvelle.' '.$critere.' '.$where.' '.$champ_ordre.'='.$position_element_remplace_actuelle);

		// echo '1. UPDATE '.$table.' SET '.$champ_ordre.'='.$position_element_remplace_nouvelle.' '.$critere.' '.$where.' '.$champ_ordre.'='.$position_element_remplace_actuelle.'<br>';
	}

	if($direction=='descendre'){
		$position_nouvelle = $position_actuelle + 1;
		$position_element_remplace_actuelle = $position_actuelle + 1;
		$position_element_remplace_nouvelle = $position_actuelle;

		$requete_descendre = mysqli_query($connexion_mysql, 'UPDATE '.$table.' SET '.$champ_ordre.'='.$position_element_remplace_nouvelle.' '.$critere.' '.$where.' '.$champ_ordre.'='.$position_element_remplace_actuelle);

		// echo '2. UPDATE '.$table.' SET '.$champ_ordre.'='.$position_element_remplace_nouvelle.' '.$critere.' '.$where.' '.$champ_ordre.'='.$position_element_remplace_actuelle.'<br>';
	}

	$requete_maj = mysqli_query($connexion_mysql, 'UPDATE '.$table.' SET '.$champ_ordre.'='.$position_nouvelle.' WHERE '.$champ_id.'="'.$element_id.'"');

	// echo '3. UPDATE '.$table.' SET '.$champ_ordre.'='.$position_nouvelle.' WHERE '.$champ_id.'="'.$element_id.'"<br><br>';

	return true;
}


/***********************************************/
/**  FONCTION DE MISE A JOUR D'UN CLASSEMENT  **/
/***********************************************/
function mise_a_jour_classement($connexion_mysql, $table, $champ_id, $champ_ordre, $critere){

	// echo '4. SELECT '.$champ_id.' FROM '.$table.' '.$critere.' ORDER BY '.$champ_ordre.'<br>';

	$requete_elements = mysqli_query($connexion_mysql, 'SELECT '.$champ_id.' FROM '.$table.' '.$critere.' ORDER BY '.$champ_ordre);
	$nb_elements = mysqli_num_rows($requete_elements);
	for($element=0; $element<$nb_elements; $element++){
		$resultat_element = mysqli_fetch_array($requete_elements);
		$element_id = $resultat_element[0];
		$element_nouvelle_position = $element + 1;

		// echo '5. UPDATE '.$table.' SET '.$champ_ordre.'='.$element_nouvelle_position.' WHERE '.$champ_id.'='.$element_id.'<br>';

		$requete_maj_classement = mysqli_query($connexion_mysql, 'UPDATE '.$table.' SET '.$champ_ordre.'='.$element_nouvelle_position.' WHERE '.$champ_id.'="'.$element_id.'"');
	}

	return true;
}


/******************************/
/**  FONCTION DE CALENDRIER  **/
/******************************/
function calendrier($month, $year, $links){

	$MonthNames = array(1=>'Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'Decembre');
	$monthname = $MonthNames[$month + 0];

	// Première ligne = mois et année ou link[0]
	$title = array_key_exists(0, $links) ? $links[0] : $monthname.'&nbsp;'.$year;
	echo '<table width="182" border="0" cellpadding="0" cellspacing="0"><tr><td class="agenda_calendrier_titre">'.$title.'</td></tr></table>'."\n";

	echo '<table width="182" border="0" cellpadding="0" cellspacing="0" class="agenda_calendrier">';
	// Seconde lignes = initiales des jours de la semaine
	$DayNames = array('LUN', 'MAR', 'MER', 'JEU', 'VEN', 'SAM', 'DIM');
	echo '<tr>'; foreach($DayNames as $d){ echo '<th>'.$d.'</th>'; } echo "</tr>\n";

	// On regarde si aujourd'hui est dans ce mois pour mettre un style particulier
	if($year==date('Y') AND $month==date('m')){
		$today = date('d');
	}else{
		$today = 0;
	}

	$time = mktime(0, 0, 0, $month, 1, $year);		// timestamp du 1er du mois demandé
	$days_in_month = date('t', $time);					// nombre de jours dans le mois
	$firstday = date('w', $time);								// jour de la semaine du 1er du mois
	if($firstday==0){ $firstday = 7; }						// attention, en php, dimanche = 0

	$daycode = 1;		// ($daycode % 7) va nous indiquer le jour de la semaine.	on commence par le lundi, c'est-à-dire 1.

	echo '<tr>';

	for($daycode; $daycode<$firstday; $daycode++){ echo '<td>&nbsp;</td>'; }		// on met des cases blanches jusqu'à la veille du 1er du mois

	// boucle sur tous les jours du mois :
	for($numday=1; $numday<=$days_in_month; $numday++, $daycode++) {
		// si on en est au lundi (sauf le 1er), on ferme la ligne précédente et on en ouvre une nouvelle
		if($daycode%7 == 1 && $numday != 1) echo "</tr>\n".'<tr>';
		// on ouvre la case (avec un style particulier s'il s'agit d'aujourd'hui)
		echo ($numday == $today ? '<td class="date_aujourdhui">' : '<td class="date_jour">');
		// on affiche le numéro du jour ou le contenu donné par l'utilisateur
		echo (array_key_exists($numday, $links) ? $links[$numday] : $numday);
		echo '</td>';		// on ferme la case
	}

	for( ; $daycode%7 != 1; $daycode++){ echo '<td>&nbsp;</td>'; }		// on met des cases blanches pour completer la dernière semaine si besoin

	echo "</tr>\n";
	echo "</table>\n\n";
}


/***************************/
/**  FONCTION D'ENCODAGE  **/
/***************************/
function encode_e($valeur){

	$symbole = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.';
	$caractere_1 = intval($valeur/64);
	$caractere_2 = $valeur%64;

	return $symbole[$caractere_1].$symbole[$caractere_2];
}


/**************************************************************************/
/**  FONCTION DE SUPPRESSION D'UN RÉPERTOIRE AVEC LES FICHIERS CONTENUS  **/
/**************************************************************************/
function suppression_repertoire($repertoire){

	if(!file_exists($repertoire)){ return true; }
	if(!is_dir($repertoire) || is_link($repertoire)){ return unlink($repertoire); }

	foreach(scandir($repertoire) as $item){
		if($item=='.' || $item=='..') continue;
		if(!suppression_repertoire($repertoire.'/'.$item)){
			chmod($repertoire.'/'.$item, 0777);
			if(!suppression_repertoire($repertoire.'/'.$item)){ return false; }
		}
	}

	return rmdir($repertoire);
}


/********************************************/
/**  FONCTION DE LUMINOSITÉ D'UNE COULEUR  **/
/********************************************/
function luminosite_couleur($couleur, $niveau){

	$couleur = substr($couleur, -6);
	$bgr = explode('x', wordwrap($couleur, 2, 'x', 3));
	$couleur='';
	for($i=0; $i<=2; $i++){
		$bgr[$i] = hexdec($bgr[$i]);
		$bgr[$i] = $bgr[$i] + $niveau;
		if($bgr[$i]<0){ $bgr[$i] = 0; }
		if($bgr[$i]>255){ $bgr[$i] = 255; }
		$couleur .= strtoupper(substr('0'.dechex($bgr[$i]),-2));
	}

	return '#'.$couleur;

}


/****************************************************/
/**  FONCTION DE NETTOYAGE DES CARATERES POUR DEV  **/
/****************************************************/
function nettoyage_chaine_dev($chaine){

	$chaine = preg_replace('/&laquo;/', '', $chaine);
	$chaine = preg_replace('/&raquo;/', '', $chaine);
	$chaine = preg_replace('/&apos;/', ' ', $chaine);
	$chaine = preg_replace('/&rsquo;/', ' ', $chaine);
	$chaine = preg_replace('/&sbquo;/', ' ', $chaine);
	$chaine = preg_replace('/&nbsp;/', ' ', $chaine);
	$chaine = preg_replace('/&gt;/', '>', $chaine);
	$chaine = preg_replace('/&lt;/', '<', $chaine);

	$chaine = preg_replace('/&agrave;/', 'a', $chaine);
	$chaine = preg_replace('/&aacute;/', 'a', $chaine);
	$chaine = preg_replace('/&acirc;/', 'a', $chaine);
	$chaine = preg_replace('/&auml;/', 'a', $chaine);
	$chaine = preg_replace('/&ccedil;/', 'c', $chaine);
	$chaine = preg_replace('/&egrave;/', 'e', $chaine);
	$chaine = preg_replace('/&eacute;/', 'e', $chaine);
	$chaine = preg_replace('/&ecirc;/', 'e', $chaine);
	$chaine = preg_replace('/&euml;/', 'e', $chaine);
	$chaine = preg_replace('/&iuml;/', 'i', $chaine);
	$chaine = preg_replace('/&icirc;/', 'i', $chaine);
	$chaine = preg_replace('/&ocirc;/', 'o', $chaine);
	$chaine = preg_replace('/&ouml;/', 'o', $chaine);
	$chaine = preg_replace('/&ugrave;/', 'u', $chaine);
	$chaine = preg_replace('/&uuml;/', 'u', $chaine);
	$chaine = preg_replace('/&ucirc;/', 'u', $chaine);
	$chaine = preg_replace('/&aelig;/', 'ae', $chaine);

	$chaine = preg_replace('/à/', 'a', $chaine);
	$chaine = preg_replace('/á/', 'a', $chaine);
	$chaine = preg_replace('/â/', 'a', $chaine);
	$chaine = preg_replace('/ä/', 'a', $chaine);
	$chaine = preg_replace('/ç/', 'c', $chaine);
	$chaine = preg_replace('/è/', 'e', $chaine);
	$chaine = preg_replace('/é/', 'e', $chaine);
	$chaine = preg_replace('/ê/', 'e', $chaine);
	$chaine = preg_replace('/ë/', 'e', $chaine);
	$chaine = preg_replace('/ï/', 'i', $chaine);
	$chaine = preg_replace('/î/', 'i', $chaine);
	$chaine = preg_replace('/ô/', 'o', $chaine);
	$chaine = preg_replace('/ö/', 'o', $chaine);
	$chaine = preg_replace('/ù/', 'u', $chaine);
	$chaine = preg_replace('/ü/', 'u', $chaine);
	$chaine = preg_replace('/û/', 'u', $chaine);
	$chaine = preg_replace('/æ/', 'ae', $chaine);

	$chaine = preg_replace('/&Agrave;/', 'A', $chaine);
	$chaine = preg_replace('/&Aacute;/', 'A', $chaine);
	$chaine = preg_replace('/&Acirc;/', 'A', $chaine);
	$chaine = preg_replace('/&Auml;/', 'A', $chaine);
	$chaine = preg_replace('/&Ccedil;/', 'C', $chaine);
	$chaine = preg_replace('/&Egrave;/', 'E', $chaine);
	$chaine = preg_replace('/&Eacute;/', 'E', $chaine);
	$chaine = preg_replace('/&Ecirc;/', 'E', $chaine);
	$chaine = preg_replace('/&Euml;/', 'E', $chaine);
	$chaine = preg_replace('/&Iuml;/', 'I', $chaine);
	$chaine = preg_replace('/&Icirc;/', 'I', $chaine);
	$chaine = preg_replace('/&Ocirc;/', 'O', $chaine);
	$chaine = preg_replace('/&Ouml;/', 'O', $chaine);
	$chaine = preg_replace('/&Ugrave;/', 'U', $chaine);
	$chaine = preg_replace('/&Uuml;/', 'U', $chaine);
	$chaine = preg_replace('/&Ucirc;/', 'U', $chaine);
	$chaine = preg_replace('/&AElig;/', 'AE', $chaine);

	$chaine = preg_replace('/\//', '-', $chaine);
	$chaine = preg_replace('/&#039;/', ' ', $chaine);
	$chaine = preg_replace('/\'/', ' ', $chaine);
	$chaine = preg_replace('/&quot;/', '', $chaine);

	$chaine = trim($chaine);

	return $chaine;
}


/***************************************/
/**  FONCTION D'ENVOI D'UN E-MAILING  **/
/***************************************/
function emailing_envoi($emailing_destinataires_from_email, $emailing_destinataires_to_email, $emailing_destinataires_cc_email, $emailing_destinataires_cci_email, $emailing_sujet, $emailing_titre, $emailing_message, $emailing_masque, $emailing_domaine, $emailing_langue='fr', $fichier_pdf='', $facture_numero=''){

	// Récupération du masque de l'e-mailing
	$emailing_contenu_html_vierge = @join('', @file($emailing_masque));

	// Paramètres pour l'envoi
	$emailing_expediteur_nom = '=?UTF-8?B?'.base64_encode("Pro Am d'Agadir").'?=';
	$emailing_expediteur_email = $emailing_destinataires_from_email;
	$emailing_expediteur_domaine_tab = explode('@', $emailing_expediteur_email);
	$emailing_expediteur_domaine = $emailing_expediteur_domaine_tab[1];
	$emailing_sujet = '=?UTF-8?B?'.base64_encode($emailing_sujet).'?=';

	// Traitement pour insertion du contenu
	$emailing_contenu_html = preg_replace("/{URL}/", $emailing_domaine, $emailing_contenu_html_vierge);
	$emailing_contenu_html = preg_replace("/{TITRE}/", $emailing_titre, $emailing_contenu_html);
	$emailing_contenu_html = preg_replace("/{TEXTE}/", $emailing_message, $emailing_contenu_html);
	$emailing_contenu_html = preg_replace("/{IMG}/", $emailing_domaine.'/commun/', $emailing_contenu_html);
	$emailing_contenu_html = preg_replace("/{LANGUE}/", strtoupper($emailing_langue), $emailing_contenu_html);

	$emailing_frontiere = md5(uniqid(mt_rand()));

	// Construction de l'entête de l'e-mailing
	$emailing_entete  = "MIME-Version: 1.0\r\n";
	$emailing_entete .= "From: ".$emailing_expediteur_nom." <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "Reply-To: <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "Return-Path: <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "Cc: ".$emailing_destinataires_cc_email."\r\n";
	$emailing_entete .= "Cci: ".$emailing_destinataires_cci_email."\r\n";
	$emailing_entete .= "Sender: <".$emailing_expediteur_email.">\r\n";
	$emailing_entete .= "X-Mailer: PHP v".phpversion()."\r\n";
	$emailing_entete .= "X-Sender: ".$emailing_expediteur_email."\r\n";
	$emailing_entete .= "X-auth-smtp-user: ".$emailing_expediteur_email."\r\n";
	$emailing_entete .= "MIME-Version: 1.0\r\n";
	$emailing_entete .= "Content-Type: multipart/mixed; boundary=".$emailing_frontiere."\r\n";
	$emailing_entete .= "X-abuse-contact: abuse@".$emailing_expediteur_domaine;


	$emailing_contenu  = "--".$emailing_frontiere."\r\n";

	$emailing_contenu .= "Content-type: text/html; charset=UTF-8\r\n";
	$emailing_contenu .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
	$emailing_contenu .= $emailing_contenu_html."\r\n\r\n";

	if(strlen(trim($fichier_pdf))!=0){

		$emailing_contenu .= "--".$emailing_frontiere."\r\n";

		$emailing_contenu .= "Content-Type: application/pdf; name=\"Facture_".$facture_numero.".pdf\"\r\n";
		$emailing_contenu .= "Content-Transfer-Encoding: base64\r\n";
		$emailing_contenu .= "Content-Disposition:attachement; filename=\"Facture_".$facture_numero.".pdf\"\r\n\r\n";
		$emailing_contenu .= chunk_split(base64_encode(file_get_contents('../../../temp/'.$fichier_pdf.'.pdf')));

	}

	$emailing_contenu .= "--".$emailing_frontiere."--\r\n";

	$emailing_entete_plus = "-f ".$emailing_expediteur_email;


	// Envoi de l'alerte par e-mail
	if(is_array($emailing_destinataires_to_email)==true){
		foreach($emailing_destinataires_to_email as $emailing_destinataire_to_email){
			mail($emailing_destinataire_to_email, $emailing_sujet, $emailing_contenu, $emailing_entete, $emailing_entete_plus);
		}
	}else{
		mail($emailing_destinataires_to_email, $emailing_sujet, $emailing_contenu, $emailing_entete, $emailing_entete_plus);
	}

}

?>