<?php 
require '../lib/configuration.inc';


$onglet = 'onglet_pro';


/*********************************************************************************************************/

// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_id, competition_date_debut FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
$resultat_competition = mysqli_fetch_array($requete_competition);
$competition_id = $resultat_competition[0];
$competition_date_debut = $resultat_competition[1];

$competition_annee = substr($competition_date_debut, 0, 4);

/*********************************************************************************************************/

$tab_dates = $tab_final = array();
$score_precedent = '';


// Sélection des dates enregistrées
$requete_dates = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_depart_date) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id ORDER BY planning_depart_date');
$nb_dates = mysqli_num_rows($requete_dates);
if($nb_dates!=0){
	for($date_boucle=0; $date_boucle<$nb_dates; $date_boucle++){
		$resultat_date = mysqli_fetch_array($requete_dates);
		$date_competition = $resultat_date[0];

		$tab_date_competition = explode('-', $date_competition);
		$date_competition_libelle = $tab_date_competition[2].'/'.$tab_date_competition[1].'/'.substr($tab_date_competition[0], -2);

		array_push($tab_dates, array($date_competition, $date_competition_libelle));

	}
}


$tab_joueurs_pros_abandonnes = array();
$liste_joueurs_pros_abondonnes = '';

// Sélection des joueurs professionnels qui ont abandonnés
$requete_joueurs_pros_abandonnes = mysqli_query($connexion_mysql, 'SELECT equipe_id FROM scores WHERE score_joueur_pro_abandon=1');
$nb_joueurs_pros_abandonnes = mysqli_num_rows($requete_joueurs_pros_abandonnes);
if($nb_joueurs_pros_abandonnes!=0){
	for($joueur_pro_abandonne_boucle=0; $joueur_pro_abandonne_boucle<$nb_joueurs_pros_abandonnes; $joueur_pro_abandonne_boucle++){
		$resultat_joueur_pro_abandonne = mysqli_fetch_array($requete_joueurs_pros_abandonnes);
		$joueur_pro_abondonne_id = $resultat_joueur_pro_abandonne[0];

		array_push($tab_joueurs_pros_abandonnes, $joueur_pro_abondonne_id);		// Tableau stockant le numéro du classement des joueurs pros

	}
	$tab_joueurs_pros_abandonnes = array_unique($tab_joueurs_pros_abandonnes);
	$liste_joueurs_pros_abondonnes = implode('","', $tab_joueurs_pros_abandonnes);
}


// Traitement spécifique pour le classement des joueurs pros en cas de scores identiques
$requete_scores_nums = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id!=""'.$where.' GROUP BY A.equipe_id ORDER BY SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs C INNER JOIN equipes_joueurs D ON C.joueur_id=D.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');
$nb_scores_nums = mysqli_num_rows($requete_scores_nums);
if($nb_scores_nums!=0){
	$tab_scores = array();

	for($score_num_boucle=0; $score_num_boucle<$nb_scores_nums; $score_num_boucle++){
		$resultat_score_num = mysqli_fetch_array($requete_scores_nums);
		$score_num_joueur_total = $resultat_score_num[1];

		array_push($tab_scores, $score_num_joueur_total);		// Tableau stockant le numéro du classement des joueurs pros

	}
}


/**************************************************************/
/****  SÉLECTION DES JOUEURS PROS N'AYANT PAS ABONNDONNÉS  ****/
/**************************************************************/

// 'SELECT A.equipe_id AS equipe_selection, planning_groupe, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.competition_id="'.$competition_id.'" AND A.equipe_id NOT IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.' GROUP BY A.equipe_id ORDER BY SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")'

// Sélection des joueurs enregistrés
$requete_scores = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, planning_groupe, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id!="" AND A.equipe_id NOT IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.'  GROUP BY A.equipe_id ORDER BY (SELECT SUM(score_joueur_pro_reference) FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE A.equipe_id=equipe_selection AND planning_depart_date<="'.$competition_date_fin.'"), SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');
$nb_scores = mysqli_num_rows($requete_scores);
if($nb_scores!=0){
	for($score_boucle=0; $score_boucle<$nb_scores; $score_boucle++){
		$resultat_score = mysqli_fetch_array($requete_scores);
		$equipe_id = $resultat_score[0];
		$joueur_groupe = $resultat_score[1];
		$score_joueur_total = $resultat_score[2];

		$scores_jours = '';
		$score_reference_total = '';

		if(!isset($score_classement_affichage) OR (isset($score_classement_affichage) AND $score_joueur_total!=$tab_scores[$score_boucle-1])){
			$score_classement_affichage = $score_boucle + 1;
		}


		// Sélection des joueurs de l'équipe
		$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom, joueur_handicap, joueur_profil FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
		$resultat_joueur = mysqli_fetch_array($requete_joueurs);
		$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
		$joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))), 0, 1).'.';

		$joueur_professionnel = $joueur_nom.' '.$joueur_prenom;


		foreach($tab_dates as $date_jour_cle=>$date_jour){

			if($date_jour_cle==0){ $score_precedent = ''; }

			// Sélection des scores journaliers enregistrés
			$requete_score_jour = mysqli_query($connexion_mysql, 'SELECT SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'" AND planning_depart_date<="'.$date_jour[0].'" ORDER BY SUM(score_joueur_pro_resultats_total)');
			$nb_score_jour = mysqli_num_rows($requete_score_jour);
			if($nb_score_jour!=0){
				for($score_jour_boucle=0; $score_jour_boucle<$nb_score_jour; $score_jour_boucle++){
					$resultat_score_jour = mysqli_fetch_array($requete_score_jour);
					$score_jour = $resultat_score_jour[0];

					$requete_score_jour_bis = mysqli_query($connexion_mysql, 'SELECT SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'" AND planning_depart_date="'.$date_jour[0].'" ORDER BY SUM(score_joueur_pro_resultats_total)');
					$resultat_score_jour_bis = mysqli_fetch_array($requete_score_jour_bis);
					$score_jour_bis = $resultat_score_jour_bis[0];

					if($score_jour!=$score_precedent){

						// Sélection du score de référence journalier enregistré pour le joueur
						$requete_score_reference_jour = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_reference FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'" AND planning_depart_date="'.$date_jour[0].'"');
						$resultat_score_reference_jour = mysqli_fetch_array($requete_score_reference_jour);
						$score_reference_jour = $resultat_score_reference_jour[0];

						$scores_jours .= $score_jour.'|'.$score_reference_jour.'|'.$score_jour_bis.',';

						$score_reference_total = $score_reference_total + $score_reference_jour;

					}

					$score_precedent = $score_jour;

				}
			}

		}
		$scores_jours = substr($scores_jours, 0, -1);

		array_push($tab_final, array($score_classement_affichage, $joueur_professionnel, $joueur_groupe, $scores_jours, $score_joueur_total, $score_reference_total));

	}
}


/********************************************************/
/****  SÉLECTION DES JOUEURS PROS AYANT ABONNDONNÉS  ****/
/********************************************************/

// Sélection des joueurs enregistrés
$requete_scores_abandons = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, planning_groupe, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.' GROUP BY A.equipe_id ORDER BY SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');
$nb_scores_abandons = mysqli_num_rows($requete_scores_abandons);
if($nb_scores_abandons!=0){
	for($score_abandon_boucle=0; $score_abandon_boucle<$nb_scores_abandons; $score_abandon_boucle++){
		$resultat_score_abandon = mysqli_fetch_array($requete_scores_abandons);
		$equipe_id = $resultat_score_abandon[0];
		$joueur_groupe = $resultat_score_abandon[1];
		$score_joueur_total = $resultat_score_abandon[2];

		$scores_jours = '';

		$score_classement_affichage = $score_boucle + 1;


		// Sélection des joueurs de l'équipe
		$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom, joueur_handicap, joueur_profil FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
		$resultat_joueur = mysqli_fetch_array($requete_joueurs);
		$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
		$joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))), 0, 1).'.';

		$joueur_professionnel = $joueur_nom.' '.$joueur_prenom;


		foreach($tab_dates as $date_jour_cle=>$date_jour){

			if($date_jour_cle==0){ $score_precedent = ''; }

			// Sélection des scores journaliers enregistrés
			$requete_score_jour = mysqli_query($connexion_mysql, 'SELECT SUM(score_joueur_pro_resultats_total), score_joueur_pro_abandon FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'" AND planning_depart_date<="'.$date_jour[0].'" ORDER BY SUM(score_joueur_pro_resultats_total)');
			$nb_score_jour = mysqli_num_rows($requete_score_jour);
			if($nb_score_jour!=0){
				for($score_jour_boucle=0; $score_jour_boucle<$nb_score_jour; $score_jour_boucle++){
					$resultat_score_jour = mysqli_fetch_array($requete_score_jour);
					$score_jour = $resultat_score_jour[0];
					$score_jour_abandon = $resultat_score_jour[1];

					$requete_score_jour_bis = mysqli_query($connexion_mysql, 'SELECT SUM(score_joueur_pro_resultats_total), score_joueur_pro_abandon FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'" AND planning_depart_date="'.$date_jour[0].'" ORDER BY SUM(score_joueur_pro_resultats_total)');
					$resultat_score_jour_bis = mysqli_fetch_array($requete_score_jour_bis);
					$score_jour_bis = $resultat_score_jour_bis[0];
					$score_jour_abandon = $resultat_score_jour_bis[1];

					if($score_jour_abandon==1){
						$scores_jours .= 'ABD||ABD,';
					}elseif($score_jour!=$score_precedent){

						// Sélection du score de référence journalier enregistré pour le joueur
						$requete_score_reference_jour = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_reference FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'" AND planning_depart_date="'.$date_jour[0].'"');
						$resultat_score_reference_jour = mysqli_fetch_array($requete_score_reference_jour);
						$score_reference_jour = $resultat_score_reference_jour[0];

						$scores_jours .= $score_jour.'|'.$score_reference_jour.'|'.$score_jour_bis.',';

					}

					$score_precedent = $score_jour;

				}
			}

		}
		$scores_jours = substr($scores_jours, 0, -1);

		array_push($tab_final, array($score_classement_affichage, $joueur_professionnel, $joueur_groupe, $scores_jours, 'ABD', ''));

	}
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Pro-Am International de la C&ocirc;te d'Opale</title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
	<style>
		#contenu .onglet_1 { border: 1px solid; padding: 10px 15px 10px 15px; }
		#contenu .onglet_2 { margin: 0px 30px 0px 30px; border: 1px solid; padding: 10px 15px 10px 15px; }
		#contenu .onglet_actif_1 { border: 1px solid; padding: 10px 15px 10px 15px; background-color: #1EA2B7; color: #FFFFFF; }
		#contenu .onglet_actif_2 { margin: 0px 30px 0px 30px; border: 1px solid; padding: 10px 15px 10px 15px; background-color: #1EA2B7; color: #FFFFFF; }
	</style>
	<script language="Javascript">
		function onglet(identifiant){
			if(identifiant=='onglet_brut_cumule'){
				document.getElementById('onglet_brut_cumule').className = 'onglet_actif_1';
				document.getElementById('onglet_net_cumule').className = 'onglet_2';
				document.getElementById('onglet_pro').className = 'onglet_1';
			}else if(identifiant=='onglet_net_cumule'){
				document.getElementById('onglet_brut_cumule').className = 'onglet_1';
				document.getElementById('onglet_net_cumule').className = 'onglet_actif_2';
				document.getElementById('onglet_pro').className = 'onglet_1';
			}else if(identifiant=='onglet_pro'){
				document.getElementById('onglet_brut_cumule').className = 'onglet_1';
				document.getElementById('onglet_net_cumule').className = 'onglet_2';
				document.getElementById('onglet_pro').className = 'onglet_actif_1';
			}
		}
	</script>
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu" style="text-align: center;">

		<div id="logo"><img src="<?=$web_commun?>logo_proamco.jpg" width="219" height="70"></div>
		<div id="titre">CLASSEMENTS <?=$competition_annee?></div>
		<br clear="all">

		<?php 
		// Sélection des sponsors pour le classement de la compétition
		$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_sponsors_classement FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
		$resultat_competition = mysqli_fetch_array($requete_competition);
		$competition_sponsors_classement = explode(',', $resultat_competition[0]);

		if(count($competition_sponsors_classement)!=0){
			foreach($competition_sponsors_classement as $competition_sponsor_cle=>$competition_sponsor_classement){

				// Sélection des sponsors pour le classement
				$requete_sponsors_classement = mysqli_query($connexion_mysql, 'SELECT sponsor_nom, sponsor_logo FROM sponsors WHERE sponsor_actif=1 AND sponsor_id='.$competition_sponsor_classement);
				$nb_sponsors_classement = mysqli_num_rows($requete_sponsors_classement);
				if($nb_sponsors_classement!=0){
					$resultat_sponsor_classement = mysqli_fetch_array($requete_sponsors_classement);
					$sponsor_classement_nom = $resultat_sponsor_classement[0];
					$sponsor_classement_logo = $resultat_sponsor_classement[1];

					if(count($competition_sponsors_classement)!=$competition_sponsor_cle+1){ $sponsor_espace = ' style="margin-right: 30px;"'; }else{ $sponsor_espace = ''; }

					echo '<img src="'.$admin_domaine.'sponsors/'.$sponsor_classement_logo.'" alt="'.$sponsor_classement_nom.'"'.$sponsor_espace.' align="absmiddle">'."\n";

				}

			}
			echo '<br><br>';
		}
		?>

		<div style="margin: 30px 0px 50px 0px;">
			<a id="onglet_brut_cumule" onclick="onglet('onglet_brut_cumule');" href="./brut" class="<?php if($onglet=='onglet_brut_cumule'){ echo 'onglet_actif_1'; }else{ echo 'onglet_1'; } ?>">CLASSEMENT BRUT CUMUL&Eacute;</a>
			<a id="onglet_net_cumule" onclick="onglet('onglet_net_cumule');" href="./net" class="<?php if($onglet=='onglet_net_cumule'){ echo 'onglet_actif_2'; }else{ echo 'onglet_2'; } ?>">CLASSEMENT NET CUMUL&Eacute;</a>
			<a id="onglet_pro" onclick="onglet('onglet_pro');" href="./pro" class="<?php if($onglet=='onglet_pro'){ echo 'onglet_actif_1'; }else{ echo 'onglet_1'; } ?>">CLASSEMENT PRO</a>
		</div>

		<div style="margin-left: 90px; width: 795px; text-align: left;">

			<?php 
			if($nb_scores!=0){

				echo '<div style="float: left; width: 332px;">&nbsp;</div>'."\n";
				for($date_boucle=0; $date_boucle<=3; $date_boucle++){
					if(isset($tab_dates[$date_boucle][1])){
						echo '<div style="float: left; width: 92px; font-weight: bold; text-align: center;">'.$tab_dates[$date_boucle][1].'</div>'."\n";
					}else{
						echo '<div style="float: left; width: 92px;">&nbsp;</div>'."\n";
					}
				}
				echo '<div style="float: left; margin-left: 2px; width: 90px; font-weight: bold; text-align: center;">CUMUL</div>'."\n";
				echo '<br clear="all">'."\n\n";

				echo '<div style="margin-top: 10px; border-bottom : 1px solid #E6E5DA;"></div>'."\n";

				foreach($tab_final as $classement_final_cle=>$classement_final){

					$score_numero = $classement_final[0];
					$joueur_professionnel = $classement_final[1];
					$joueur_groupe = $classement_final[2];
					$tab_scores_jours = explode(',', $classement_final[3]);
					$score_joueur_total = $classement_final[4];
					$score_reference_joueur_total = $classement_final[5];

					$scores_jours = '';
					foreach($tab_scores_jours as $score_jour){
						$tab_score_jour = explode('|', $score_jour);
						if(strlen(trim($tab_score_jour[1]))!=0){ $score_jour_reference = ' &nbsp;<span style="font-weight: normal; font-size: 11px;">('.$tab_score_jour[1].')</span>'; }else{ $score_jour_reference = ''; }
						$scores_jours .= '<div style="float: left; width: 92px; font-weight: bold; text-align: center;">'.$tab_score_jour[2].$score_jour_reference.'</div>'."\n";
					}

					if(strlen(trim($score_reference_joueur_total))!=0){ $score_reference_joueur_total = ' &nbsp;<span style="font-weight: normal; font-size: 11px;">('.$score_reference_joueur_total.')</span>'; }
			?>

					<div style="border-bottom : 1px solid #E6E5DA;">
						<div style="float: left; width: 50px; height: 18px; padding-top: 5px; padding-bottom: 5px; background-color: #EEEEEE; font-size: 16px;" align="center"><b><?=$score_numero?></b></div>
						<div style="float: left; width: 180px; height: 18px; padding-top: 5px; padding-bottom: 5px; padding-left: 10px; border-left: 1px solid #CCCCCC;"><b><?=$joueur_professionnel?></b></div>
						<div align="center" style="float: left; width: 80px; height: 18px; padding-top: 5px; padding-bottom: 5px; border-left: 1px solid #CCCCCC;"><?=$joueur_groupe?></div>
						<div style="float: left; width: 370px; height: 18px; padding-top: 5px; padding-bottom: 5px; padding-left: 10px; border-left: 1px solid #CCCCCC;"><?=$scores_jours?></div>
						<div align="center" style="float: left; width: 85px; height: 18px; padding-top: 5px; padding-bottom: 5px; border-left: 1px solid #CCCCCC; font-size: 16px;"><b><?=$score_joueur_total?></b><?=$score_reference_joueur_total?></div>
						<br clear="all">
					</div>

			<?php 
				}

				echo '<br>';

				echo '<meta http-equiv="refresh" content="60; url='.$PHP_SELF.'">';

			}else{
				echo '<div style="margin-bottom: 500px;">Le classement sera bient&ocirc;t disponible.</span>'."\n";
			}
			?>

		</div>

		<br>

	</div>

</div>

</body>
</html>
