<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(4, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


$contenu_excel  = "<html>\n";
$contenu_excel .= "<head>\n";
	$contenu_excel .= "<meta http-equiv=Content-Type content='text/html; charset=UTF-8'>\n";
	$contenu_excel .= "<style>\n";
		$contenu_excel .= ".tableau_1 { font-family:arial; color:black; font-size:14.0pt; font-weight:700; text-decoration:underline; text-underline-style:single; text-align:left; vertical-align:middle; background:white; }\n";
		$contenu_excel .= ".tableau_2 { font-family:arial; color:black; font-size:12.0pt; font-weight:700; text-underline-style:single; text-align:left; vertical-align:middle; background:white; }\n";
		$contenu_excel .= ".colonnes_titre { font-family:arial; color:black; font-size:10.0pt; font-weight:700; text-underline-style:single; text-align:center; vertical-align:middle; background:white; border: 1px solid black; }\n";
		$contenu_excel .= ".cellules_standard_1 { font-family:arial; color:black; font-size:10.0pt; font-weight:200; text-underline-style:single; text-align:center; vertical-align:middle; background:white; border: 1px solid black; }\n";
		$contenu_excel .= ".cellules_standard_2 { font-family:arial; color:black; font-size:10.0pt; font-weight:200; text-underline-style:single; text-align:left; vertical-align:middle; background:white; border: 1px solid black; }\n";
	$contenu_excel .= "</style>\n";
$contenu_excel .= "</head>\n";
$contenu_excel .= "<body>\n\n";

$contenu_excel .= "<table width=880 border=0 cellpadding=0 cellspacing=0 style='border-collapse: collapse;table-layout:fixed'>\n";
	$contenu_excel .= "<col width=180>\n";				// Colonne du nom de l'équipe
	$contenu_excel .= "<col width=120>\n";				// Colonne du nombre de professionnels
	$contenu_excel .= "<col width=120>\n";				// Colonne du nombre d'amateurs
	$contenu_excel .= "<col width=120>\n";				// Colonne du nombre d'accompagnateurs
	$contenu_excel .= "<col width=120>\n";				// Colonne du nom du joueur
	$contenu_excel .= "<col width=120>\n";				// Colonne du prénom du joueur
	$contenu_excel .= "<col width=100>\n";				// Colonne du profil du joueur

	$contenu_excel .= "<tr height=30><td height=30 colspan=7 class=tableau_1>LISTE DES EQUIPES AU ".date('d/m/Y H\hi')."</td></tr>\n";
	$contenu_excel .= "<tr height=20><td height=20 colspan=7 class=tableau_2>&nbsp;</td></tr>\n";
	$contenu_excel .= "<tr height=30>\n";
		$contenu_excel .= "<td width=180 height=30 class=colonnes_titre>NOM DE L'EQUIPE</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>PROFESSIONNELS</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>AMATEURS</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>ACCOMPAGNATEURS</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>JOUEURS</td>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre> </td>\n";
		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre> </td>\n";
	$contenu_excel .= "</tr>\n";


	$requete_where = 'WHERE equipe_id<>""';

	if(strlen(trim($export_equipe_motcle))!=0){
		$requete_where .= ' AND (equipe_id LIKE "%'.$export_equipe_motcle.'%" OR equipe_nom LIKE "%'.$export_equipe_motcle.'%")';
	}

	if($export_equipe==1){
		$requete_where .= ' AND equipe_id="'.$export_equipe.'"';
	}

	if(!isset($classement) OR $classement=='nom'){
		$requete_orderby = 'equipe_nom '.$ordre;
	}elseif($classement=='statut'){
		$requete_orderby = 'equipe_active '.$ordre;
	}


	// Sélection des équipes enregistrées
	$requete_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes '.$requete_where.' ORDER BY '.$requete_orderby);
	$nb_equipes = mysqli_num_rows($requete_equipes);
	if($nb_equipes!=0){

		for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
			$resultat_equipe = mysqli_fetch_array($requete_equipes);
			$equipe_id = $resultat_equipe[0];
			$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[1])));

			// Sélection des joueurs professionnels de l'équipe sélectionnée
			$requete_joueurs_pro = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
			$nb_joueurs_pro = mysqli_num_rows($requete_joueurs_pro);

			// Sélection des joueurs amateurs de l'équipe sélectionnée
			$requete_joueurs_am = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="am"');
			$nb_joueurs_am = mysqli_num_rows($requete_joueurs_am);

			// Sélection des accompagnateurs de l'équipe sélectionnée
			$requete_joueurs_acc = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="acc"');
			$nb_joueurs_acc = mysqli_num_rows($requete_joueurs_acc);

			$contenu_excel .= "<tr height=18>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$equipe_nom."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$nb_joueurs_pro."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$nb_joueurs_am."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$nb_joueurs_acc."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2> </td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2> </td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2> </td>\n";
			$contenu_excel .= "</tr>\n";

			if(!isset($export_joueurs) OR (isset($export_joueurs) AND $export_joueurs==1)){

				// Sélection des joueurs de l'équipe
				$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom, joueur_profil FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil!="pro" ORDER BY joueur_nom, joueur_prenom');
				$nb_joueurs = mysqli_num_rows($requete_joueurs);
				if($nb_joueurs!=0){
					for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
						$resultat_joueur = mysqli_fetch_array($requete_joueurs);
						$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
						$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
						$joueur_profil = $resultat_joueur[2];

						if($joueur_profil=='pro'){ $joueur_profil = 'Professionnel'; }elseif($joueur_profil=='am'){ $joueur_profil = 'Amateur'; }else{ $joueur_profil = 'Accompagnateur'; }

						$contenu_excel .= "<tr height=18>\n";
							$contenu_excel .= "<td height=18 class=cellules_standard_2> </td>\n";
							$contenu_excel .= "<td height=18 class=cellules_standard_1> </td>\n";
							$contenu_excel .= "<td height=18 class=cellules_standard_1> </td>\n";
							$contenu_excel .= "<td height=18 class=cellules_standard_1> </td>\n";
							$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_nom."</td>\n";
							$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_prenom."</td>\n";
							$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_profil."</td>\n";
						$contenu_excel .= "</tr>\n";

					}
				}

			}

		}

	}

$contenu_excel .= "</table>\n";

$contenu_excel .= "\n</body>\n";
$contenu_excel .= "</html>\n";

/*********************************************************************************************************************/

if(!isset($archive)){

	$fichier_excel = 'Export_equipes_'.date('Y-m-d').'.xls';
	$path_temp_fichier_excel = '../../../temp/'.$fichier_excel;

	$fichier_extraction = fopen($path_temp_fichier_excel, 'w+');
	if($fichier_extraction){
		fputs($fichier_extraction, $contenu_excel);		// Ecriture dans le fichier d'extraction
	}else{
		echo 'Impossible de créer le fichier Excel pour l\'exportation de la liste des équipes.';
	}
	fclose($fichier_extraction);

	// Sortie du document Excel
	header("Content-Type: application/vnd.ms-excel");
	header("Content-Disposition: attachment; filename=$fichier_excel");
	header("Pragma: no-cache");
	header("Expires: 0");
	$document = fopen($path_temp_fichier_excel, 'r');
	fpassthru($document);
	exit;

}else{

	$path_archive_fichier_excel = '../../../archives/archive_'.$annee.'_equipes.xls';

	$fichier_extraction = fopen($path_archive_fichier_excel, 'w+');
	if($fichier_extraction){
		fputs($fichier_extraction, $contenu_excel);		// Ecriture dans le fichier d'extraction
	}else{
		echo 'Impossible de créer le fichier Excel pour l\'archivage de la liste des équipes.';
	}
	fclose($fichier_extraction);

	header('Location: ../../competitions/competitions/archiver.php?process=facturation&compet_annee='.$annee);
	exit;

}
?>